/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServer;
import io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.OpenShiftAPIServerOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class OpenShiftAPIServerHandler
implements ResourceHandler<OpenShiftAPIServer, OpenShiftAPIServerBuilder> {
    public String getKind() {
        return OpenShiftAPIServer.class.getSimpleName();
    }

    public String getApiVersion() {
        return "operator.openshift.io/v1";
    }

    public OpenShiftAPIServer create(OkHttpClient client, Config config, String namespace, OpenShiftAPIServer item) {
        return (OpenShiftAPIServer)new OpenShiftAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).create((Object[])new OpenShiftAPIServer[0]);
    }

    public OpenShiftAPIServer replace(OkHttpClient client, Config config, String namespace, OpenShiftAPIServer item) {
        return (OpenShiftAPIServer)((Resource)new OpenShiftAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).replace((Object)item);
    }

    public OpenShiftAPIServer reload(OkHttpClient client, Config config, String namespace, OpenShiftAPIServer item) {
        return (OpenShiftAPIServer)((Gettable)((Resource)new OpenShiftAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public OpenShiftAPIServerBuilder edit(OpenShiftAPIServer item) {
        return new OpenShiftAPIServerBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, OpenShiftAPIServer item) {
        return new OpenShiftAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).withPropagationPolicy(propagationPolicy).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, OpenShiftAPIServer item, Watcher<OpenShiftAPIServer> watcher) {
        return ((Resource)new OpenShiftAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, OpenShiftAPIServer item, String resourceVersion, Watcher<OpenShiftAPIServer> watcher) {
        return ((Resource)new OpenShiftAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, OpenShiftAPIServer item, ListOptions options, Watcher<OpenShiftAPIServer> watcher) {
        return ((Resource)new OpenShiftAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    public OpenShiftAPIServer waitUntilReady(OkHttpClient client, Config config, String namespace, OpenShiftAPIServer item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (OpenShiftAPIServer)((Resource)new OpenShiftAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public OpenShiftAPIServer waitUntilCondition(OkHttpClient client, Config config, String namespace, OpenShiftAPIServer item, Predicate<OpenShiftAPIServer> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (OpenShiftAPIServer)((Resource)new OpenShiftAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

