/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.OperationInfo;
import io.fabric8.kubernetes.client.dsl.BytesLimitTerminateTimeTailPrettyLoggable;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.Loggable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.PrettyLoggable;
import io.fabric8.kubernetes.client.dsl.TailPrettyLoggable;
import io.fabric8.kubernetes.client.dsl.TimeTailPrettyLoggable;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.dsl.internal.LogWatchCallback;
import io.fabric8.kubernetes.client.internal.PatchUtils;
import io.fabric8.kubernetes.client.utils.PodOperationUtil;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildBuilder;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.BuildResource;
import io.fabric8.openshift.client.dsl.internal.BuildOperationContext;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;
import io.fabric8.openshift.client.internal.patchmixins.BuildMixIn;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class BuildOperationsImpl
extends OpenShiftOperation<Build, BuildList, BuildResource<Build, LogWatch>>
implements BuildResource<Build, LogWatch> {
    public static final String OPENSHIFT_IO_BUILD_NAME = "openshift.io/build.name";
    private final InputStream in;
    private final OutputStream out;
    private final OutputStream err;
    private final PipedOutputStream inPipe;
    private final PipedInputStream outPipe;
    private final PipedInputStream errPipe;
    private final boolean withTTY;
    private final boolean withTerminatedStatus;
    private final boolean withTimestamps;
    private final String sinceTimestamp;
    private final Integer sinceSeconds;
    private final Integer withTailingLines;
    private final boolean withPrettyOutput;
    private final String version;
    private final Integer limitBytes;
    private static final Integer DEFAULT_POD_LOG_WAIT_TIMEOUT = 5;
    private Integer podLogWaitTimeout;

    public BuildOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
        this(new BuildOperationContext().withOkhttpClient(client).withConfig(config));
    }

    public BuildOperationsImpl(BuildOperationContext context) {
        super(context.withApiGroupName("build.openshift.io").withPlural("builds"));
        this.type = Build.class;
        this.listType = BuildList.class;
        this.in = context.getIn();
        this.out = context.getOut();
        this.err = context.getErr();
        this.inPipe = context.getInPipe();
        this.outPipe = context.getOutPipe();
        this.errPipe = context.getErrPipe();
        this.withTTY = context.isTty();
        this.withTerminatedStatus = context.isTerminatedStatus();
        this.withTimestamps = context.isTimestamps();
        this.sinceTimestamp = context.getSinceTimestamp();
        this.sinceSeconds = context.getSinceSeconds();
        this.withTailingLines = context.getTailingLines();
        this.withPrettyOutput = context.isPrettyOutput();
        this.version = context.getVersion();
        this.limitBytes = context.getLimitBytes();
        PatchUtils.addMixInToMapper(Build.class, BuildMixIn.class);
    }

    private BuildOperationsImpl(BuildOperationContext context, Integer podLogWaitTimeout) {
        this(context);
        this.podLogWaitTimeout = podLogWaitTimeout;
    }

    public BuildOperationsImpl newInstance(OperationContext context) {
        return new BuildOperationsImpl((BuildOperationContext)context);
    }

    BuildOperationContext getContext() {
        return (BuildOperationContext)this.context;
    }

    protected String getLogParameters() {
        StringBuilder sb = new StringBuilder();
        sb.append("log?pretty=").append(this.withPrettyOutput);
        if (this.version != null && !this.version.isEmpty()) {
            sb.append("&version=").append(this.version);
        }
        if (this.withTerminatedStatus) {
            sb.append("&previous=true");
        }
        if (this.sinceSeconds != null) {
            sb.append("&sinceSeconds=").append(this.sinceSeconds);
        } else if (this.sinceTimestamp != null) {
            sb.append("&sinceTime=").append(this.sinceTimestamp);
        }
        if (this.withTailingLines != null) {
            sb.append("&tailLines=").append(this.withTailingLines);
        }
        if (this.limitBytes != null) {
            sb.append("&limitBytes=").append(this.limitBytes);
        }
        if (this.withTimestamps) {
            sb.append("&timestamps=true");
        }
        return sb.toString();
    }

    protected ResponseBody doGetLog() {
        try {
            URL url = new URL(URLUtils.join((String[])new String[]{this.getResourceUrl().toString(), this.getLogParameters()}));
            Request.Builder requestBuilder = new Request.Builder().get().url(url);
            Request request = requestBuilder.build();
            Response response = this.client.newCall(request).execute();
            ResponseBody body = response.body();
            this.assertResponseCode(request, response);
            return body;
        }
        catch (IOException t) {
            throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType("doGetLog"), (Throwable)t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getLog() {
        try (ResponseBody body = this.doGetLog();){
            String string = this.doGetLog().string();
            return string;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType("getLog"), (Throwable)e);
        }
    }

    public String getLog(Boolean isPretty) {
        return new BuildOperationsImpl(this.getContext().withPrettyOutput(isPretty)).getLog();
    }

    public Reader getLogReader() {
        return this.doGetLog().charStream();
    }

    public LogWatch watchLog() {
        return this.watchLog(null);
    }

    public LogWatch watchLog(OutputStream out) {
        try {
            this.waitUntilBuildPodBecomesReady((Build)this.fromServer().get());
            URL url = new URL(URLUtils.join((String[])new String[]{this.getResourceUrl().toString(), this.getLogParameters() + "&follow=true"}));
            Request request = new Request.Builder().url(url).get().build();
            LogWatchCallback callback = new LogWatchCallback(out);
            OkHttpClient clone = this.client.newBuilder().readTimeout(0L, TimeUnit.MILLISECONDS).build();
            clone.newCall(request).enqueue((Callback)callback);
            callback.waitUntilReady();
            return callback;
        }
        catch (IOException t) {
            throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType("watchLog"), (Throwable)t);
        }
    }

    public Loggable<LogWatch> withLogWaitTimeout(Integer logWaitTimeout) {
        return new BuildOperationsImpl((BuildOperationContext)this.context, logWaitTimeout);
    }

    public Loggable<LogWatch> withPrettyOutput() {
        return new BuildOperationsImpl(this.getContext().withPrettyOutput(true));
    }

    public PrettyLoggable<LogWatch> tailingLines(int tailingLines) {
        return new BuildOperationsImpl(this.getContext().withTailingLines(tailingLines));
    }

    public TimeTailPrettyLoggable<LogWatch> terminated() {
        return new BuildOperationsImpl(this.getContext().withTerminatedStatus(true));
    }

    public TailPrettyLoggable<LogWatch> sinceTime(String sinceTimestamp) {
        return new BuildOperationsImpl(this.getContext().withSinceTimestamp(sinceTimestamp));
    }

    public TailPrettyLoggable<LogWatch> sinceSeconds(int sinceSeconds) {
        return new BuildOperationsImpl(this.getContext().withSinceSeconds(sinceSeconds));
    }

    public BytesLimitTerminateTimeTailPrettyLoggable<LogWatch> limitBytes(int limitBytes) {
        return new BuildOperationsImpl(this.getContext().withLimitBytes(limitBytes));
    }

    public BytesLimitTerminateTimeTailPrettyLoggable<LogWatch> usingTimestamps() {
        return new BuildOperationsImpl(this.getContext().withTimestamps(true));
    }

    public Build edit(Visitor ... visitors) {
        return (Build)this.patch((HasMetadata)((BuildBuilder)new BuildBuilder((Build)this.getMandatory()).accept(visitors)).build());
    }

    private void waitUntilBuildPodBecomesReady(Build build) {
        List podOps = PodOperationUtil.getPodOperationsForController((OperationContext)this.context, (String)build.getMetadata().getUid(), BuildOperationsImpl.getBuildPodLabels(build), (boolean)this.withPrettyOutput, (Integer)this.podLogWaitTimeout);
        BuildOperationsImpl.waitForBuildPodToBecomeReady(podOps, this.podLogWaitTimeout != null ? this.podLogWaitTimeout : DEFAULT_POD_LOG_WAIT_TIMEOUT);
    }

    private static void waitForBuildPodToBecomeReady(List<PodResource<Pod>> podOps, Integer podLogWaitTimeout) {
        for (PodResource<Pod> podOp : podOps) {
            PodOperationUtil.waitUntilReadyBeforeFetchingLogs(podOp, (Integer)podLogWaitTimeout);
        }
    }

    static Map<String, String> getBuildPodLabels(Build build) {
        HashMap<String, String> labels = new HashMap<String, String>();
        if (build != null && build.getMetadata() != null) {
            labels.put(OPENSHIFT_IO_BUILD_NAME, build.getMetadata().getName());
        }
        return labels;
    }
}

