/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.BuildResource;
import io.fabric8.openshift.client.dsl.internal.BuildOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class BuildHandler
implements ResourceHandler<Build, BuildBuilder> {
    public String getKind() {
        return Build.class.getSimpleName();
    }

    public String getApiVersion() {
        return "${apiGroup}/${apiVersion}";
    }

    public Build create(OkHttpClient client, Config config, String namespace, Build item) {
        return (Build)new BuildOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create((Object[])new Build[0]);
    }

    public Build replace(OkHttpClient client, Config config, String namespace, Build item) {
        return (Build)((BuildResource)new BuildOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    public Build reload(OkHttpClient client, Config config, String namespace, Build item) {
        return (Build)((Gettable)((BuildResource)new BuildOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public BuildBuilder edit(Build item) {
        return new BuildBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, Build item) {
        return (Boolean)new BuildOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).delete((Object[])new Build[]{item});
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, Build item, Watcher<Build> watcher) {
        return (Watch)((BuildResource)new BuildOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, Build item, String resourceVersion, Watcher<Build> watcher) {
        return (Watch)((BuildResource)new BuildOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Build waitUntilReady(OkHttpClient client, Config config, String namespace, Build item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Build)((BuildResource)new BuildOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public Build waitUntilCondition(OkHttpClient client, Config config, String namespace, Build item, Predicate<Build> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Build)((BuildResource)new BuildOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

