/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.operator.v1.KubeAPIServer;
import io.fabric8.openshift.api.model.operator.v1.KubeAPIServerBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.KubeAPIServerOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class KubeAPIServerHandler
implements ResourceHandler<KubeAPIServer, KubeAPIServerBuilder> {
    public String getKind() {
        return KubeAPIServer.class.getSimpleName();
    }

    public String getApiVersion() {
        return "operator.openshift.io/v1";
    }

    public KubeAPIServer create(OkHttpClient client, Config config, String namespace, KubeAPIServer item) {
        return (KubeAPIServer)new KubeAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).create((Object[])new KubeAPIServer[0]);
    }

    public KubeAPIServer replace(OkHttpClient client, Config config, String namespace, KubeAPIServer item) {
        return (KubeAPIServer)((Resource)new KubeAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).replace((Object)item);
    }

    public KubeAPIServer reload(OkHttpClient client, Config config, String namespace, KubeAPIServer item) {
        return (KubeAPIServer)((Gettable)((Resource)new KubeAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public KubeAPIServerBuilder edit(KubeAPIServer item) {
        return new KubeAPIServerBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, KubeAPIServer item) {
        return (Boolean)new KubeAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).withPropagationPolicy(propagationPolicy).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, KubeAPIServer item, Watcher<KubeAPIServer> watcher) {
        return (Watch)((Resource)new KubeAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, KubeAPIServer item, String resourceVersion, Watcher<KubeAPIServer> watcher) {
        return (Watch)((Resource)new KubeAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, KubeAPIServer item, ListOptions options, Watcher<KubeAPIServer> watcher) {
        return (Watch)((Resource)new KubeAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    public KubeAPIServer waitUntilReady(OkHttpClient client, Config config, String namespace, KubeAPIServer item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (KubeAPIServer)((Resource)new KubeAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public KubeAPIServer waitUntilCondition(OkHttpClient client, Config config, String namespace, KubeAPIServer item, Predicate<KubeAPIServer> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (KubeAPIServer)((Resource)new KubeAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

