/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.OperatorHub;
import io.fabric8.openshift.api.model.OperatorHubBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.OperatorHubOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class OperatorHubHandler
implements ResourceHandler<OperatorHub, OperatorHubBuilder> {
    public String getKind() {
        return OperatorHub.class.getSimpleName();
    }

    public String getApiVersion() {
        return "config.openshift.io/v1";
    }

    public OperatorHub create(OkHttpClient client, Config config, String namespace, OperatorHub item) {
        return (OperatorHub)new OperatorHubOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).create((Object[])new OperatorHub[0]);
    }

    public OperatorHub replace(OkHttpClient client, Config config, String namespace, OperatorHub item) {
        return (OperatorHub)((Resource)new OperatorHubOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).replace((Object)item);
    }

    public OperatorHub reload(OkHttpClient client, Config config, String namespace, OperatorHub item) {
        return (OperatorHub)((Gettable)((Resource)new OperatorHubOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public OperatorHubBuilder edit(OperatorHub item) {
        return new OperatorHubBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, OperatorHub item) {
        return (Boolean)new OperatorHubOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).withPropagationPolicy(propagationPolicy).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, OperatorHub item, Watcher<OperatorHub> watcher) {
        return (Watch)((Resource)new OperatorHubOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, OperatorHub item, String resourceVersion, Watcher<OperatorHub> watcher) {
        return (Watch)((Resource)new OperatorHubOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, OperatorHub item, ListOptions options, Watcher<OperatorHub> watcher) {
        return (Watch)((Resource)new OperatorHubOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    public OperatorHub waitUntilReady(OkHttpClient client, Config config, String namespace, OperatorHub item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (OperatorHub)((Resource)new OperatorHubOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public OperatorHub waitUntilCondition(OkHttpClient client, Config config, String namespace, OperatorHub item, Predicate<OperatorHub> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (OperatorHub)((Resource)new OperatorHubOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

