/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.console.v1.ConsoleNotification;
import io.fabric8.openshift.api.model.console.v1.ConsoleNotificationBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.ConsoleNotificationOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class ConsoleNotificationHandler
implements ResourceHandler<ConsoleNotification, ConsoleNotificationBuilder> {
    public String getKind() {
        return ConsoleNotification.class.getSimpleName();
    }

    public String getApiVersion() {
        return "console.openshift.io/v1";
    }

    public ConsoleNotification create(OkHttpClient client, Config config, String namespace, ConsoleNotification item) {
        return (ConsoleNotification)new ConsoleNotificationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).create((Object[])new ConsoleNotification[0]);
    }

    public ConsoleNotification replace(OkHttpClient client, Config config, String namespace, ConsoleNotification item) {
        return (ConsoleNotification)((Resource)new ConsoleNotificationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).replace((Object)item);
    }

    public ConsoleNotification reload(OkHttpClient client, Config config, String namespace, ConsoleNotification item) {
        return (ConsoleNotification)((Gettable)((Resource)new ConsoleNotificationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public ConsoleNotificationBuilder edit(ConsoleNotification item) {
        return new ConsoleNotificationBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, ConsoleNotification item) {
        return (Boolean)new ConsoleNotificationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).withPropagationPolicy(propagationPolicy).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ConsoleNotification item, Watcher<ConsoleNotification> watcher) {
        return (Watch)((Resource)new ConsoleNotificationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ConsoleNotification item, String resourceVersion, Watcher<ConsoleNotification> watcher) {
        return (Watch)((Resource)new ConsoleNotificationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ConsoleNotification item, ListOptions options, Watcher<ConsoleNotification> watcher) {
        return (Watch)((Resource)new ConsoleNotificationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    public ConsoleNotification waitUntilReady(OkHttpClient client, Config config, String namespace, ConsoleNotification item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ConsoleNotification)((Resource)new ConsoleNotificationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public ConsoleNotification waitUntilCondition(OkHttpClient client, Config config, String namespace, ConsoleNotification item, Predicate<ConsoleNotification> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ConsoleNotification)((Resource)new ConsoleNotificationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

