/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.operator.v1.DNS;
import io.fabric8.openshift.api.model.operator.v1.DNSBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.DNSOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class DNSHandler
implements ResourceHandler<DNS, DNSBuilder> {
    public String getKind() {
        return DNS.class.getSimpleName();
    }

    public String getApiVersion() {
        return "operator.openshift.io/v1";
    }

    public DNS create(OkHttpClient client, Config config, String namespace, DNS item) {
        return (DNS)new DNSOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).create((Object[])new DNS[0]);
    }

    public DNS replace(OkHttpClient client, Config config, String namespace, DNS item) {
        return (DNS)((Resource)new DNSOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).replace((Object)item);
    }

    public DNS reload(OkHttpClient client, Config config, String namespace, DNS item) {
        return (DNS)((Gettable)((Resource)new DNSOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public DNSBuilder edit(DNS item) {
        return new DNSBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, DNS item) {
        return (Boolean)new DNSOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).withPropagationPolicy(propagationPolicy).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, DNS item, Watcher<DNS> watcher) {
        return (Watch)((Resource)new DNSOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, DNS item, String resourceVersion, Watcher<DNS> watcher) {
        return (Watch)((Resource)new DNSOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, DNS item, ListOptions options, Watcher<DNS> watcher) {
        return (Watch)((Resource)new DNSOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    public DNS waitUntilReady(OkHttpClient client, Config config, String namespace, DNS item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (DNS)((Resource)new DNSOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public DNS waitUntilCondition(OkHttpClient client, Config config, String namespace, DNS item, Predicate<DNS> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (DNS)((Resource)new DNSOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

