/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.APIServer;
import io.fabric8.openshift.api.model.APIServerBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.APIServerOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class APIServerHandler
implements ResourceHandler<APIServer, APIServerBuilder> {
    public String getKind() {
        return APIServer.class.getSimpleName();
    }

    public String getApiVersion() {
        return "config.openshift.io/v1";
    }

    public APIServer create(OkHttpClient client, Config config, String namespace, APIServer item) {
        return (APIServer)new APIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).create((Object[])new APIServer[0]);
    }

    public APIServer replace(OkHttpClient client, Config config, String namespace, APIServer item) {
        return (APIServer)((Resource)new APIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).replace((Object)item);
    }

    public APIServer reload(OkHttpClient client, Config config, String namespace, APIServer item) {
        return (APIServer)((Gettable)((Resource)new APIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public APIServerBuilder edit(APIServer item) {
        return new APIServerBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, APIServer item) {
        return (Boolean)new APIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).withPropagationPolicy(propagationPolicy).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, APIServer item, Watcher<APIServer> watcher) {
        return (Watch)((Resource)new APIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, APIServer item, String resourceVersion, Watcher<APIServer> watcher) {
        return (Watch)((Resource)new APIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, APIServer item, ListOptions options, Watcher<APIServer> watcher) {
        return (Watch)((Resource)new APIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    public APIServer waitUntilReady(OkHttpClient client, Config config, String namespace, APIServer item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (APIServer)((Resource)new APIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public APIServer waitUntilCondition(OkHttpClient client, Config config, String namespace, APIServer item, Predicate<APIServer> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (APIServer)((Resource)new APIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

