/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client;

import io.fabric8.kubernetes.api.model.ComponentStatus;
import io.fabric8.kubernetes.api.model.ComponentStatusList;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.DoneableComponentStatus;
import io.fabric8.kubernetes.api.model.DoneableConfigMap;
import io.fabric8.kubernetes.api.model.DoneableEndpoints;
import io.fabric8.kubernetes.api.model.DoneableEvent;
import io.fabric8.kubernetes.api.model.DoneableLimitRange;
import io.fabric8.kubernetes.api.model.DoneableNamespace;
import io.fabric8.kubernetes.api.model.DoneableNode;
import io.fabric8.kubernetes.api.model.DoneablePersistentVolume;
import io.fabric8.kubernetes.api.model.DoneablePersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.DoneableReplicationController;
import io.fabric8.kubernetes.api.model.DoneableResourceQuota;
import io.fabric8.kubernetes.api.model.DoneableSecret;
import io.fabric8.kubernetes.api.model.DoneableService;
import io.fabric8.kubernetes.api.model.DoneableServiceAccount;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsList;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.EventList;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.LimitRange;
import io.fabric8.kubernetes.api.model.LimitRangeList;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceList;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.NodeList;
import io.fabric8.kubernetes.api.model.PersistentVolume;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimList;
import io.fabric8.kubernetes.api.model.PersistentVolumeList;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.model.ResourceQuotaList;
import io.fabric8.kubernetes.api.model.RootPaths;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceAccountList;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionList;
import io.fabric8.kubernetes.api.model.apiextensions.DoneableCustomResourceDefinition;
import io.fabric8.kubernetes.client.AppsAPIGroupClient;
import io.fabric8.kubernetes.client.AutoscalingAPIGroupClient;
import io.fabric8.kubernetes.client.BaseClient;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.ExtensionsAPIGroupClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import io.fabric8.kubernetes.client.RequestConfig;
import io.fabric8.kubernetes.client.WithRequestCallable;
import io.fabric8.kubernetes.client.dsl.AppsAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.AutoscalingAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.FunctionCallable;
import io.fabric8.kubernetes.client.dsl.KubernetesListMixedOperation;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ParameterMixedOperation;
import io.fabric8.kubernetes.client.dsl.ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.internal.ComponentStatusOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.CustomResourceDefinitionOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.CustomResourceOperationsImpl;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigList;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.api.model.ClusterRoleBinding;
import io.fabric8.openshift.api.model.ClusterRoleBindingList;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigList;
import io.fabric8.openshift.api.model.DoneableBuild;
import io.fabric8.openshift.api.model.DoneableBuildConfig;
import io.fabric8.openshift.api.model.DoneableClusterRoleBinding;
import io.fabric8.openshift.api.model.DoneableDeploymentConfig;
import io.fabric8.openshift.api.model.DoneableGroup;
import io.fabric8.openshift.api.model.DoneableImageStream;
import io.fabric8.openshift.api.model.DoneableImageStreamTag;
import io.fabric8.openshift.api.model.DoneableOAuthAccessToken;
import io.fabric8.openshift.api.model.DoneableOAuthAuthorizeToken;
import io.fabric8.openshift.api.model.DoneableOAuthClient;
import io.fabric8.openshift.api.model.DoneablePolicy;
import io.fabric8.openshift.api.model.DoneablePolicyBinding;
import io.fabric8.openshift.api.model.DoneableProject;
import io.fabric8.openshift.api.model.DoneableRole;
import io.fabric8.openshift.api.model.DoneableRoleBinding;
import io.fabric8.openshift.api.model.DoneableRoute;
import io.fabric8.openshift.api.model.DoneableSecurityContextConstraints;
import io.fabric8.openshift.api.model.DoneableTemplate;
import io.fabric8.openshift.api.model.DoneableUser;
import io.fabric8.openshift.api.model.Group;
import io.fabric8.openshift.api.model.GroupList;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamList;
import io.fabric8.openshift.api.model.ImageStreamTag;
import io.fabric8.openshift.api.model.ImageStreamTagList;
import io.fabric8.openshift.api.model.OAuthAccessToken;
import io.fabric8.openshift.api.model.OAuthAccessTokenList;
import io.fabric8.openshift.api.model.OAuthAuthorizeToken;
import io.fabric8.openshift.api.model.OAuthAuthorizeTokenList;
import io.fabric8.openshift.api.model.OAuthClient;
import io.fabric8.openshift.api.model.OAuthClientList;
import io.fabric8.openshift.api.model.Policy;
import io.fabric8.openshift.api.model.PolicyBinding;
import io.fabric8.openshift.api.model.PolicyBindingList;
import io.fabric8.openshift.api.model.PolicyList;
import io.fabric8.openshift.api.model.Project;
import io.fabric8.openshift.api.model.ProjectList;
import io.fabric8.openshift.api.model.Role;
import io.fabric8.openshift.api.model.RoleBinding;
import io.fabric8.openshift.api.model.RoleBindingList;
import io.fabric8.openshift.api.model.RoleList;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteList;
import io.fabric8.openshift.api.model.SecurityContextConstraints;
import io.fabric8.openshift.api.model.SecurityContextConstraintsList;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.api.model.TemplateList;
import io.fabric8.openshift.api.model.User;
import io.fabric8.openshift.api.model.UserList;
import io.fabric8.openshift.client.NamespacedOpenShiftClient;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.OpenShiftConfigBuilder;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import io.fabric8.openshift.client.dsl.BuildResource;
import io.fabric8.openshift.client.dsl.CreateableLocalSubjectAccessReview;
import io.fabric8.openshift.client.dsl.CreateableSubjectAccessReview;
import io.fabric8.openshift.client.dsl.DeployableScalableResource;
import io.fabric8.openshift.client.dsl.ProjectRequestOperation;
import io.fabric8.openshift.client.dsl.SubjectAccessReviewOperation;
import io.fabric8.openshift.client.dsl.TemplateResource;
import io.fabric8.openshift.client.dsl.internal.BuildConfigOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.BuildOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.ClusterRoleBindingOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.DeploymentConfigOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.GroupOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.ImageStreamOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.ImageStreamTagOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.OAuthAccessTokenOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.OAuthAuthorizeTokenOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.OAuthClientOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.PolicyBindingOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.PolicyOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.ProjectOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.ProjectRequestsOperationImpl;
import io.fabric8.openshift.client.dsl.internal.RoleBindingOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.RoleOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.RouteOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.SubjectAccessReviewOperationImpl;
import io.fabric8.openshift.client.dsl.internal.TemplateOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.UserOperationsImpl;
import io.fabric8.openshift.client.internal.OpenShiftOAuthInterceptor;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import okhttp3.Authenticator;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class DefaultOpenShiftClient
extends BaseClient
implements NamespacedOpenShiftClient {
    private URL openShiftUrl;
    private NamespacedKubernetesClient delegate;

    public DefaultOpenShiftClient() throws KubernetesClientException {
        this(new OpenShiftConfigBuilder().build());
    }

    public DefaultOpenShiftClient(String masterUrl) throws KubernetesClientException {
        this(((OpenShiftConfigBuilder)new OpenShiftConfigBuilder().withMasterUrl(masterUrl)).build());
    }

    public DefaultOpenShiftClient(Config config) throws KubernetesClientException {
        this(new OpenShiftConfig(config));
    }

    public DefaultOpenShiftClient(OpenShiftConfig config) throws KubernetesClientException {
        super((Config)config);
        try {
            this.httpClient = this.clientWithOpenShiftOAuthInterceptor(this.httpClient);
            this.delegate = new DefaultKubernetesClient(this.httpClient, (Config)config);
            this.openShiftUrl = new URL(config.getOpenShiftUrl());
        }
        catch (MalformedURLException e) {
            throw new KubernetesClientException("Could not create client", (Throwable)e);
        }
    }

    public DefaultOpenShiftClient(OkHttpClient httpClient, OpenShiftConfig config) throws KubernetesClientException {
        super(httpClient, (Config)config);
        try {
            this.delegate = new DefaultKubernetesClient(this.clientWithOpenShiftOAuthInterceptor(httpClient), (Config)config);
            this.openShiftUrl = new URL(config.getOpenShiftUrl());
        }
        catch (MalformedURLException e) {
            throw new KubernetesClientException("Could not create client", (Throwable)e);
        }
    }

    public static DefaultOpenShiftClient fromConfig(String config) {
        return new DefaultOpenShiftClient((OpenShiftConfig)((Object)Serialization.unmarshal((String)config, OpenShiftConfig.class)));
    }

    public static DefaultOpenShiftClient fromConfig(InputStream is) {
        return new DefaultOpenShiftClient((OpenShiftConfig)((Object)Serialization.unmarshal((InputStream)is, OpenShiftConfig.class)));
    }

    private OkHttpClient clientWithOpenShiftOAuthInterceptor(OkHttpClient httpClient) {
        httpClient = httpClient.newBuilder().authenticator(Authenticator.NONE).build();
        OkHttpClient.Builder builder = httpClient.newBuilder();
        builder.interceptors().clear();
        return builder.addInterceptor((Interceptor)new OpenShiftOAuthInterceptor(httpClient, OpenShiftConfig.wrap(this.getConfiguration()))).build();
    }

    @Override
    public URL getOpenshiftUrl() {
        return this.openShiftUrl;
    }

    public MixedOperation<ComponentStatus, ComponentStatusList, DoneableComponentStatus, Resource<ComponentStatus, DoneableComponentStatus>> componentstatuses() {
        return new ComponentStatusOperationsImpl(this.httpClient, this.getConfiguration());
    }

    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> load(InputStream is) {
        return this.delegate.load(is);
    }

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata, Boolean> resource(HasMetadata item) {
        return this.delegate.resource(item);
    }

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata, Boolean> resource(String s) {
        return this.delegate.resource(s);
    }

    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(KubernetesResourceList is) {
        return this.delegate.resourceList(is);
    }

    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(HasMetadata ... items) {
        return this.delegate.resourceList(items);
    }

    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(Collection<HasMetadata> items) {
        return this.delegate.resourceList(items);
    }

    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(String s) {
        return this.delegate.resourceList(s);
    }

    public MixedOperation<Endpoints, EndpointsList, DoneableEndpoints, Resource<Endpoints, DoneableEndpoints>> endpoints() {
        return this.delegate.endpoints();
    }

    public MixedOperation<Event, EventList, DoneableEvent, Resource<Event, DoneableEvent>> events() {
        return this.delegate.events();
    }

    public NonNamespaceOperation<Namespace, NamespaceList, DoneableNamespace, Resource<Namespace, DoneableNamespace>> namespaces() {
        return this.delegate.namespaces();
    }

    public NonNamespaceOperation<Node, NodeList, DoneableNode, Resource<Node, DoneableNode>> nodes() {
        return this.delegate.nodes();
    }

    public NonNamespaceOperation<PersistentVolume, PersistentVolumeList, DoneablePersistentVolume, Resource<PersistentVolume, DoneablePersistentVolume>> persistentVolumes() {
        return this.delegate.persistentVolumes();
    }

    public MixedOperation<PersistentVolumeClaim, PersistentVolumeClaimList, DoneablePersistentVolumeClaim, Resource<PersistentVolumeClaim, DoneablePersistentVolumeClaim>> persistentVolumeClaims() {
        return this.delegate.persistentVolumeClaims();
    }

    public MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> pods() {
        return this.delegate.pods();
    }

    public MixedOperation<ReplicationController, ReplicationControllerList, DoneableReplicationController, RollableScalableResource<ReplicationController, DoneableReplicationController>> replicationControllers() {
        return this.delegate.replicationControllers();
    }

    public MixedOperation<ResourceQuota, ResourceQuotaList, DoneableResourceQuota, Resource<ResourceQuota, DoneableResourceQuota>> resourceQuotas() {
        return this.delegate.resourceQuotas();
    }

    public MixedOperation<Secret, SecretList, DoneableSecret, Resource<Secret, DoneableSecret>> secrets() {
        return this.delegate.secrets();
    }

    public MixedOperation<Service, ServiceList, DoneableService, Resource<Service, DoneableService>> services() {
        return this.delegate.services();
    }

    public MixedOperation<ServiceAccount, ServiceAccountList, DoneableServiceAccount, Resource<ServiceAccount, DoneableServiceAccount>> serviceAccounts() {
        return this.delegate.serviceAccounts();
    }

    public KubernetesListMixedOperation lists() {
        return this.delegate.lists();
    }

    public NonNamespaceOperation<SecurityContextConstraints, SecurityContextConstraintsList, DoneableSecurityContextConstraints, Resource<SecurityContextConstraints, DoneableSecurityContextConstraints>> securityContextConstraints() {
        return this.delegate.securityContextConstraints();
    }

    public MixedOperation<ConfigMap, ConfigMapList, DoneableConfigMap, Resource<ConfigMap, DoneableConfigMap>> configMaps() {
        return this.delegate.configMaps();
    }

    public MixedOperation<LimitRange, LimitRangeList, DoneableLimitRange, Resource<LimitRange, DoneableLimitRange>> limitRanges() {
        return this.delegate.limitRanges();
    }

    public <T extends HasMetadata, L extends KubernetesResourceList, D extends Doneable<T>> MixedOperation<T, L, D, Resource<T, D>> customResources(CustomResourceDefinition crd, Class<T> resourceType, Class<L> listClass, Class<D> doneClass) {
        return new CustomResourceOperationsImpl(this.httpClient, this.getConfiguration(), crd, resourceType, listClass, doneClass);
    }

    public <T extends HasMetadata, L extends KubernetesResourceList, D extends Doneable<T>> MixedOperation<T, L, D, Resource<T, D>> customResource(CustomResourceDefinition crd, Class<T> resourceType, Class<L> listClass, Class<D> doneClass) {
        return this.customResources(crd, resourceType, listClass, doneClass);
    }

    public NonNamespaceOperation<CustomResourceDefinition, CustomResourceDefinitionList, DoneableCustomResourceDefinition, Resource<CustomResourceDefinition, DoneableCustomResourceDefinition>> customResourceDefinitions() {
        return new CustomResourceDefinitionOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<Build, BuildList, DoneableBuild, BuildResource<Build, DoneableBuild, String, LogWatch>> builds() {
        return new BuildOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), this.getNamespace());
    }

    @Override
    public MixedOperation<BuildConfig, BuildConfigList, DoneableBuildConfig, BuildConfigResource<BuildConfig, DoneableBuildConfig, Void, Build>> buildConfigs() {
        return new BuildConfigOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), this.getNamespace());
    }

    @Override
    public MixedOperation<DeploymentConfig, DeploymentConfigList, DoneableDeploymentConfig, DeployableScalableResource<DeploymentConfig, DoneableDeploymentConfig>> deploymentConfigs() {
        return new DeploymentConfigOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), this.getNamespace());
    }

    public MixedOperation<Group, GroupList, DoneableGroup, Resource<Group, DoneableGroup>> groups() {
        return new GroupOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), this.getNamespace());
    }

    @Override
    public MixedOperation<ImageStream, ImageStreamList, DoneableImageStream, Resource<ImageStream, DoneableImageStream>> imageStreams() {
        return new ImageStreamOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), this.getNamespace());
    }

    @Override
    public MixedOperation<ImageStreamTag, ImageStreamTagList, DoneableImageStreamTag, Resource<ImageStreamTag, DoneableImageStreamTag>> imageStreamTags() {
        return new ImageStreamTagOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), this.getNamespace());
    }

    @Override
    public NonNamespaceOperation<OAuthAccessToken, OAuthAccessTokenList, DoneableOAuthAccessToken, Resource<OAuthAccessToken, DoneableOAuthAccessToken>> oAuthAccessTokens() {
        return new OAuthAccessTokenOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<OAuthAuthorizeToken, OAuthAuthorizeTokenList, DoneableOAuthAuthorizeToken, Resource<OAuthAuthorizeToken, DoneableOAuthAuthorizeToken>> oAuthAuthorizeTokens() {
        return new OAuthAuthorizeTokenOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<OAuthClient, OAuthClientList, DoneableOAuthClient, Resource<OAuthClient, DoneableOAuthClient>> oAuthClients() {
        return new OAuthClientOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public MixedOperation<Policy, PolicyList, DoneablePolicy, Resource<Policy, DoneablePolicy>> policies() {
        return new PolicyOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), this.getNamespace());
    }

    @Override
    public MixedOperation<PolicyBinding, PolicyBindingList, DoneablePolicyBinding, Resource<PolicyBinding, DoneablePolicyBinding>> policyBindings() {
        return new PolicyBindingOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), this.getNamespace());
    }

    @Override
    public NonNamespaceOperation<Project, ProjectList, DoneableProject, Resource<Project, DoneableProject>> projects() {
        return new ProjectOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public ProjectRequestOperation projectrequests() {
        return new ProjectRequestsOperationImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public MixedOperation<Role, RoleList, DoneableRole, Resource<Role, DoneableRole>> roles() {
        return new RoleOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), this.getNamespace());
    }

    @Override
    public MixedOperation<RoleBinding, RoleBindingList, DoneableRoleBinding, Resource<RoleBinding, DoneableRoleBinding>> roleBindings() {
        return new RoleBindingOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), this.getNamespace());
    }

    @Override
    public MixedOperation<Route, RouteList, DoneableRoute, Resource<Route, DoneableRoute>> routes() {
        return new RouteOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), this.getNamespace());
    }

    @Override
    public ParameterMixedOperation<Template, TemplateList, DoneableTemplate, TemplateResource<Template, KubernetesList, DoneableTemplate>> templates() {
        return new TemplateOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), this.getNamespace());
    }

    public MixedOperation<User, UserList, DoneableUser, Resource<User, DoneableUser>> users() {
        return new UserOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), this.getNamespace());
    }

    @Override
    public SubjectAccessReviewOperation<CreateableSubjectAccessReview, CreateableLocalSubjectAccessReview> subjectAccessReviews() {
        return new SubjectAccessReviewOperationImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), null, this.getNamespace());
    }

    @Override
    public MixedOperation<ClusterRoleBinding, ClusterRoleBindingList, DoneableClusterRoleBinding, Resource<ClusterRoleBinding, DoneableClusterRoleBinding>> clusterRoleBindings() {
        return new ClusterRoleBindingOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), this.getNamespace());
    }

    public NamespacedOpenShiftClient inNamespace(String namespace) {
        OpenShiftConfig updated = ((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)new OpenShiftConfigBuilder(new OpenShiftConfig(this.getConfiguration())).withOpenShiftUrl(this.openShiftUrl.toString())).withNamespace(namespace)).build();
        return new DefaultOpenShiftClient(this.httpClient, updated);
    }

    public NamespacedOpenShiftClient inAnyNamespace() {
        return this.inNamespace(null);
    }

    public ExtensionsAPIGroupClient extensions() {
        return (ExtensionsAPIGroupClient)this.adapt(ExtensionsAPIGroupClient.class);
    }

    @Override
    public AppsAPIGroupDSL apps() {
        return (AppsAPIGroupDSL)this.adapt(AppsAPIGroupClient.class);
    }

    @Override
    public AutoscalingAPIGroupDSL autoscaling() {
        return (AutoscalingAPIGroupDSL)this.adapt(AutoscalingAPIGroupClient.class);
    }

    public FunctionCallable<NamespacedOpenShiftClient> withRequestConfig(RequestConfig requestConfig) {
        return new WithRequestCallable((Client)this, requestConfig);
    }

    @Override
    public User currentUser() {
        return (User)((Resource)this.users().withName("~")).get();
    }

    @Override
    public boolean supportsOpenShiftAPIGroup(String apiGroup) {
        List paths;
        String apiGroupPath = "/apis/" + apiGroup;
        RootPaths rootPaths = this.rootPaths();
        if (rootPaths != null && (paths = rootPaths.getPaths()) != null) {
            for (String path : paths) {
                if (!Objects.equals("/oapi", path) && !Objects.equals("oapi", path) && !Objects.equals(apiGroupPath, path)) continue;
                return true;
            }
        }
        return false;
    }
}

