/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.openshift.client.OpenShiftConfig;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import okhttp3.OkHttpClient;

public class OpenShiftOperation<T extends HasMetadata, L extends KubernetesResourceList, D extends Doneable<T>, R extends Resource<T, D>>
extends HasMetadataOperation<T, L, D, R> {
    protected OpenShiftOperation(OkHttpClient client, OpenShiftConfig config, String apiGroup, String apiVersion, String resourceT, String namespace, String name, Boolean cascading, T item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields) {
        super(client, (Config)config, apiGroup, apiVersion, resourceT, namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields);
    }

    public URL getRootUrl() {
        try {
            return new URL(OpenShiftConfig.wrap(this.getConfig()).getOpenShiftUrl());
        }
        catch (MalformedURLException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    public OpenShiftOperation<T, L, D, R> inNamespace(String namespace) {
        try {
            return (OpenShiftOperation)((Object)((Object)((Object)this)).getClass().getConstructor(OkHttpClient.class, OpenShiftConfig.class, String.class, String.class, String.class, Boolean.class, this.getType(), String.class, Boolean.class, Long.TYPE, Map.class, Map.class, Map.class, Map.class, Map.class).newInstance(new Object[]{this.client, this.getConfig(), this.getAPIVersion(), namespace, this.getName(), this.isCascading(), this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields()}));
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable((Throwable)t);
        }
    }

    public OpenShiftConfig getConfig() {
        return OpenShiftConfig.wrap(super.getConfig());
    }

    protected Class<? extends Config> getConfigType() {
        return OpenShiftConfig.class;
    }
}

