/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.dsl.Reaper;
import io.fabric8.kubernetes.client.dsl.internal.ReplicationControllerOperationsImpl;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.DeploymentConfigList;
import io.fabric8.openshift.api.model.DoneableDeploymentConfig;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;

public class DeploymentConfigOperationsImpl
extends OpenShiftOperation<DeploymentConfig, DeploymentConfigList, DoneableDeploymentConfig, ClientResource<DeploymentConfig, DoneableDeploymentConfig>> {
    public DeploymentConfigOperationsImpl(OkHttpClient client, OpenShiftConfig config, String namespace) {
        this(client, config, null, namespace, null, true, null, null, false, -1L, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>());
    }

    public DeploymentConfigOperationsImpl(OkHttpClient client, OpenShiftConfig config, String apiVersion, String namespace, String name, Boolean cascading, DeploymentConfig item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields) {
        super(client, config, null, apiVersion, "deploymentconfigs", namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields);
        this.reaper = new DeploymentConfigReaper(this, client);
    }

    public DoneableDeploymentConfig edit() {
        if (this.isCascading().booleanValue()) {
            return (DoneableDeploymentConfig)this.cascading(false).edit();
        }
        return (DoneableDeploymentConfig)super.edit();
    }

    public DeploymentConfig replace(DeploymentConfig item) {
        if (this.isCascading().booleanValue()) {
            return (DeploymentConfig)this.cascading(false).replace((Object)item);
        }
        return (DeploymentConfig)super.replace((HasMetadata)item);
    }

    public DeploymentConfig patch(DeploymentConfig item) {
        if (this.isCascading().booleanValue()) {
            return (DeploymentConfig)this.cascading(false).patch((Object)item);
        }
        return (DeploymentConfig)super.patch((HasMetadata)item);
    }

    private static class DeploymentConfigReaper
    implements Reaper {
        private final DeploymentConfigOperationsImpl operation;
        private final OkHttpClient client;

        public DeploymentConfigReaper(DeploymentConfigOperationsImpl operation, OkHttpClient client) {
            this.operation = operation;
            this.client = client;
        }

        public void reap() {
            DeploymentConfig deployment = ((DoneableDeploymentConfig)((DeploymentConfigFluent.SpecNested)((DoneableDeploymentConfig)this.operation.cascading(false).edit()).editSpec().withReplicas(Integer.valueOf(0))).endSpec()).done();
            this.waitForObservedGeneration(deployment.getStatus().getObservedGeneration());
            Map selector = deployment.getSpec().getSelector();
            if (selector != null && !selector.isEmpty()) {
                Boolean bl = (Boolean)new ReplicationControllerOperationsImpl(this.client, (Config)this.operation.getConfig(), this.operation.getNamespace()).withLabels(selector).delete();
            }
        }

        private void waitForObservedGeneration(final long observedGeneration) {
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            Runnable deploymentPoller = new Runnable(){

                @Override
                public void run() {
                    DeploymentConfig deployment = (DeploymentConfig)DeploymentConfigReaper.this.operation.getMandatory();
                    if (observedGeneration <= deployment.getStatus().getObservedGeneration()) {
                        countDownLatch.countDown();
                    }
                }
            };
            ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
            ScheduledFuture<?> poller = executor.scheduleWithFixedDelay(deploymentPoller, 0L, 10L, TimeUnit.MILLISECONDS);
            try {
                countDownLatch.await(1L, TimeUnit.MINUTES);
                executor.shutdown();
            }
            catch (InterruptedException e) {
                poller.cancel(true);
                executor.shutdown();
                throw KubernetesClientException.launderThrowable((Throwable)e);
            }
        }
    }
}

