/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client;

import com.squareup.okhttp.OkHttpClient;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.ExtensionAdapter;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import io.fabric8.openshift.client.NamespacedOpenShiftClient;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.OpenShiftNotAvailableException;
import io.fabric8.openshift.client.OpenshiftAdapterSupport;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;

@Component
@Service
public class NamespacedOpenShiftExtensionAdapter
extends OpenshiftAdapterSupport
implements ExtensionAdapter<NamespacedOpenShiftClient> {
    private static final ConcurrentMap<URL, Boolean> IS_OPENSHIFT = new ConcurrentHashMap<URL, Boolean>();

    public Class<NamespacedOpenShiftClient> getExtensionType() {
        return NamespacedOpenShiftClient.class;
    }

    public NamespacedOpenShiftClient adapt(Client client) {
        if (!this.isAdaptable(client).booleanValue()) {
            throw new OpenShiftNotAvailableException("OpenShift is not available. Root paths at: " + client.getMasterUrl() + " do not include oapi.");
        }
        return new DefaultOpenShiftClient((OkHttpClient)client.adapt(OkHttpClient.class), OpenShiftConfig.wrap(client.getConfiguration()));
    }
}

