/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.dsl.internal;

import com.ning.http.client.AsyncHttpClient;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.internal.OperationSupport;
import io.fabric8.openshift.api.model.DoneableProjectRequest;
import io.fabric8.openshift.api.model.ProjectRequest;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.ClientProjectRequestOperation;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.ExecutionException;

public class ProjectRequestsOperationImpl
extends OperationSupport<OpenShiftClient>
implements ClientProjectRequestOperation {
    private final ProjectRequest item;

    public ProjectRequestsOperationImpl(OpenShiftClient client) {
        this(client, null);
    }

    public ProjectRequestsOperationImpl(OpenShiftClient client, ProjectRequest item) {
        super((Client)client, "projectrequests", null, null);
        this.item = item;
    }

    public boolean isNamespaceRequired() {
        return false;
    }

    public URL getRootUrl() {
        return ((OpenShiftClient)this.getClient()).getOpenshiftUrl();
    }

    public ProjectRequest create(ProjectRequest ... resources) {
        try {
            if (resources.length > 1) {
                throw new IllegalArgumentException("Too many items to create.");
            }
            if (resources.length == 1) {
                return (ProjectRequest)this.handleCreate(resources[0], ProjectRequest.class);
            }
            if (this.getItem() == null) {
                throw new IllegalArgumentException("Nothing to create.");
            }
            return (ProjectRequest)this.handleCreate(this.getItem(), ProjectRequest.class);
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    public DoneableProjectRequest createNew() {
        Visitor<ProjectRequest> visitor = new Visitor<ProjectRequest>(){

            public void visit(ProjectRequest resource) {
                try {
                    ProjectRequestsOperationImpl.this.create(resource);
                }
                catch (Exception e) {
                    throw KubernetesClientException.launderThrowable((Throwable)e);
                }
            }
        };
        return new DoneableProjectRequest((Visitor)visitor);
    }

    public Status list() {
        try {
            URL requestUrl = this.getNamespacedUrl();
            AsyncHttpClient.BoundRequestBuilder requestBuilder = ((OpenShiftClient)this.getClient()).getHttpClient().prepareGet(requestUrl.toString());
            return (Status)this.handleResponse(requestBuilder, 200, Status.class);
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    public ProjectRequest getItem() {
        return this.item;
    }
}

