/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client;

import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.ConfigFluent;

public class OpenshiftConfigFluent<T extends OpenshiftConfigFluent<T>>
extends ConfigFluent<T>
implements Fluent<T> {
    String oapiVersion;
    String openShiftUrl;
    VisitableBuilder<Config, ?> kubernetesConfig;

    public String getOapiVersion() {
        return this.oapiVersion;
    }

    public T withOapiVersion(String oapiVersion) {
        this.oapiVersion = oapiVersion;
        return (T)((Object)this);
    }

    public String getOpenShiftUrl() {
        return this.openShiftUrl;
    }

    public T withOpenShiftUrl(String openShiftUrl) {
        this.openShiftUrl = openShiftUrl;
        return (T)((Object)this);
    }

    public Config getKubernetesConfig() {
        return this.kubernetesConfig != null ? (Config)this.kubernetesConfig.build() : null;
    }

    public T withKubernetesConfig(Config kubernetesConfig) {
        if (kubernetesConfig != null) {
            this.kubernetesConfig = new ConfigBuilder(kubernetesConfig);
            this._visitables.add(this.kubernetesConfig);
        }
        return (T)((Object)this);
    }

    public KubernetesConfigNested<T> withNewKubernetesConfig() {
        return new KubernetesConfigNested();
    }

    public KubernetesConfigNested<T> withNewKubernetesConfigLike(Config item) {
        return new KubernetesConfigNested(item);
    }

    public KubernetesConfigNested<T> editKubernetesConfig() {
        return this.withNewKubernetesConfigLike(this.getKubernetesConfig());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OpenshiftConfigFluent that = (OpenshiftConfigFluent)((Object)o);
        if (this.oapiVersion != null ? !this.oapiVersion.equals(that.oapiVersion) : that.oapiVersion != null) {
            return false;
        }
        if (this.openShiftUrl != null ? !this.openShiftUrl.equals(that.openShiftUrl) : that.openShiftUrl != null) {
            return false;
        }
        return !(this.kubernetesConfig != null ? !this.kubernetesConfig.equals(that.kubernetesConfig) : that.kubernetesConfig != null);
    }

    public class KubernetesConfigNested<N>
    extends ConfigFluent<KubernetesConfigNested<N>>
    implements Nested<N> {
        private final ConfigBuilder builder;

        KubernetesConfigNested(Config item) {
            this.builder = new ConfigBuilder((ConfigFluent)this, item);
        }

        KubernetesConfigNested() {
            this.builder = new ConfigBuilder((ConfigFluent)this);
        }

        public N and() {
            return (N)OpenshiftConfigFluent.this.withKubernetesConfig((Config)this.builder.build());
        }

        public N endKubernetesConfig() {
            return this.and();
        }
    }
}

