/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.internal.URLUtils;
import io.fabric8.kubernetes.client.internal.Utils;

public class OpenshiftConfig
extends Config {
    public static final String KUBERNETES_OAPI_VERSION_SYSTEM_PROPERTY = "kubernetes.oapi.version";
    public static final String OPENSHIFT_URL_SYTEM_PROPERTY = "openshift.url";
    private String oapiVersion = "v1";
    private String openShiftUrl;
    private Config kubernetesConfig;

    public OpenshiftConfig() {
        this((Config)new ConfigBuilder().build());
    }

    public OpenshiftConfig(Config kubernetesConfig) {
        this(kubernetesConfig, "v1", null);
    }

    public OpenshiftConfig(Config kubernetesConfig, String oapiVersion, String openShiftUrl) {
        super(kubernetesConfig.getMasterUrl(), kubernetesConfig.getApiVersion(), kubernetesConfig.getNamespace(), kubernetesConfig.getEnabledProtocols(), Boolean.valueOf(kubernetesConfig.isTrustCerts()), kubernetesConfig.getCaCertFile(), kubernetesConfig.getCaCertData(), kubernetesConfig.getClientCertFile(), kubernetesConfig.getClientCertData(), kubernetesConfig.getClientKeyFile(), kubernetesConfig.getClientKeyData(), kubernetesConfig.getClientKeyAlgo(), kubernetesConfig.getClientKeyPassphrase(), kubernetesConfig.getUsername(), kubernetesConfig.getPassword(), kubernetesConfig.getOauthToken(), kubernetesConfig.getWatchReconnectInterval(), kubernetesConfig.getWatchReconnectLimit(), kubernetesConfig.getRequestTimeout(), kubernetesConfig.getProxy());
        this.kubernetesConfig = kubernetesConfig;
        this.oapiVersion = Utils.getSystemPropertyOrEnvVar((String)KUBERNETES_OAPI_VERSION_SYSTEM_PROPERTY, (String)oapiVersion);
        this.openShiftUrl = openShiftUrl;
        if (this.openShiftUrl == null || this.openShiftUrl.isEmpty()) {
            this.openShiftUrl = OpenshiftConfig.getCustomOpenshiftUrl();
            if (this.openShiftUrl == null || this.openShiftUrl.isEmpty()) {
                this.openShiftUrl = URLUtils.join((String[])new String[]{this.getMasterUrl(), "oapi", this.oapiVersion});
            }
        }
    }

    public static String getCustomOpenshiftUrl() {
        return Utils.getSystemPropertyOrEnvVar((String)OPENSHIFT_URL_SYTEM_PROPERTY);
    }

    public Config getKubernetesConfig() {
        return this.kubernetesConfig;
    }

    public String getOapiVersion() {
        return this.oapiVersion;
    }

    public String getOpenShiftUrl() {
        return this.openShiftUrl;
    }
}

