/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.internal.Utils;
import java.net.MalformedURLException;
import java.net.URL;

public class OpenshiftConfig
extends Config {
    public static final String KUBERNETES_OAPI_VERSION_SYSTEM_PROPERTY = "kubernetes.oapi.version";
    public static final String OPENSHIFT_URL_SYTEM_PROPERTY = "openshift.url";
    private String oapiVersion = "v1";
    private String openShiftUrl;
    private Config kubernetesConfig;

    public OpenshiftConfig() {
        this((Config)new ConfigBuilder().build());
    }

    public OpenshiftConfig(Config kubernetesConfig) {
        this(kubernetesConfig, "v1", null);
    }

    public OpenshiftConfig(Config kubernetesConfig, String oapiVersion, String openShiftUrl) {
        super(kubernetesConfig.isTrustCerts(), kubernetesConfig.getMasterUrl(), kubernetesConfig.getApiVersion(), kubernetesConfig.getEnabledProtocols(), kubernetesConfig.getCaCertFile(), kubernetesConfig.getCaCertData(), kubernetesConfig.getClientCertFile(), kubernetesConfig.getClientCertData(), kubernetesConfig.getClientKeyFile(), kubernetesConfig.getClientKeyData(), kubernetesConfig.getClientKeyAlgo(), kubernetesConfig.getClientKeyPassphrase(), kubernetesConfig.getUsername(), kubernetesConfig.getPassword(), kubernetesConfig.getOauthToken(), kubernetesConfig.getWatchReconnectInterval(), kubernetesConfig.getWatchReconnectLimit(), kubernetesConfig.getRequestTimeout(), kubernetesConfig.getProxy());
        this.kubernetesConfig = kubernetesConfig;
        this.oapiVersion = Utils.getSystemPropertyOrEnvVar((String)KUBERNETES_OAPI_VERSION_SYSTEM_PROPERTY, (String)oapiVersion);
        this.openShiftUrl = openShiftUrl;
        if (this.openShiftUrl == null || this.openShiftUrl.isEmpty()) {
            this.openShiftUrl = OpenshiftConfig.getCustomOpenshiftUrl();
            if (this.openShiftUrl == null || this.openShiftUrl.isEmpty()) {
                try {
                    this.openShiftUrl = new URL(new URL(this.getMasterUrl()), "/oapi/" + this.oapiVersion + "/").toString();
                }
                catch (MalformedURLException e) {
                    throw KubernetesClientException.launderThrowable((Throwable)e);
                }
            }
        }
    }

    public static String getCustomOpenshiftUrl() {
        return Utils.getSystemPropertyOrEnvVar((String)OPENSHIFT_URL_SYTEM_PROPERTY);
    }

    public Config getKubernetesConfig() {
        return this.kubernetesConfig;
    }

    public String getOapiVersion() {
        return this.oapiVersion;
    }

    public String getOpenShiftUrl() {
        return this.openShiftUrl;
    }
}

