/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client;

import io.fabric8.kubernetes.api.model.DoneableSecurityContextConstraints;
import io.fabric8.kubernetes.api.model.SecurityContextConstraints;
import io.fabric8.kubernetes.api.model.SecurityContextConstraintsList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.BuildConfigClientResource;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.dsl.ProcessableClientResource;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigList;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigList;
import io.fabric8.openshift.api.model.DoneableBuild;
import io.fabric8.openshift.api.model.DoneableBuildConfig;
import io.fabric8.openshift.api.model.DoneableDeploymentConfig;
import io.fabric8.openshift.api.model.DoneableImageStream;
import io.fabric8.openshift.api.model.DoneableOAuthAccessToken;
import io.fabric8.openshift.api.model.DoneableOAuthAuthorizeToken;
import io.fabric8.openshift.api.model.DoneableOAuthClient;
import io.fabric8.openshift.api.model.DoneableRoute;
import io.fabric8.openshift.api.model.DoneableTemplate;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamList;
import io.fabric8.openshift.api.model.OAuthAccessToken;
import io.fabric8.openshift.api.model.OAuthAccessTokenList;
import io.fabric8.openshift.api.model.OAuthAuthorizeToken;
import io.fabric8.openshift.api.model.OAuthAuthorizeTokenList;
import io.fabric8.openshift.api.model.OAuthClient;
import io.fabric8.openshift.api.model.OAuthClientList;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteList;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.api.model.TemplateList;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.OpenshiftConfig;
import io.fabric8.openshift.client.OpenshiftConfigBuilder;
import io.fabric8.openshift.client.OpenshiftConfigFluent;
import io.fabric8.openshift.client.dsl.BuildConfigOperationsImpl;
import io.fabric8.openshift.client.dsl.BuildOperationsImpl;
import io.fabric8.openshift.client.dsl.DeploymentConfigOperationsImpl;
import io.fabric8.openshift.client.dsl.ImageStreamOperationsImpl;
import io.fabric8.openshift.client.dsl.OAuthAccessTokenOperationsImpl;
import io.fabric8.openshift.client.dsl.OAuthAuthorizeTokenOperationsImpl;
import io.fabric8.openshift.client.dsl.OAuthClientOperationsImpl;
import io.fabric8.openshift.client.dsl.RouteOperationsImpl;
import io.fabric8.openshift.client.dsl.SecurityContextConstraintsOperationsImpl;
import io.fabric8.openshift.client.dsl.TemplateOperationsImpl;
import java.net.MalformedURLException;
import java.net.URL;

public class DefaultOpenshiftClient
extends DefaultKubernetesClient
implements OpenShiftClient {
    private URL openShiftUrl;

    public DefaultOpenshiftClient() throws KubernetesClientException {
        this(new OpenshiftConfigBuilder().build());
    }

    public DefaultOpenshiftClient(Config config) throws KubernetesClientException {
        this(new OpenshiftConfig(config));
    }

    public DefaultOpenshiftClient(OpenshiftConfig config) throws KubernetesClientException {
        super((Config)config);
        try {
            this.openShiftUrl = new URL(config.getOpenShiftUrl());
        }
        catch (MalformedURLException e) {
            throw new KubernetesClientException("Could not create client", (Throwable)e);
        }
    }

    public DefaultOpenshiftClient(String masterUrl) throws KubernetesClientException {
        this(((OpenshiftConfigBuilder)((Object)((OpenshiftConfigFluent.KubernetesConfigNested)new OpenshiftConfigBuilder().withNewKubernetesConfig().withMasterUrl(masterUrl)).and())).build());
    }

    @Override
    public URL getOpenshiftUrl() {
        return this.openShiftUrl;
    }

    @Override
    public ClientOperation<OpenShiftClient, Build, BuildList, DoneableBuild, ClientResource<Build, DoneableBuild>> builds() {
        return new BuildOperationsImpl(this);
    }

    @Override
    public ClientOperation<OpenShiftClient, BuildConfig, BuildConfigList, DoneableBuildConfig, BuildConfigClientResource<BuildConfig, DoneableBuildConfig, Void, Void>> buildConfigs() {
        return new BuildConfigOperationsImpl(this, null, null);
    }

    @Override
    public ClientOperation<OpenShiftClient, DeploymentConfig, DeploymentConfigList, DoneableDeploymentConfig, ClientResource<DeploymentConfig, DoneableDeploymentConfig>> deploymentConfigs() {
        return new DeploymentConfigOperationsImpl(this);
    }

    @Override
    public ClientOperation<OpenShiftClient, ImageStream, ImageStreamList, DoneableImageStream, ClientResource<ImageStream, DoneableImageStream>> imageStreams() {
        return new ImageStreamOperationsImpl(this);
    }

    @Override
    public ClientNonNamespaceOperation<OpenShiftClient, OAuthAccessToken, OAuthAccessTokenList, DoneableOAuthAccessToken, ClientResource<OAuthAccessToken, DoneableOAuthAccessToken>> oAuthAccessTokens() {
        return new OAuthAccessTokenOperationsImpl(this);
    }

    @Override
    public ClientNonNamespaceOperation<OpenShiftClient, OAuthAuthorizeToken, OAuthAuthorizeTokenList, DoneableOAuthAuthorizeToken, ClientResource<OAuthAuthorizeToken, DoneableOAuthAuthorizeToken>> oAuthAuthorizeTokens() {
        return new OAuthAuthorizeTokenOperationsImpl(this);
    }

    @Override
    public ClientNonNamespaceOperation<OpenShiftClient, OAuthClient, OAuthClientList, DoneableOAuthClient, ClientResource<OAuthClient, DoneableOAuthClient>> oAuthClients() {
        return new OAuthClientOperationsImpl(this);
    }

    @Override
    public ClientOperation<OpenShiftClient, Route, RouteList, DoneableRoute, ClientResource<Route, DoneableRoute>> routes() {
        return new RouteOperationsImpl(this);
    }

    @Override
    public ClientNonNamespaceOperation<OpenShiftClient, SecurityContextConstraints, SecurityContextConstraintsList, DoneableSecurityContextConstraints, ClientResource<SecurityContextConstraints, DoneableSecurityContextConstraints>> securityContextConstraints() {
        return new SecurityContextConstraintsOperationsImpl(this);
    }

    @Override
    public ClientOperation<OpenShiftClient, Template, TemplateList, DoneableTemplate, ProcessableClientResource<Template, DoneableTemplate>> templates() {
        return new TemplateOperationsImpl(this);
    }
}

