/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.schema.generator;

import java.util.Collection;
import java.util.Objects;

public interface ImportManager {
    public String getPackageName();

    public Collection<String> getImports();

    default public void addImport(String importedClass) {
        if (Objects.equals(importedClass.substring(0, importedClass.lastIndexOf(46)), this.getPackageName())) {
            return;
        }
        if (importedClass.substring(0, importedClass.lastIndexOf(46)).equals("java.lang")) {
            return;
        }
        this.getImports().add(importedClass);
    }

    default public void addAllImports(Collection<String> allImports) {
        allImports.forEach(this::addImport);
    }

    default public boolean hasSimpleClassName(String className) {
        String simpleClassName = this.simpleClassName(className);
        return this.getImports().stream().filter(i -> !Objects.equals(i, className)).anyMatch(i -> i.endsWith("." + simpleClassName));
    }

    default public String simpleClassName(String className) {
        return className.substring(className.lastIndexOf(46) + 1);
    }
}

