/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mockwebserver.vertx;

import io.fabric8.mockwebserver.http.RecordedRequest;
import io.fabric8.mockwebserver.http.Response;
import io.fabric8.mockwebserver.http.WebSocket;
import io.fabric8.mockwebserver.http.WebSocketListener;
import io.fabric8.mockwebserver.vertx.VertxMockWebSocket;
import io.vertx.core.Handler;
import io.vertx.core.http.ServerWebSocket;

public class ServerWebSocketHandler
implements Handler<ServerWebSocket> {
    private static final int WEBSOCKET_CLOSE_CODE_SERVER_ERROR = 1011;
    private final RecordedRequest request;
    private final Response response;

    public ServerWebSocketHandler(RecordedRequest request, Response response) {
        this.request = request;
        this.response = response;
    }

    public void handle(ServerWebSocket serverWebSocket) {
        WebSocketListener wsListener = this.response.getWebSocketListener();
        VertxMockWebSocket mockWebSocket = new VertxMockWebSocket(this.request, serverWebSocket);
        wsListener.onBeforeAccept(mockWebSocket, this.response);
        serverWebSocket.textMessageHandler(text -> wsListener.onMessage((WebSocket)mockWebSocket, (String)text));
        serverWebSocket.binaryMessageHandler(buff -> wsListener.onMessage((WebSocket)mockWebSocket, buff.getBytes()));
        serverWebSocket.frameHandler(frame -> {
            if (frame.isClose()) {
                wsListener.onClosing(mockWebSocket, frame.closeStatusCode(), frame.closeReason());
            }
            serverWebSocket.fetch(1L);
        });
        serverWebSocket.endHandler(v -> wsListener.onClosed(mockWebSocket, serverWebSocket.closeStatusCode() == null ? 1011 : (int)serverWebSocket.closeStatusCode().shortValue(), serverWebSocket.closeReason()));
        serverWebSocket.exceptionHandler(err -> wsListener.onFailure(mockWebSocket, (Throwable)err, this.response));
        serverWebSocket.accept();
        wsListener.onOpen(mockWebSocket, this.response);
        serverWebSocket.fetch(1L);
    }
}

