/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mockwebserver.http;

import io.fabric8.mockwebserver.dsl.HttpMethod;
import io.fabric8.mockwebserver.http.Buffer;
import io.fabric8.mockwebserver.http.Headers;
import java.net.Socket;
import java.util.List;

public class RecordedRequest {
    private final String httpVersion;
    private final HttpMethod method;
    private final String path;
    private final Headers headers;
    private final Buffer body;

    public RecordedRequest(String httpVersion, HttpMethod method, String path, Headers headers, Buffer body) {
        this.httpVersion = httpVersion;
        this.method = method;
        this.path = path;
        this.headers = headers;
        this.body = body;
    }

    public String getRequestLine() {
        return String.valueOf((Object)this.method) + " " + this.path + " " + this.httpVersion;
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method.toString();
    }

    public HttpMethod method() {
        return this.method;
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public Buffer getBody() {
        return this.body;
    }

    public String getUtf8Body() {
        return this.getBody() != null ? this.getBody().readUtf8() : null;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public String getHeader(String key) {
        return this.headers.header(key);
    }

    public String toString() {
        return this.getRequestLine();
    }

    @Deprecated
    public RecordedRequest(String requestLine, Headers headers, List<Integer> chunkSizes, long bodySize, Buffer body, int sequenceNumber, Socket socket) {
        this(RecordedRequest.extractHttpVersion(requestLine), RecordedRequest.extractMethod(requestLine), RecordedRequest.extractPath(requestLine), headers, body);
    }

    private static HttpMethod extractMethod(String requestLine) {
        return HttpMethod.valueOf(requestLine.split(" ")[0]);
    }

    private static String extractPath(String requestLine) {
        int methodEnd = requestLine.indexOf(32);
        int pathEnd = requestLine.indexOf(32, methodEnd + 1);
        return requestLine.substring(methodEnd + 1, pathEnd);
    }

    private static String extractHttpVersion(String requestLine) {
        int pathEnd = requestLine.lastIndexOf(32);
        return requestLine.substring(pathEnd + 1);
    }
}

