/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.letschat;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.letschat.LetsChatClient;
import io.fabric8.utils.Strings;
import io.fabric8.utils.Systems;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LetsChatKubernetes {
    private static final transient Logger LOG = LoggerFactory.getLogger(LetsChatKubernetes.class);
    public static final String LETSCHAT_HUBOT_USERNAME = "LETSCHAT_HUBOT_USERNAME";
    public static final String LETSCHAT_HUBOT_PASSWORD = "LETSCHAT_HUBOT_PASSWORD";
    public static final String LETSCHAT_HUBOT_TOKEN = "LETSCHAT_HUBOT_TOKEN";

    public static LetsChatClient createLetsChat(KubernetesClient kubernetes) {
        String address;
        String userName = Systems.getEnvVarOrSystemProperty((String)LETSCHAT_HUBOT_USERNAME, (String)"fabric8");
        String password = Systems.getEnvVarOrSystemProperty((String)LETSCHAT_HUBOT_PASSWORD, (String)"RedHat$1");
        String token = Systems.getEnvVarOrSystemProperty((String)LETSCHAT_HUBOT_TOKEN);
        String namespace = KubernetesHelper.defaultNamespace();
        try {
            address = KubernetesHelper.getServiceURL((KubernetesClient)kubernetes, (String)"letschat", (String)namespace, (String)"http", (boolean)true);
            if (Strings.isNullOrBlank((String)address)) {
                LOG.warn("No LetsChat service could be found in kubernetes " + namespace + " on address: " + kubernetes.getMasterUrl());
                return null;
            }
        }
        catch (Exception e) {
            LOG.warn("No LetsChat service could be found in kubernetes " + namespace + " on address: " + kubernetes.getMasterUrl());
            return null;
        }
        LOG.info("Logging into LetsChat at " + address + " as user " + userName);
        return new LetsChatClient(address, userName, password, token);
    }
}

