/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.server.mock;

import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import io.fabric8.kubernetes.client.server.mock.EnableKubernetesMockClient;
import io.fabric8.kubernetes.client.server.mock.KubernetesMixedDispatcher;
import io.fabric8.kubernetes.client.server.mock.KubernetesMockServer;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.MockWebServer;
import io.fabric8.mockwebserver.ServerRequest;
import io.fabric8.mockwebserver.ServerResponse;
import io.fabric8.mockwebserver.internal.MockDispatcher;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Optional;
import java.util.Queue;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class KubernetesMockServerExtension
implements AfterEachCallback,
AfterAllCallback,
BeforeEachCallback,
BeforeAllCallback {
    private KubernetesMockServer staticMock;
    private NamespacedKubernetesClient staticClient;
    private KubernetesMockServer instantMock;
    private NamespacedKubernetesClient instantClient;

    public void afterEach(ExtensionContext context) {
        this.destroy();
    }

    public void afterAll(ExtensionContext context) {
        this.destroyStatic();
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.setKubernetesClientAndMockServerFields(context, false);
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        this.setKubernetesClientAndMockServerFields(context, true);
    }

    protected void setFieldIfKubernetesClientOrMockServer(ExtensionContext context, boolean isStatic, Field field) throws IllegalAccessException {
        if (this.extensionMatches(field.getType())) {
            NamespacedKubernetesClient client = isStatic ? this.staticClient : this.instantClient;
            this.setFieldIfEqualsToProvidedType(context, isStatic, field, Client.class, (i, f) -> f.set(i, client.adapt(f.getType())));
        } else {
            KubernetesMockServer mock = isStatic ? this.staticMock : this.instantMock;
            this.setFieldIfEqualsToProvidedType(context, isStatic, field, this.getKubernetesMockServerType(), (i, f) -> f.set(i, mock));
        }
    }

    protected void setFieldIfEqualsToProvidedType(ExtensionContext context, boolean isStatic, Field field, Class<?> fieldType, SetTestClassField setTestClassField) throws IllegalAccessException {
        if (fieldType.isAssignableFrom(field.getType()) && Modifier.isStatic(field.getModifiers()) == isStatic) {
            this.setKubernetesClientStaticOrMemberField(context, isStatic, field, setTestClassField);
        }
    }

    protected void initializeKubernetesClientAndMockServer(Class<?> testClass, boolean isStatic) {
        EnableKubernetesMockClient a = testClass.getAnnotation(EnableKubernetesMockClient.class);
        HashMap<ServerRequest, Queue<ServerResponse>> responses = new HashMap<ServerRequest, Queue<ServerResponse>>();
        KubernetesMixedDispatcher dispatcher = a.crud() ? new KubernetesMixedDispatcher(responses) : new MockDispatcher(responses);
        KubernetesMockServer mock = new KubernetesMockServer(new Context(Serialization.jsonMapper()), new MockWebServer(), responses, dispatcher, a.https());
        mock.init();
        if (isStatic) {
            this.staticMock = mock;
        } else {
            this.instantMock = mock;
        }
        try {
            NamespacedKubernetesClient client = mock.createClient(a.kubernetesClientBuilderCustomizer().getConstructor(new Class[0]).newInstance(new Object[0]));
            if (isStatic) {
                this.staticClient = client;
            } else {
                this.instantClient = client;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The provided kubernetesClientBuilder is invalid", e);
        }
    }

    protected void destroy() {
        if (this.instantMock != null) {
            this.instantMock.destroy();
        }
        if (this.instantClient != null) {
            this.instantClient.close();
        }
    }

    protected void destroyStatic() {
        this.staticMock.destroy();
        this.staticClient.close();
    }

    protected Class<?> getKubernetesMockServerType() {
        return KubernetesMockServer.class;
    }

    private boolean extensionMatches(Class<?> type) {
        return Client.class.isAssignableFrom(type);
    }

    private void setKubernetesClientAndMockServerFields(ExtensionContext context, boolean isStatic) throws IllegalAccessException {
        Optional optClass = context.getTestClass();
        if (optClass.isPresent()) {
            Class testClass = (Class)optClass.get();
            this.initializeKubernetesClientAndMockServer(testClass, isStatic);
            this.processTestClassDeclaredFields(context, isStatic, testClass);
        }
    }

    private void processTestClassDeclaredFields(ExtensionContext context, boolean isStatic, Class<?> testClass) throws IllegalAccessException {
        Field[] fields;
        for (Field field : fields = testClass.getDeclaredFields()) {
            this.setFieldIfKubernetesClientOrMockServer(context, isStatic, field);
        }
    }

    private void setKubernetesClientStaticOrMemberField(ExtensionContext context, boolean isStatic, Field f, SetTestClassField setTestClassField) throws IllegalAccessException {
        f.setAccessible(true);
        if (isStatic) {
            setTestClassField.apply(null, f);
        } else {
            Optional optTestInstance = context.getTestInstance();
            if (optTestInstance.isPresent()) {
                setTestClassField.apply(optTestInstance.get(), f);
            }
        }
    }

    public static interface SetTestClassField {
        public void apply(Object var1, Field var2) throws IllegalAccessException;
    }
}

