/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.SubscriptionConfig;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.SubscriptionConfigBuilder;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.SubscriptionConfigFluent;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.SubscriptionSpec;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SubscriptionSpecFluent<A extends SubscriptionSpecFluent<A>>
extends BaseFluent<A> {
    private String channel;
    private SubscriptionConfigBuilder config;
    private String installPlanApproval;
    private String name;
    private String source;
    private String sourceNamespace;
    private String startingCSV;
    private Map<String, Object> additionalProperties;

    public SubscriptionSpecFluent() {
    }

    public SubscriptionSpecFluent(SubscriptionSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(SubscriptionSpec instance) {
        SubscriptionSpec subscriptionSpec = instance = instance != null ? instance : new SubscriptionSpec();
        if (instance != null) {
            this.withChannel(instance.getChannel());
            this.withConfig(instance.getConfig());
            this.withInstallPlanApproval(instance.getInstallPlanApproval());
            this.withName(instance.getName());
            this.withSource(instance.getSource());
            this.withSourceNamespace(instance.getSourceNamespace());
            this.withStartingCSV(instance.getStartingCSV());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getChannel() {
        return this.channel;
    }

    public A withChannel(String channel) {
        this.channel = channel;
        return (A)this;
    }

    public boolean hasChannel() {
        return this.channel != null;
    }

    public SubscriptionConfig buildConfig() {
        return this.config != null ? this.config.build() : null;
    }

    public A withConfig(SubscriptionConfig config) {
        this._visitables.remove("config");
        if (config != null) {
            this.config = new SubscriptionConfigBuilder(config);
            this._visitables.get("config").add(this.config);
        } else {
            this.config = null;
            this._visitables.get("config").remove(this.config);
        }
        return (A)this;
    }

    public boolean hasConfig() {
        return this.config != null;
    }

    public ConfigNested<A> withNewConfig() {
        return new ConfigNested(null);
    }

    public ConfigNested<A> withNewConfigLike(SubscriptionConfig item) {
        return new ConfigNested(item);
    }

    public ConfigNested<A> editConfig() {
        return this.withNewConfigLike(Optional.ofNullable(this.buildConfig()).orElse(null));
    }

    public ConfigNested<A> editOrNewConfig() {
        return this.withNewConfigLike(Optional.ofNullable(this.buildConfig()).orElse(new SubscriptionConfigBuilder().build()));
    }

    public ConfigNested<A> editOrNewConfigLike(SubscriptionConfig item) {
        return this.withNewConfigLike(Optional.ofNullable(this.buildConfig()).orElse(item));
    }

    public String getInstallPlanApproval() {
        return this.installPlanApproval;
    }

    public A withInstallPlanApproval(String installPlanApproval) {
        this.installPlanApproval = installPlanApproval;
        return (A)this;
    }

    public boolean hasInstallPlanApproval() {
        return this.installPlanApproval != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getSource() {
        return this.source;
    }

    public A withSource(String source) {
        this.source = source;
        return (A)this;
    }

    public boolean hasSource() {
        return this.source != null;
    }

    public String getSourceNamespace() {
        return this.sourceNamespace;
    }

    public A withSourceNamespace(String sourceNamespace) {
        this.sourceNamespace = sourceNamespace;
        return (A)this;
    }

    public boolean hasSourceNamespace() {
        return this.sourceNamespace != null;
    }

    public String getStartingCSV() {
        return this.startingCSV;
    }

    public A withStartingCSV(String startingCSV) {
        this.startingCSV = startingCSV;
        return (A)this;
    }

    public boolean hasStartingCSV() {
        return this.startingCSV != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SubscriptionSpecFluent that = (SubscriptionSpecFluent)o;
        if (!Objects.equals(this.channel, that.channel)) {
            return false;
        }
        if (!Objects.equals(this.config, that.config)) {
            return false;
        }
        if (!Objects.equals(this.installPlanApproval, that.installPlanApproval)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.source, that.source)) {
            return false;
        }
        if (!Objects.equals(this.sourceNamespace, that.sourceNamespace)) {
            return false;
        }
        if (!Objects.equals(this.startingCSV, that.startingCSV)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.channel, this.config, this.installPlanApproval, this.name, this.source, this.sourceNamespace, this.startingCSV, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.channel != null) {
            sb.append("channel:");
            sb.append(this.channel + ",");
        }
        if (this.config != null) {
            sb.append("config:");
            sb.append(String.valueOf(this.config) + ",");
        }
        if (this.installPlanApproval != null) {
            sb.append("installPlanApproval:");
            sb.append(this.installPlanApproval + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.source != null) {
            sb.append("source:");
            sb.append(this.source + ",");
        }
        if (this.sourceNamespace != null) {
            sb.append("sourceNamespace:");
            sb.append(this.sourceNamespace + ",");
        }
        if (this.startingCSV != null) {
            sb.append("startingCSV:");
            sb.append(this.startingCSV + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConfigNested<N>
    extends SubscriptionConfigFluent<ConfigNested<N>>
    implements Nested<N> {
        SubscriptionConfigBuilder builder;

        ConfigNested(SubscriptionConfig item) {
            this.builder = new SubscriptionConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SubscriptionSpecFluent.this.withConfig(this.builder.build());
        }

        public N endConfig() {
            return this.and();
        }
    }
}

