/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.v1.DNSTransportConfig;
import io.fabric8.openshift.api.model.operator.v1.DNSTransportConfigBuilder;
import io.fabric8.openshift.api.model.operator.v1.DNSTransportConfigFluent;
import io.fabric8.openshift.api.model.operator.v1.ForwardPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ForwardPluginFluent<A extends ForwardPluginFluent<A>>
extends BaseFluent<A> {
    private String policy;
    private String protocolStrategy;
    private DNSTransportConfigBuilder transportConfig;
    private List<String> upstreams = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public ForwardPluginFluent() {
    }

    public ForwardPluginFluent(ForwardPlugin instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ForwardPlugin instance) {
        ForwardPlugin forwardPlugin = instance = instance != null ? instance : new ForwardPlugin();
        if (instance != null) {
            this.withPolicy(instance.getPolicy());
            this.withProtocolStrategy(instance.getProtocolStrategy());
            this.withTransportConfig(instance.getTransportConfig());
            this.withUpstreams(instance.getUpstreams());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getPolicy() {
        return this.policy;
    }

    public A withPolicy(String policy) {
        this.policy = policy;
        return (A)this;
    }

    public boolean hasPolicy() {
        return this.policy != null;
    }

    public String getProtocolStrategy() {
        return this.protocolStrategy;
    }

    public A withProtocolStrategy(String protocolStrategy) {
        this.protocolStrategy = protocolStrategy;
        return (A)this;
    }

    public boolean hasProtocolStrategy() {
        return this.protocolStrategy != null;
    }

    public DNSTransportConfig buildTransportConfig() {
        return this.transportConfig != null ? this.transportConfig.build() : null;
    }

    public A withTransportConfig(DNSTransportConfig transportConfig) {
        this._visitables.remove("transportConfig");
        if (transportConfig != null) {
            this.transportConfig = new DNSTransportConfigBuilder(transportConfig);
            this._visitables.get("transportConfig").add(this.transportConfig);
        } else {
            this.transportConfig = null;
            this._visitables.get("transportConfig").remove(this.transportConfig);
        }
        return (A)this;
    }

    public boolean hasTransportConfig() {
        return this.transportConfig != null;
    }

    public TransportConfigNested<A> withNewTransportConfig() {
        return new TransportConfigNested(null);
    }

    public TransportConfigNested<A> withNewTransportConfigLike(DNSTransportConfig item) {
        return new TransportConfigNested(item);
    }

    public TransportConfigNested<A> editTransportConfig() {
        return this.withNewTransportConfigLike(Optional.ofNullable(this.buildTransportConfig()).orElse(null));
    }

    public TransportConfigNested<A> editOrNewTransportConfig() {
        return this.withNewTransportConfigLike(Optional.ofNullable(this.buildTransportConfig()).orElse(new DNSTransportConfigBuilder().build()));
    }

    public TransportConfigNested<A> editOrNewTransportConfigLike(DNSTransportConfig item) {
        return this.withNewTransportConfigLike(Optional.ofNullable(this.buildTransportConfig()).orElse(item));
    }

    public A addToUpstreams(int index, String item) {
        if (this.upstreams == null) {
            this.upstreams = new ArrayList<String>();
        }
        this.upstreams.add(index, item);
        return (A)this;
    }

    public A setToUpstreams(int index, String item) {
        if (this.upstreams == null) {
            this.upstreams = new ArrayList<String>();
        }
        this.upstreams.set(index, item);
        return (A)this;
    }

    public A addToUpstreams(String ... items) {
        if (this.upstreams == null) {
            this.upstreams = new ArrayList<String>();
        }
        for (String item : items) {
            this.upstreams.add(item);
        }
        return (A)this;
    }

    public A addAllToUpstreams(Collection<String> items) {
        if (this.upstreams == null) {
            this.upstreams = new ArrayList<String>();
        }
        for (String item : items) {
            this.upstreams.add(item);
        }
        return (A)this;
    }

    public A removeFromUpstreams(String ... items) {
        if (this.upstreams == null) {
            return (A)this;
        }
        for (String item : items) {
            this.upstreams.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromUpstreams(Collection<String> items) {
        if (this.upstreams == null) {
            return (A)this;
        }
        for (String item : items) {
            this.upstreams.remove(item);
        }
        return (A)this;
    }

    public List<String> getUpstreams() {
        return this.upstreams;
    }

    public String getUpstream(int index) {
        return this.upstreams.get(index);
    }

    public String getFirstUpstream() {
        return this.upstreams.get(0);
    }

    public String getLastUpstream() {
        return this.upstreams.get(this.upstreams.size() - 1);
    }

    public String getMatchingUpstream(Predicate<String> predicate) {
        for (String item : this.upstreams) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingUpstream(Predicate<String> predicate) {
        for (String item : this.upstreams) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withUpstreams(List<String> upstreams) {
        if (upstreams != null) {
            this.upstreams = new ArrayList<String>();
            for (String item : upstreams) {
                this.addToUpstreams(item);
            }
        } else {
            this.upstreams = null;
        }
        return (A)this;
    }

    public A withUpstreams(String ... upstreams) {
        if (this.upstreams != null) {
            this.upstreams.clear();
            this._visitables.remove("upstreams");
        }
        if (upstreams != null) {
            for (String item : upstreams) {
                this.addToUpstreams(item);
            }
        }
        return (A)this;
    }

    public boolean hasUpstreams() {
        return this.upstreams != null && !this.upstreams.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ForwardPluginFluent that = (ForwardPluginFluent)o;
        if (!Objects.equals(this.policy, that.policy)) {
            return false;
        }
        if (!Objects.equals(this.protocolStrategy, that.protocolStrategy)) {
            return false;
        }
        if (!Objects.equals(this.transportConfig, that.transportConfig)) {
            return false;
        }
        if (!Objects.equals(this.upstreams, that.upstreams)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.policy, this.protocolStrategy, this.transportConfig, this.upstreams, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.policy != null) {
            sb.append("policy:");
            sb.append(this.policy + ",");
        }
        if (this.protocolStrategy != null) {
            sb.append("protocolStrategy:");
            sb.append(this.protocolStrategy + ",");
        }
        if (this.transportConfig != null) {
            sb.append("transportConfig:");
            sb.append(String.valueOf(this.transportConfig) + ",");
        }
        if (this.upstreams != null && !this.upstreams.isEmpty()) {
            sb.append("upstreams:");
            sb.append(String.valueOf(this.upstreams) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TransportConfigNested<N>
    extends DNSTransportConfigFluent<TransportConfigNested<N>>
    implements Nested<N> {
        DNSTransportConfigBuilder builder;

        TransportConfigNested(DNSTransportConfig item) {
            this.builder = new DNSTransportConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ForwardPluginFluent.this.withTransportConfig(this.builder.build());
        }

        public N endTransportConfig() {
            return this.and();
        }
    }
}

