/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.openshift.api.model.monitoring.v1.BasicAuth;
import io.fabric8.openshift.api.model.monitoring.v1.BasicAuthBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.BasicAuthFluent;
import io.fabric8.openshift.api.model.monitoring.v1.OAuth2;
import io.fabric8.openshift.api.model.monitoring.v1.OAuth2Builder;
import io.fabric8.openshift.api.model.monitoring.v1.OAuth2Fluent;
import io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorization;
import io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationFluent;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfig;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfig;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class HTTPConfigFluent<A extends HTTPConfigFluent<A>>
extends BaseFluent<A> {
    private SafeAuthorizationBuilder authorization;
    private BasicAuthBuilder basicAuth;
    private SecretKeySelector bearerTokenSecret;
    private Boolean followRedirects;
    private String noProxy;
    private OAuth2Builder oauth2;
    private Map<String, List<SecretKeySelector>> proxyConnectHeader;
    private Boolean proxyFromEnvironment;
    private String proxyURL;
    private String proxyUrl;
    private SafeTLSConfigBuilder tlsConfig;
    private Map<String, Object> additionalProperties;

    public HTTPConfigFluent() {
    }

    public HTTPConfigFluent(HTTPConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(HTTPConfig instance) {
        HTTPConfig hTTPConfig = instance = instance != null ? instance : new HTTPConfig();
        if (instance != null) {
            this.withAuthorization(instance.getAuthorization());
            this.withBasicAuth(instance.getBasicAuth());
            this.withBearerTokenSecret(instance.getBearerTokenSecret());
            this.withFollowRedirects(instance.getFollowRedirects());
            this.withNoProxy(instance.getNoProxy());
            this.withOauth2(instance.getOauth2());
            this.withProxyConnectHeader(instance.getProxyConnectHeader());
            this.withProxyFromEnvironment(instance.getProxyFromEnvironment());
            this.withProxyURL(instance.getProxyURL());
            this.withProxyUrl(instance.getProxyUrl());
            this.withTlsConfig(instance.getTlsConfig());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public SafeAuthorization buildAuthorization() {
        return this.authorization != null ? this.authorization.build() : null;
    }

    public A withAuthorization(SafeAuthorization authorization) {
        this._visitables.remove("authorization");
        if (authorization != null) {
            this.authorization = new SafeAuthorizationBuilder(authorization);
            this._visitables.get("authorization").add(this.authorization);
        } else {
            this.authorization = null;
            this._visitables.get("authorization").remove(this.authorization);
        }
        return (A)this;
    }

    public boolean hasAuthorization() {
        return this.authorization != null;
    }

    public AuthorizationNested<A> withNewAuthorization() {
        return new AuthorizationNested(null);
    }

    public AuthorizationNested<A> withNewAuthorizationLike(SafeAuthorization item) {
        return new AuthorizationNested(item);
    }

    public AuthorizationNested<A> editAuthorization() {
        return this.withNewAuthorizationLike(Optional.ofNullable(this.buildAuthorization()).orElse(null));
    }

    public AuthorizationNested<A> editOrNewAuthorization() {
        return this.withNewAuthorizationLike(Optional.ofNullable(this.buildAuthorization()).orElse(new SafeAuthorizationBuilder().build()));
    }

    public AuthorizationNested<A> editOrNewAuthorizationLike(SafeAuthorization item) {
        return this.withNewAuthorizationLike(Optional.ofNullable(this.buildAuthorization()).orElse(item));
    }

    public BasicAuth buildBasicAuth() {
        return this.basicAuth != null ? this.basicAuth.build() : null;
    }

    public A withBasicAuth(BasicAuth basicAuth) {
        this._visitables.remove("basicAuth");
        if (basicAuth != null) {
            this.basicAuth = new BasicAuthBuilder(basicAuth);
            this._visitables.get("basicAuth").add(this.basicAuth);
        } else {
            this.basicAuth = null;
            this._visitables.get("basicAuth").remove(this.basicAuth);
        }
        return (A)this;
    }

    public boolean hasBasicAuth() {
        return this.basicAuth != null;
    }

    public BasicAuthNested<A> withNewBasicAuth() {
        return new BasicAuthNested(null);
    }

    public BasicAuthNested<A> withNewBasicAuthLike(BasicAuth item) {
        return new BasicAuthNested(item);
    }

    public BasicAuthNested<A> editBasicAuth() {
        return this.withNewBasicAuthLike(Optional.ofNullable(this.buildBasicAuth()).orElse(null));
    }

    public BasicAuthNested<A> editOrNewBasicAuth() {
        return this.withNewBasicAuthLike(Optional.ofNullable(this.buildBasicAuth()).orElse(new BasicAuthBuilder().build()));
    }

    public BasicAuthNested<A> editOrNewBasicAuthLike(BasicAuth item) {
        return this.withNewBasicAuthLike(Optional.ofNullable(this.buildBasicAuth()).orElse(item));
    }

    public SecretKeySelector getBearerTokenSecret() {
        return this.bearerTokenSecret;
    }

    public A withBearerTokenSecret(SecretKeySelector bearerTokenSecret) {
        this.bearerTokenSecret = bearerTokenSecret;
        return (A)this;
    }

    public boolean hasBearerTokenSecret() {
        return this.bearerTokenSecret != null;
    }

    public A withNewBearerTokenSecret(String key, String name, Boolean optional) {
        return this.withBearerTokenSecret(new SecretKeySelector(key, name, optional));
    }

    public Boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public A withFollowRedirects(Boolean followRedirects) {
        this.followRedirects = followRedirects;
        return (A)this;
    }

    public boolean hasFollowRedirects() {
        return this.followRedirects != null;
    }

    public String getNoProxy() {
        return this.noProxy;
    }

    public A withNoProxy(String noProxy) {
        this.noProxy = noProxy;
        return (A)this;
    }

    public boolean hasNoProxy() {
        return this.noProxy != null;
    }

    public OAuth2 buildOauth2() {
        return this.oauth2 != null ? this.oauth2.build() : null;
    }

    public A withOauth2(OAuth2 oauth2) {
        this._visitables.remove("oauth2");
        if (oauth2 != null) {
            this.oauth2 = new OAuth2Builder(oauth2);
            this._visitables.get("oauth2").add(this.oauth2);
        } else {
            this.oauth2 = null;
            this._visitables.get("oauth2").remove(this.oauth2);
        }
        return (A)this;
    }

    public boolean hasOauth2() {
        return this.oauth2 != null;
    }

    public Oauth2Nested<A> withNewOauth2() {
        return new Oauth2Nested(null);
    }

    public Oauth2Nested<A> withNewOauth2Like(OAuth2 item) {
        return new Oauth2Nested(item);
    }

    public Oauth2Nested<A> editOauth2() {
        return this.withNewOauth2Like(Optional.ofNullable(this.buildOauth2()).orElse(null));
    }

    public Oauth2Nested<A> editOrNewOauth2() {
        return this.withNewOauth2Like(Optional.ofNullable(this.buildOauth2()).orElse(new OAuth2Builder().build()));
    }

    public Oauth2Nested<A> editOrNewOauth2Like(OAuth2 item) {
        return this.withNewOauth2Like(Optional.ofNullable(this.buildOauth2()).orElse(item));
    }

    public A addToProxyConnectHeader(String key, List<SecretKeySelector> value) {
        if (this.proxyConnectHeader == null && key != null && value != null) {
            this.proxyConnectHeader = new LinkedHashMap<String, List<SecretKeySelector>>();
        }
        if (key != null && value != null) {
            this.proxyConnectHeader.put(key, value);
        }
        return (A)this;
    }

    public A addToProxyConnectHeader(Map<String, List<SecretKeySelector>> map) {
        if (this.proxyConnectHeader == null && map != null) {
            this.proxyConnectHeader = new LinkedHashMap<String, List<SecretKeySelector>>();
        }
        if (map != null) {
            this.proxyConnectHeader.putAll(map);
        }
        return (A)this;
    }

    public A removeFromProxyConnectHeader(String key) {
        if (this.proxyConnectHeader == null) {
            return (A)this;
        }
        if (key != null && this.proxyConnectHeader != null) {
            this.proxyConnectHeader.remove(key);
        }
        return (A)this;
    }

    public A removeFromProxyConnectHeader(Map<String, List<SecretKeySelector>> map) {
        if (this.proxyConnectHeader == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.proxyConnectHeader == null) continue;
                this.proxyConnectHeader.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, List<SecretKeySelector>> getProxyConnectHeader() {
        return this.proxyConnectHeader;
    }

    public <K, V> A withProxyConnectHeader(Map<String, List<SecretKeySelector>> proxyConnectHeader) {
        this.proxyConnectHeader = proxyConnectHeader == null ? null : new LinkedHashMap<String, List<SecretKeySelector>>(proxyConnectHeader);
        return (A)this;
    }

    public boolean hasProxyConnectHeader() {
        return this.proxyConnectHeader != null;
    }

    public Boolean getProxyFromEnvironment() {
        return this.proxyFromEnvironment;
    }

    public A withProxyFromEnvironment(Boolean proxyFromEnvironment) {
        this.proxyFromEnvironment = proxyFromEnvironment;
        return (A)this;
    }

    public boolean hasProxyFromEnvironment() {
        return this.proxyFromEnvironment != null;
    }

    public String getProxyURL() {
        return this.proxyURL;
    }

    public A withProxyURL(String proxyURL) {
        this.proxyURL = proxyURL;
        return (A)this;
    }

    public boolean hasProxyURL() {
        return this.proxyURL != null;
    }

    public String getProxyUrl() {
        return this.proxyUrl;
    }

    public A withProxyUrl(String proxyUrl) {
        this.proxyUrl = proxyUrl;
        return (A)this;
    }

    public boolean hasProxyUrl() {
        return this.proxyUrl != null;
    }

    public SafeTLSConfig buildTlsConfig() {
        return this.tlsConfig != null ? this.tlsConfig.build() : null;
    }

    public A withTlsConfig(SafeTLSConfig tlsConfig) {
        this._visitables.remove("tlsConfig");
        if (tlsConfig != null) {
            this.tlsConfig = new SafeTLSConfigBuilder(tlsConfig);
            this._visitables.get("tlsConfig").add(this.tlsConfig);
        } else {
            this.tlsConfig = null;
            this._visitables.get("tlsConfig").remove(this.tlsConfig);
        }
        return (A)this;
    }

    public boolean hasTlsConfig() {
        return this.tlsConfig != null;
    }

    public TlsConfigNested<A> withNewTlsConfig() {
        return new TlsConfigNested(null);
    }

    public TlsConfigNested<A> withNewTlsConfigLike(SafeTLSConfig item) {
        return new TlsConfigNested(item);
    }

    public TlsConfigNested<A> editTlsConfig() {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(null));
    }

    public TlsConfigNested<A> editOrNewTlsConfig() {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(new SafeTLSConfigBuilder().build()));
    }

    public TlsConfigNested<A> editOrNewTlsConfigLike(SafeTLSConfig item) {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HTTPConfigFluent that = (HTTPConfigFluent)o;
        if (!Objects.equals(this.authorization, that.authorization)) {
            return false;
        }
        if (!Objects.equals(this.basicAuth, that.basicAuth)) {
            return false;
        }
        if (!Objects.equals(this.bearerTokenSecret, that.bearerTokenSecret)) {
            return false;
        }
        if (!Objects.equals(this.followRedirects, that.followRedirects)) {
            return false;
        }
        if (!Objects.equals(this.noProxy, that.noProxy)) {
            return false;
        }
        if (!Objects.equals(this.oauth2, that.oauth2)) {
            return false;
        }
        if (!Objects.equals(this.proxyConnectHeader, that.proxyConnectHeader)) {
            return false;
        }
        if (!Objects.equals(this.proxyFromEnvironment, that.proxyFromEnvironment)) {
            return false;
        }
        if (!Objects.equals(this.proxyURL, that.proxyURL)) {
            return false;
        }
        if (!Objects.equals(this.proxyUrl, that.proxyUrl)) {
            return false;
        }
        if (!Objects.equals(this.tlsConfig, that.tlsConfig)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.authorization, this.basicAuth, this.bearerTokenSecret, this.followRedirects, this.noProxy, this.oauth2, this.proxyConnectHeader, this.proxyFromEnvironment, this.proxyURL, this.proxyUrl, this.tlsConfig, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.authorization != null) {
            sb.append("authorization:");
            sb.append(String.valueOf(this.authorization) + ",");
        }
        if (this.basicAuth != null) {
            sb.append("basicAuth:");
            sb.append(String.valueOf(this.basicAuth) + ",");
        }
        if (this.bearerTokenSecret != null) {
            sb.append("bearerTokenSecret:");
            sb.append(String.valueOf(this.bearerTokenSecret) + ",");
        }
        if (this.followRedirects != null) {
            sb.append("followRedirects:");
            sb.append(this.followRedirects + ",");
        }
        if (this.noProxy != null) {
            sb.append("noProxy:");
            sb.append(this.noProxy + ",");
        }
        if (this.oauth2 != null) {
            sb.append("oauth2:");
            sb.append(String.valueOf(this.oauth2) + ",");
        }
        if (this.proxyConnectHeader != null && !this.proxyConnectHeader.isEmpty()) {
            sb.append("proxyConnectHeader:");
            sb.append(String.valueOf(this.proxyConnectHeader) + ",");
        }
        if (this.proxyFromEnvironment != null) {
            sb.append("proxyFromEnvironment:");
            sb.append(this.proxyFromEnvironment + ",");
        }
        if (this.proxyURL != null) {
            sb.append("proxyURL:");
            sb.append(this.proxyURL + ",");
        }
        if (this.proxyUrl != null) {
            sb.append("proxyUrl:");
            sb.append(this.proxyUrl + ",");
        }
        if (this.tlsConfig != null) {
            sb.append("tlsConfig:");
            sb.append(String.valueOf(this.tlsConfig) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withFollowRedirects() {
        return this.withFollowRedirects(true);
    }

    public A withProxyFromEnvironment() {
        return this.withProxyFromEnvironment(true);
    }

    public class TlsConfigNested<N>
    extends SafeTLSConfigFluent<TlsConfigNested<N>>
    implements Nested<N> {
        SafeTLSConfigBuilder builder;

        TlsConfigNested(SafeTLSConfig item) {
            this.builder = new SafeTLSConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)HTTPConfigFluent.this.withTlsConfig(this.builder.build());
        }

        public N endTlsConfig() {
            return this.and();
        }
    }

    public class Oauth2Nested<N>
    extends OAuth2Fluent<Oauth2Nested<N>>
    implements Nested<N> {
        OAuth2Builder builder;

        Oauth2Nested(OAuth2 item) {
            this.builder = new OAuth2Builder(this, item);
        }

        @Override
        public N and() {
            return (N)HTTPConfigFluent.this.withOauth2(this.builder.build());
        }

        public N endOauth2() {
            return this.and();
        }
    }

    public class BasicAuthNested<N>
    extends BasicAuthFluent<BasicAuthNested<N>>
    implements Nested<N> {
        BasicAuthBuilder builder;

        BasicAuthNested(BasicAuth item) {
            this.builder = new BasicAuthBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)HTTPConfigFluent.this.withBasicAuth(this.builder.build());
        }

        public N endBasicAuth() {
            return this.and();
        }
    }

    public class AuthorizationNested<N>
    extends SafeAuthorizationFluent<AuthorizationNested<N>>
    implements Nested<N> {
        SafeAuthorizationBuilder builder;

        AuthorizationNested(SafeAuthorization item) {
            this.builder = new SafeAuthorizationBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)HTTPConfigFluent.this.withAuthorization(this.builder.build());
        }

        public N endAuthorization() {
            return this.and();
        }
    }
}

