/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.openstack.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.openstack.v1.MachinePool;
import io.fabric8.openshift.api.model.installer.openstack.v1.RootVolume;
import io.fabric8.openshift.api.model.installer.openstack.v1.RootVolumeBuilder;
import io.fabric8.openshift.api.model.installer.openstack.v1.RootVolumeFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class MachinePoolFluent<A extends MachinePoolFluent<A>>
extends BaseFluent<A> {
    private List<String> additionalNetworkIDs = new ArrayList<String>();
    private List<String> additionalSecurityGroupIDs = new ArrayList<String>();
    private RootVolumeBuilder rootVolume;
    private String serverGroupPolicy;
    private String type;
    private List<String> zones = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public MachinePoolFluent() {
    }

    public MachinePoolFluent(MachinePool instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(MachinePool instance) {
        MachinePool machinePool = instance = instance != null ? instance : new MachinePool();
        if (instance != null) {
            this.withAdditionalNetworkIDs(instance.getAdditionalNetworkIDs());
            this.withAdditionalSecurityGroupIDs(instance.getAdditionalSecurityGroupIDs());
            this.withRootVolume(instance.getRootVolume());
            this.withServerGroupPolicy(instance.getServerGroupPolicy());
            this.withType(instance.getType());
            this.withZones(instance.getZones());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAdditionalNetworkIDs(int index, String item) {
        if (this.additionalNetworkIDs == null) {
            this.additionalNetworkIDs = new ArrayList<String>();
        }
        this.additionalNetworkIDs.add(index, item);
        return (A)this;
    }

    public A setToAdditionalNetworkIDs(int index, String item) {
        if (this.additionalNetworkIDs == null) {
            this.additionalNetworkIDs = new ArrayList<String>();
        }
        this.additionalNetworkIDs.set(index, item);
        return (A)this;
    }

    public A addToAdditionalNetworkIDs(String ... items) {
        if (this.additionalNetworkIDs == null) {
            this.additionalNetworkIDs = new ArrayList<String>();
        }
        for (String item : items) {
            this.additionalNetworkIDs.add(item);
        }
        return (A)this;
    }

    public A addAllToAdditionalNetworkIDs(Collection<String> items) {
        if (this.additionalNetworkIDs == null) {
            this.additionalNetworkIDs = new ArrayList<String>();
        }
        for (String item : items) {
            this.additionalNetworkIDs.add(item);
        }
        return (A)this;
    }

    public A removeFromAdditionalNetworkIDs(String ... items) {
        if (this.additionalNetworkIDs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.additionalNetworkIDs.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromAdditionalNetworkIDs(Collection<String> items) {
        if (this.additionalNetworkIDs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.additionalNetworkIDs.remove(item);
        }
        return (A)this;
    }

    public List<String> getAdditionalNetworkIDs() {
        return this.additionalNetworkIDs;
    }

    public String getAdditionalNetworkID(int index) {
        return this.additionalNetworkIDs.get(index);
    }

    public String getFirstAdditionalNetworkID() {
        return this.additionalNetworkIDs.get(0);
    }

    public String getLastAdditionalNetworkID() {
        return this.additionalNetworkIDs.get(this.additionalNetworkIDs.size() - 1);
    }

    public String getMatchingAdditionalNetworkID(Predicate<String> predicate) {
        for (String item : this.additionalNetworkIDs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingAdditionalNetworkID(Predicate<String> predicate) {
        for (String item : this.additionalNetworkIDs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAdditionalNetworkIDs(List<String> additionalNetworkIDs) {
        if (additionalNetworkIDs != null) {
            this.additionalNetworkIDs = new ArrayList<String>();
            for (String item : additionalNetworkIDs) {
                this.addToAdditionalNetworkIDs(item);
            }
        } else {
            this.additionalNetworkIDs = null;
        }
        return (A)this;
    }

    public A withAdditionalNetworkIDs(String ... additionalNetworkIDs) {
        if (this.additionalNetworkIDs != null) {
            this.additionalNetworkIDs.clear();
            this._visitables.remove("additionalNetworkIDs");
        }
        if (additionalNetworkIDs != null) {
            for (String item : additionalNetworkIDs) {
                this.addToAdditionalNetworkIDs(item);
            }
        }
        return (A)this;
    }

    public boolean hasAdditionalNetworkIDs() {
        return this.additionalNetworkIDs != null && !this.additionalNetworkIDs.isEmpty();
    }

    public A addToAdditionalSecurityGroupIDs(int index, String item) {
        if (this.additionalSecurityGroupIDs == null) {
            this.additionalSecurityGroupIDs = new ArrayList<String>();
        }
        this.additionalSecurityGroupIDs.add(index, item);
        return (A)this;
    }

    public A setToAdditionalSecurityGroupIDs(int index, String item) {
        if (this.additionalSecurityGroupIDs == null) {
            this.additionalSecurityGroupIDs = new ArrayList<String>();
        }
        this.additionalSecurityGroupIDs.set(index, item);
        return (A)this;
    }

    public A addToAdditionalSecurityGroupIDs(String ... items) {
        if (this.additionalSecurityGroupIDs == null) {
            this.additionalSecurityGroupIDs = new ArrayList<String>();
        }
        for (String item : items) {
            this.additionalSecurityGroupIDs.add(item);
        }
        return (A)this;
    }

    public A addAllToAdditionalSecurityGroupIDs(Collection<String> items) {
        if (this.additionalSecurityGroupIDs == null) {
            this.additionalSecurityGroupIDs = new ArrayList<String>();
        }
        for (String item : items) {
            this.additionalSecurityGroupIDs.add(item);
        }
        return (A)this;
    }

    public A removeFromAdditionalSecurityGroupIDs(String ... items) {
        if (this.additionalSecurityGroupIDs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.additionalSecurityGroupIDs.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromAdditionalSecurityGroupIDs(Collection<String> items) {
        if (this.additionalSecurityGroupIDs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.additionalSecurityGroupIDs.remove(item);
        }
        return (A)this;
    }

    public List<String> getAdditionalSecurityGroupIDs() {
        return this.additionalSecurityGroupIDs;
    }

    public String getAdditionalSecurityGroupID(int index) {
        return this.additionalSecurityGroupIDs.get(index);
    }

    public String getFirstAdditionalSecurityGroupID() {
        return this.additionalSecurityGroupIDs.get(0);
    }

    public String getLastAdditionalSecurityGroupID() {
        return this.additionalSecurityGroupIDs.get(this.additionalSecurityGroupIDs.size() - 1);
    }

    public String getMatchingAdditionalSecurityGroupID(Predicate<String> predicate) {
        for (String item : this.additionalSecurityGroupIDs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingAdditionalSecurityGroupID(Predicate<String> predicate) {
        for (String item : this.additionalSecurityGroupIDs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAdditionalSecurityGroupIDs(List<String> additionalSecurityGroupIDs) {
        if (additionalSecurityGroupIDs != null) {
            this.additionalSecurityGroupIDs = new ArrayList<String>();
            for (String item : additionalSecurityGroupIDs) {
                this.addToAdditionalSecurityGroupIDs(item);
            }
        } else {
            this.additionalSecurityGroupIDs = null;
        }
        return (A)this;
    }

    public A withAdditionalSecurityGroupIDs(String ... additionalSecurityGroupIDs) {
        if (this.additionalSecurityGroupIDs != null) {
            this.additionalSecurityGroupIDs.clear();
            this._visitables.remove("additionalSecurityGroupIDs");
        }
        if (additionalSecurityGroupIDs != null) {
            for (String item : additionalSecurityGroupIDs) {
                this.addToAdditionalSecurityGroupIDs(item);
            }
        }
        return (A)this;
    }

    public boolean hasAdditionalSecurityGroupIDs() {
        return this.additionalSecurityGroupIDs != null && !this.additionalSecurityGroupIDs.isEmpty();
    }

    public RootVolume buildRootVolume() {
        return this.rootVolume != null ? this.rootVolume.build() : null;
    }

    public A withRootVolume(RootVolume rootVolume) {
        this._visitables.remove("rootVolume");
        if (rootVolume != null) {
            this.rootVolume = new RootVolumeBuilder(rootVolume);
            this._visitables.get("rootVolume").add(this.rootVolume);
        } else {
            this.rootVolume = null;
            this._visitables.get("rootVolume").remove(this.rootVolume);
        }
        return (A)this;
    }

    public boolean hasRootVolume() {
        return this.rootVolume != null;
    }

    public RootVolumeNested<A> withNewRootVolume() {
        return new RootVolumeNested(null);
    }

    public RootVolumeNested<A> withNewRootVolumeLike(RootVolume item) {
        return new RootVolumeNested(item);
    }

    public RootVolumeNested<A> editRootVolume() {
        return this.withNewRootVolumeLike(Optional.ofNullable(this.buildRootVolume()).orElse(null));
    }

    public RootVolumeNested<A> editOrNewRootVolume() {
        return this.withNewRootVolumeLike(Optional.ofNullable(this.buildRootVolume()).orElse(new RootVolumeBuilder().build()));
    }

    public RootVolumeNested<A> editOrNewRootVolumeLike(RootVolume item) {
        return this.withNewRootVolumeLike(Optional.ofNullable(this.buildRootVolume()).orElse(item));
    }

    public String getServerGroupPolicy() {
        return this.serverGroupPolicy;
    }

    public A withServerGroupPolicy(String serverGroupPolicy) {
        this.serverGroupPolicy = serverGroupPolicy;
        return (A)this;
    }

    public boolean hasServerGroupPolicy() {
        return this.serverGroupPolicy != null;
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    public boolean hasType() {
        return this.type != null;
    }

    public A addToZones(int index, String item) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        this.zones.add(index, item);
        return (A)this;
    }

    public A setToZones(int index, String item) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        this.zones.set(index, item);
        return (A)this;
    }

    public A addToZones(String ... items) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        for (String item : items) {
            this.zones.add(item);
        }
        return (A)this;
    }

    public A addAllToZones(Collection<String> items) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        for (String item : items) {
            this.zones.add(item);
        }
        return (A)this;
    }

    public A removeFromZones(String ... items) {
        if (this.zones == null) {
            return (A)this;
        }
        for (String item : items) {
            this.zones.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromZones(Collection<String> items) {
        if (this.zones == null) {
            return (A)this;
        }
        for (String item : items) {
            this.zones.remove(item);
        }
        return (A)this;
    }

    public List<String> getZones() {
        return this.zones;
    }

    public String getZone(int index) {
        return this.zones.get(index);
    }

    public String getFirstZone() {
        return this.zones.get(0);
    }

    public String getLastZone() {
        return this.zones.get(this.zones.size() - 1);
    }

    public String getMatchingZone(Predicate<String> predicate) {
        for (String item : this.zones) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingZone(Predicate<String> predicate) {
        for (String item : this.zones) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withZones(List<String> zones) {
        if (zones != null) {
            this.zones = new ArrayList<String>();
            for (String item : zones) {
                this.addToZones(item);
            }
        } else {
            this.zones = null;
        }
        return (A)this;
    }

    public A withZones(String ... zones) {
        if (this.zones != null) {
            this.zones.clear();
            this._visitables.remove("zones");
        }
        if (zones != null) {
            for (String item : zones) {
                this.addToZones(item);
            }
        }
        return (A)this;
    }

    public boolean hasZones() {
        return this.zones != null && !this.zones.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachinePoolFluent that = (MachinePoolFluent)o;
        if (!Objects.equals(this.additionalNetworkIDs, that.additionalNetworkIDs)) {
            return false;
        }
        if (!Objects.equals(this.additionalSecurityGroupIDs, that.additionalSecurityGroupIDs)) {
            return false;
        }
        if (!Objects.equals(this.rootVolume, that.rootVolume)) {
            return false;
        }
        if (!Objects.equals(this.serverGroupPolicy, that.serverGroupPolicy)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        if (!Objects.equals(this.zones, that.zones)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.additionalNetworkIDs, this.additionalSecurityGroupIDs, this.rootVolume, this.serverGroupPolicy, this.type, this.zones, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.additionalNetworkIDs != null && !this.additionalNetworkIDs.isEmpty()) {
            sb.append("additionalNetworkIDs:");
            sb.append(String.valueOf(this.additionalNetworkIDs) + ",");
        }
        if (this.additionalSecurityGroupIDs != null && !this.additionalSecurityGroupIDs.isEmpty()) {
            sb.append("additionalSecurityGroupIDs:");
            sb.append(String.valueOf(this.additionalSecurityGroupIDs) + ",");
        }
        if (this.rootVolume != null) {
            sb.append("rootVolume:");
            sb.append(String.valueOf(this.rootVolume) + ",");
        }
        if (this.serverGroupPolicy != null) {
            sb.append("serverGroupPolicy:");
            sb.append(this.serverGroupPolicy + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type + ",");
        }
        if (this.zones != null && !this.zones.isEmpty()) {
            sb.append("zones:");
            sb.append(String.valueOf(this.zones) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RootVolumeNested<N>
    extends RootVolumeFluent<RootVolumeNested<N>>
    implements Nested<N> {
        RootVolumeBuilder builder;

        RootVolumeNested(RootVolume item) {
            this.builder = new RootVolumeBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)MachinePoolFluent.this.withRootVolume(this.builder.build());
        }

        public N endRootVolume() {
            return this.and();
        }
    }
}

