/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.gatewayapi.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.CookieConfig;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.CookieConfigBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.CookieConfigFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.SessionPersistence;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SessionPersistenceFluent<A extends SessionPersistenceFluent<A>>
extends BaseFluent<A> {
    private String absoluteTimeout;
    private CookieConfigBuilder cookieConfig;
    private String idleTimeout;
    private String sessionName;
    private String type;
    private Map<String, Object> additionalProperties;

    public SessionPersistenceFluent() {
    }

    public SessionPersistenceFluent(SessionPersistence instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(SessionPersistence instance) {
        SessionPersistence sessionPersistence = instance = instance != null ? instance : new SessionPersistence();
        if (instance != null) {
            this.withAbsoluteTimeout(instance.getAbsoluteTimeout());
            this.withCookieConfig(instance.getCookieConfig());
            this.withIdleTimeout(instance.getIdleTimeout());
            this.withSessionName(instance.getSessionName());
            this.withType(instance.getType());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getAbsoluteTimeout() {
        return this.absoluteTimeout;
    }

    public A withAbsoluteTimeout(String absoluteTimeout) {
        this.absoluteTimeout = absoluteTimeout;
        return (A)this;
    }

    public boolean hasAbsoluteTimeout() {
        return this.absoluteTimeout != null;
    }

    public CookieConfig buildCookieConfig() {
        return this.cookieConfig != null ? this.cookieConfig.build() : null;
    }

    public A withCookieConfig(CookieConfig cookieConfig) {
        this._visitables.remove("cookieConfig");
        if (cookieConfig != null) {
            this.cookieConfig = new CookieConfigBuilder(cookieConfig);
            this._visitables.get("cookieConfig").add(this.cookieConfig);
        } else {
            this.cookieConfig = null;
            this._visitables.get("cookieConfig").remove(this.cookieConfig);
        }
        return (A)this;
    }

    public boolean hasCookieConfig() {
        return this.cookieConfig != null;
    }

    public A withNewCookieConfig(String lifetimeType) {
        return this.withCookieConfig(new CookieConfig(lifetimeType));
    }

    public CookieConfigNested<A> withNewCookieConfig() {
        return new CookieConfigNested(null);
    }

    public CookieConfigNested<A> withNewCookieConfigLike(CookieConfig item) {
        return new CookieConfigNested(item);
    }

    public CookieConfigNested<A> editCookieConfig() {
        return this.withNewCookieConfigLike(Optional.ofNullable(this.buildCookieConfig()).orElse(null));
    }

    public CookieConfigNested<A> editOrNewCookieConfig() {
        return this.withNewCookieConfigLike(Optional.ofNullable(this.buildCookieConfig()).orElse(new CookieConfigBuilder().build()));
    }

    public CookieConfigNested<A> editOrNewCookieConfigLike(CookieConfig item) {
        return this.withNewCookieConfigLike(Optional.ofNullable(this.buildCookieConfig()).orElse(item));
    }

    public String getIdleTimeout() {
        return this.idleTimeout;
    }

    public A withIdleTimeout(String idleTimeout) {
        this.idleTimeout = idleTimeout;
        return (A)this;
    }

    public boolean hasIdleTimeout() {
        return this.idleTimeout != null;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public A withSessionName(String sessionName) {
        this.sessionName = sessionName;
        return (A)this;
    }

    public boolean hasSessionName() {
        return this.sessionName != null;
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    public boolean hasType() {
        return this.type != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SessionPersistenceFluent that = (SessionPersistenceFluent)o;
        if (!Objects.equals(this.absoluteTimeout, that.absoluteTimeout)) {
            return false;
        }
        if (!Objects.equals(this.cookieConfig, that.cookieConfig)) {
            return false;
        }
        if (!Objects.equals(this.idleTimeout, that.idleTimeout)) {
            return false;
        }
        if (!Objects.equals(this.sessionName, that.sessionName)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.absoluteTimeout, this.cookieConfig, this.idleTimeout, this.sessionName, this.type, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.absoluteTimeout != null) {
            sb.append("absoluteTimeout:");
            sb.append(this.absoluteTimeout + ",");
        }
        if (this.cookieConfig != null) {
            sb.append("cookieConfig:");
            sb.append(String.valueOf(this.cookieConfig) + ",");
        }
        if (this.idleTimeout != null) {
            sb.append("idleTimeout:");
            sb.append(this.idleTimeout + ",");
        }
        if (this.sessionName != null) {
            sb.append("sessionName:");
            sb.append(this.sessionName + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class CookieConfigNested<N>
    extends CookieConfigFluent<CookieConfigNested<N>>
    implements Nested<N> {
        CookieConfigBuilder builder;

        CookieConfigNested(CookieConfig item) {
            this.builder = new CookieConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SessionPersistenceFluent.this.withCookieConfig(this.builder.build());
        }

        public N endCookieConfig() {
            return this.and();
        }
    }
}

