/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.NodeBuilder;
import io.fabric8.kubernetes.api.model.NodeFluent;
import io.fabric8.kubernetes.api.model.NodeList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class NodeListFluent<A extends NodeListFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private ArrayList<NodeBuilder> items = new ArrayList();
    private String kind;
    private ListMetaBuilder metadata;
    private Map<String, Object> additionalProperties;

    public NodeListFluent() {
    }

    public NodeListFluent(NodeList instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NodeList instance) {
        NodeList nodeList = instance = instance != null ? instance : new NodeList();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withItems(instance.getItems());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A addToItems(int index, Node item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        NodeBuilder builder = new NodeBuilder(item);
        if (index < 0 || index >= this.items.size()) {
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        } else {
            this._visitables.get("items").add(builder);
            this.items.add(index, builder);
        }
        return (A)this;
    }

    public A setToItems(int index, Node item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        NodeBuilder builder = new NodeBuilder(item);
        if (index < 0 || index >= this.items.size()) {
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        } else {
            this._visitables.get("items").add(builder);
            this.items.set(index, builder);
        }
        return (A)this;
    }

    public A addToItems(Node ... items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (Node item : items) {
            NodeBuilder builder = new NodeBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    public A addAllToItems(Collection<Node> items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (Node item : items) {
            NodeBuilder builder = new NodeBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    public A removeFromItems(Node ... items) {
        if (this.items == null) {
            return (A)this;
        }
        for (Node item : items) {
            NodeBuilder builder = new NodeBuilder(item);
            this._visitables.get("items").remove(builder);
            this.items.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromItems(Collection<Node> items) {
        if (this.items == null) {
            return (A)this;
        }
        for (Node item : items) {
            NodeBuilder builder = new NodeBuilder(item);
            this._visitables.get("items").remove(builder);
            this.items.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromItems(Predicate<NodeBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<NodeBuilder> each = this.items.iterator();
        Object visitables = this._visitables.get("items");
        while (each.hasNext()) {
            NodeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<Node> buildItems() {
        return this.items != null ? NodeListFluent.build(this.items) : null;
    }

    public Node buildItem(int index) {
        return this.items.get(index).build();
    }

    public Node buildFirstItem() {
        return this.items.get(0).build();
    }

    public Node buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    public Node buildMatchingItem(Predicate<NodeBuilder> predicate) {
        for (NodeBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingItem(Predicate<NodeBuilder> predicate) {
        for (NodeBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withItems(List<Node> items) {
        if (this.items != null) {
            this._visitables.get("items").clear();
        }
        if (items != null) {
            this.items = new ArrayList();
            for (Node item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    public A withItems(Node ... items) {
        if (this.items != null) {
            this.items.clear();
            this._visitables.remove("items");
        }
        if (items != null) {
            for (Node item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    public boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    public ItemsNested<A> addNewItem() {
        return new ItemsNested(-1, null);
    }

    public ItemsNested<A> addNewItemLike(Node item) {
        return new ItemsNested(-1, item);
    }

    public ItemsNested<A> setNewItemLike(int index, Node item) {
        return new ItemsNested(index, item);
    }

    public ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    public ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public ItemsNested<A> editMatchingItem(Predicate<NodeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public ListMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(ListMeta metadata) {
        this._visitables.remove("metadata");
        if (metadata != null) {
            this.metadata = new ListMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ListMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ListMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ListMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeListFluent that = (NodeListFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.items, that.items)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.items, this.kind, this.metadata, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.items != null && !this.items.isEmpty()) {
            sb.append("items:");
            sb.append(String.valueOf(this.items) + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(String.valueOf(this.metadata) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MetadataNested<N>
    extends ListMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ListMetaBuilder builder;

        MetadataNested(ListMeta item) {
            this.builder = new ListMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NodeListFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class ItemsNested<N>
    extends NodeFluent<ItemsNested<N>>
    implements Nested<N> {
        NodeBuilder builder;
        int index;

        ItemsNested(int index, Node item) {
            this.index = index;
            this.builder = new NodeBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NodeListFluent.this.setToItems(this.index, this.builder.build());
        }

        public N endItem() {
            return this.and();
        }
    }
}

