/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.v1.DNSStatus;
import io.fabric8.openshift.api.model.operator.v1.OperatorCondition;
import io.fabric8.openshift.api.model.operator.v1.OperatorConditionBuilder;
import io.fabric8.openshift.api.model.operator.v1.OperatorConditionFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class DNSStatusFluent<A extends DNSStatusFluent<A>>
extends BaseFluent<A> {
    private String clusterDomain;
    private String clusterIP;
    private ArrayList<OperatorConditionBuilder> conditions = new ArrayList();
    private Map<String, Object> additionalProperties;

    public DNSStatusFluent() {
    }

    public DNSStatusFluent(DNSStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(DNSStatus instance) {
        DNSStatus dNSStatus = instance = instance != null ? instance : new DNSStatus();
        if (instance != null) {
            this.withClusterDomain(instance.getClusterDomain());
            this.withClusterIP(instance.getClusterIP());
            this.withConditions(instance.getConditions());
            this.withClusterDomain(instance.getClusterDomain());
            this.withClusterIP(instance.getClusterIP());
            this.withConditions(instance.getConditions());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getClusterDomain() {
        return this.clusterDomain;
    }

    public A withClusterDomain(String clusterDomain) {
        this.clusterDomain = clusterDomain;
        return (A)this;
    }

    public boolean hasClusterDomain() {
        return this.clusterDomain != null;
    }

    public String getClusterIP() {
        return this.clusterIP;
    }

    public A withClusterIP(String clusterIP) {
        this.clusterIP = clusterIP;
        return (A)this;
    }

    public boolean hasClusterIP() {
        return this.clusterIP != null;
    }

    public A addToConditions(int index, OperatorCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        OperatorConditionBuilder builder = new OperatorConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    public A setToConditions(int index, OperatorCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        OperatorConditionBuilder builder = new OperatorConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    public A addToConditions(OperatorCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (OperatorCondition item : items) {
            OperatorConditionBuilder builder = new OperatorConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<OperatorCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (OperatorCondition item : items) {
            OperatorConditionBuilder builder = new OperatorConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A removeFromConditions(OperatorCondition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (OperatorCondition item : items) {
            OperatorConditionBuilder builder = new OperatorConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<OperatorCondition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (OperatorCondition item : items) {
            OperatorConditionBuilder builder = new OperatorConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<OperatorConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<OperatorConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            OperatorConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<OperatorCondition> buildConditions() {
        return this.conditions != null ? DNSStatusFluent.build(this.conditions) : null;
    }

    public OperatorCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public OperatorCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public OperatorCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public OperatorCondition buildMatchingCondition(Predicate<OperatorConditionBuilder> predicate) {
        for (OperatorConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<OperatorConditionBuilder> predicate) {
        for (OperatorConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<OperatorCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (OperatorCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(OperatorCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (OperatorCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public A addNewCondition(String lastTransitionTime, String message, String reason, String status, String type) {
        return this.addToConditions(new OperatorCondition(lastTransitionTime, message, reason, status, type));
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(OperatorCondition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, OperatorCondition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<OperatorConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DNSStatusFluent that = (DNSStatusFluent)o;
        if (!Objects.equals(this.clusterDomain, that.clusterDomain)) {
            return false;
        }
        if (!Objects.equals(this.clusterIP, that.clusterIP)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.clusterDomain, this.clusterIP, this.conditions, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterDomain != null) {
            sb.append("clusterDomain:");
            sb.append(this.clusterDomain + ",");
        }
        if (this.clusterIP != null) {
            sb.append("clusterIP:");
            sb.append(this.clusterIP + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConditionsNested<N>
    extends OperatorConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        OperatorConditionBuilder builder;
        int index;

        ConditionsNested(int index, OperatorCondition item) {
            this.index = index;
            this.builder = new OperatorConditionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DNSStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

