/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.monitoring.v1.WebHTTPConfig;
import io.fabric8.openshift.api.model.monitoring.v1.WebHTTPHeaders;
import io.fabric8.openshift.api.model.monitoring.v1.WebHTTPHeadersBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.WebHTTPHeadersFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class WebHTTPConfigFluent<A extends WebHTTPConfigFluent<A>>
extends BaseFluent<A> {
    private WebHTTPHeadersBuilder headers;
    private Boolean http2;
    private Map<String, Object> additionalProperties;

    public WebHTTPConfigFluent() {
    }

    public WebHTTPConfigFluent(WebHTTPConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(WebHTTPConfig instance) {
        WebHTTPConfig webHTTPConfig = instance = instance != null ? instance : new WebHTTPConfig();
        if (instance != null) {
            this.withHeaders(instance.getHeaders());
            this.withHttp2(instance.getHttp2());
            this.withHeaders(instance.getHeaders());
            this.withHttp2(instance.getHttp2());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public WebHTTPHeaders buildHeaders() {
        return this.headers != null ? this.headers.build() : null;
    }

    public A withHeaders(WebHTTPHeaders headers) {
        this._visitables.get("headers").remove(this.headers);
        if (headers != null) {
            this.headers = new WebHTTPHeadersBuilder(headers);
            this._visitables.get("headers").add(this.headers);
        } else {
            this.headers = null;
            this._visitables.get("headers").remove(this.headers);
        }
        return (A)this;
    }

    public boolean hasHeaders() {
        return this.headers != null;
    }

    public A withNewHeaders(String contentSecurityPolicy, String strictTransportSecurity, String xContentTypeOptions, String xFrameOptions, String xXSSProtection) {
        return this.withHeaders(new WebHTTPHeaders(contentSecurityPolicy, strictTransportSecurity, xContentTypeOptions, xFrameOptions, xXSSProtection));
    }

    public HeadersNested<A> withNewHeaders() {
        return new HeadersNested(null);
    }

    public HeadersNested<A> withNewHeadersLike(WebHTTPHeaders item) {
        return new HeadersNested(item);
    }

    public HeadersNested<A> editHeaders() {
        return this.withNewHeadersLike(Optional.ofNullable(this.buildHeaders()).orElse(null));
    }

    public HeadersNested<A> editOrNewHeaders() {
        return this.withNewHeadersLike(Optional.ofNullable(this.buildHeaders()).orElse(new WebHTTPHeadersBuilder().build()));
    }

    public HeadersNested<A> editOrNewHeadersLike(WebHTTPHeaders item) {
        return this.withNewHeadersLike(Optional.ofNullable(this.buildHeaders()).orElse(item));
    }

    public Boolean getHttp2() {
        return this.http2;
    }

    public A withHttp2(Boolean http2) {
        this.http2 = http2;
        return (A)this;
    }

    public boolean hasHttp2() {
        return this.http2 != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WebHTTPConfigFluent that = (WebHTTPConfigFluent)o;
        if (!Objects.equals(this.headers, that.headers)) {
            return false;
        }
        if (!Objects.equals(this.http2, that.http2)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.headers, this.http2, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.headers != null) {
            sb.append("headers:");
            sb.append(this.headers + ",");
        }
        if (this.http2 != null) {
            sb.append("http2:");
            sb.append(this.http2 + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withHttp2() {
        return this.withHttp2(true);
    }

    public class HeadersNested<N>
    extends WebHTTPHeadersFluent<HeadersNested<N>>
    implements Nested<N> {
        WebHTTPHeadersBuilder builder;

        HeadersNested(WebHTTPHeaders item) {
            this.builder = new WebHTTPHeadersBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)WebHTTPConfigFluent.this.withHeaders(this.builder.build());
        }

        public N endHeaders() {
            return this.and();
        }
    }
}

