/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.hive.v1.ControllerConfig;
import io.fabric8.openshift.api.model.hive.v1.ControllerConfigBuilder;
import io.fabric8.openshift.api.model.hive.v1.ControllerConfigFluent;
import io.fabric8.openshift.api.model.hive.v1.ControllersConfig;
import io.fabric8.openshift.api.model.hive.v1.SpecificControllerConfig;
import io.fabric8.openshift.api.model.hive.v1.SpecificControllerConfigBuilder;
import io.fabric8.openshift.api.model.hive.v1.SpecificControllerConfigFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ControllersConfigFluent<A extends ControllersConfigFluent<A>>
extends BaseFluent<A> {
    private ArrayList<SpecificControllerConfigBuilder> controllers = new ArrayList();
    private ControllerConfigBuilder _default;
    private Map<String, Object> additionalProperties;

    public ControllersConfigFluent() {
    }

    public ControllersConfigFluent(ControllersConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ControllersConfig instance) {
        ControllersConfig controllersConfig = instance = instance != null ? instance : new ControllersConfig();
        if (instance != null) {
            this.withControllers(instance.getControllers());
            this.withDefault(instance.getDefault());
            this.withControllers(instance.getControllers());
            this.withDefault(instance.getDefault());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToControllers(int index, SpecificControllerConfig item) {
        if (this.controllers == null) {
            this.controllers = new ArrayList();
        }
        SpecificControllerConfigBuilder builder = new SpecificControllerConfigBuilder(item);
        if (index < 0 || index >= this.controllers.size()) {
            this._visitables.get("controllers").add(builder);
            this.controllers.add(builder);
        } else {
            this._visitables.get("controllers").add(index, builder);
            this.controllers.add(index, builder);
        }
        return (A)this;
    }

    public A setToControllers(int index, SpecificControllerConfig item) {
        if (this.controllers == null) {
            this.controllers = new ArrayList();
        }
        SpecificControllerConfigBuilder builder = new SpecificControllerConfigBuilder(item);
        if (index < 0 || index >= this.controllers.size()) {
            this._visitables.get("controllers").add(builder);
            this.controllers.add(builder);
        } else {
            this._visitables.get("controllers").set(index, builder);
            this.controllers.set(index, builder);
        }
        return (A)this;
    }

    public A addToControllers(SpecificControllerConfig ... items) {
        if (this.controllers == null) {
            this.controllers = new ArrayList();
        }
        for (SpecificControllerConfig item : items) {
            SpecificControllerConfigBuilder builder = new SpecificControllerConfigBuilder(item);
            this._visitables.get("controllers").add(builder);
            this.controllers.add(builder);
        }
        return (A)this;
    }

    public A addAllToControllers(Collection<SpecificControllerConfig> items) {
        if (this.controllers == null) {
            this.controllers = new ArrayList();
        }
        for (SpecificControllerConfig item : items) {
            SpecificControllerConfigBuilder builder = new SpecificControllerConfigBuilder(item);
            this._visitables.get("controllers").add(builder);
            this.controllers.add(builder);
        }
        return (A)this;
    }

    public A removeFromControllers(SpecificControllerConfig ... items) {
        if (this.controllers == null) {
            return (A)this;
        }
        for (SpecificControllerConfig item : items) {
            SpecificControllerConfigBuilder builder = new SpecificControllerConfigBuilder(item);
            this._visitables.get("controllers").remove(builder);
            this.controllers.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromControllers(Collection<SpecificControllerConfig> items) {
        if (this.controllers == null) {
            return (A)this;
        }
        for (SpecificControllerConfig item : items) {
            SpecificControllerConfigBuilder builder = new SpecificControllerConfigBuilder(item);
            this._visitables.get("controllers").remove(builder);
            this.controllers.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromControllers(Predicate<SpecificControllerConfigBuilder> predicate) {
        if (this.controllers == null) {
            return (A)this;
        }
        Iterator<SpecificControllerConfigBuilder> each = this.controllers.iterator();
        Object visitables = this._visitables.get("controllers");
        while (each.hasNext()) {
            SpecificControllerConfigBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<SpecificControllerConfig> buildControllers() {
        return this.controllers != null ? ControllersConfigFluent.build(this.controllers) : null;
    }

    public SpecificControllerConfig buildController(int index) {
        return this.controllers.get(index).build();
    }

    public SpecificControllerConfig buildFirstController() {
        return this.controllers.get(0).build();
    }

    public SpecificControllerConfig buildLastController() {
        return this.controllers.get(this.controllers.size() - 1).build();
    }

    public SpecificControllerConfig buildMatchingController(Predicate<SpecificControllerConfigBuilder> predicate) {
        for (SpecificControllerConfigBuilder item : this.controllers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingController(Predicate<SpecificControllerConfigBuilder> predicate) {
        for (SpecificControllerConfigBuilder item : this.controllers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withControllers(List<SpecificControllerConfig> controllers) {
        if (this.controllers != null) {
            this._visitables.get("controllers").clear();
        }
        if (controllers != null) {
            this.controllers = new ArrayList();
            for (SpecificControllerConfig item : controllers) {
                this.addToControllers(item);
            }
        } else {
            this.controllers = null;
        }
        return (A)this;
    }

    public A withControllers(SpecificControllerConfig ... controllers) {
        if (this.controllers != null) {
            this.controllers.clear();
            this._visitables.remove("controllers");
        }
        if (controllers != null) {
            for (SpecificControllerConfig item : controllers) {
                this.addToControllers(item);
            }
        }
        return (A)this;
    }

    public boolean hasControllers() {
        return this.controllers != null && !this.controllers.isEmpty();
    }

    public ControllersNested<A> addNewController() {
        return new ControllersNested(-1, null);
    }

    public ControllersNested<A> addNewControllerLike(SpecificControllerConfig item) {
        return new ControllersNested(-1, item);
    }

    public ControllersNested<A> setNewControllerLike(int index, SpecificControllerConfig item) {
        return new ControllersNested(index, item);
    }

    public ControllersNested<A> editController(int index) {
        if (this.controllers.size() <= index) {
            throw new RuntimeException("Can't edit controllers. Index exceeds size.");
        }
        return this.setNewControllerLike(index, this.buildController(index));
    }

    public ControllersNested<A> editFirstController() {
        if (this.controllers.size() == 0) {
            throw new RuntimeException("Can't edit first controllers. The list is empty.");
        }
        return this.setNewControllerLike(0, this.buildController(0));
    }

    public ControllersNested<A> editLastController() {
        int index = this.controllers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last controllers. The list is empty.");
        }
        return this.setNewControllerLike(index, this.buildController(index));
    }

    public ControllersNested<A> editMatchingController(Predicate<SpecificControllerConfigBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.controllers.size(); ++i) {
            if (!predicate.test(this.controllers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching controllers. No match found.");
        }
        return this.setNewControllerLike(index, this.buildController(index));
    }

    public ControllerConfig buildDefault() {
        return this._default != null ? this._default.build() : null;
    }

    public A withDefault(ControllerConfig _default) {
        this._visitables.get("_default").remove(this._default);
        if (_default != null) {
            this._default = new ControllerConfigBuilder(_default);
            this._visitables.get("_default").add(this._default);
        } else {
            this._default = null;
            this._visitables.get("_default").remove(this._default);
        }
        return (A)this;
    }

    public boolean hasDefault() {
        return this._default != null;
    }

    public DefaultNested<A> withNewDefault() {
        return new DefaultNested(null);
    }

    public DefaultNested<A> withNewDefaultLike(ControllerConfig item) {
        return new DefaultNested(item);
    }

    public DefaultNested<A> editDefault() {
        return this.withNewDefaultLike(Optional.ofNullable(this.buildDefault()).orElse(null));
    }

    public DefaultNested<A> editOrNewDefault() {
        return this.withNewDefaultLike(Optional.ofNullable(this.buildDefault()).orElse(new ControllerConfigBuilder().build()));
    }

    public DefaultNested<A> editOrNewDefaultLike(ControllerConfig item) {
        return this.withNewDefaultLike(Optional.ofNullable(this.buildDefault()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ControllersConfigFluent that = (ControllersConfigFluent)o;
        if (!Objects.equals(this.controllers, that.controllers)) {
            return false;
        }
        if (!Objects.equals(this._default, that._default)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.controllers, this._default, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.controllers != null && !this.controllers.isEmpty()) {
            sb.append("controllers:");
            sb.append(this.controllers + ",");
        }
        if (this._default != null) {
            sb.append("_default:");
            sb.append(this._default + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class DefaultNested<N>
    extends ControllerConfigFluent<DefaultNested<N>>
    implements Nested<N> {
        ControllerConfigBuilder builder;

        DefaultNested(ControllerConfig item) {
            this.builder = new ControllerConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ControllersConfigFluent.this.withDefault(this.builder.build());
        }

        public N endDefault() {
            return this.and();
        }
    }

    public class ControllersNested<N>
    extends SpecificControllerConfigFluent<ControllersNested<N>>
    implements Nested<N> {
        SpecificControllerConfigBuilder builder;
        int index;

        ControllersNested(int index, SpecificControllerConfig item) {
            this.index = index;
            this.builder = new SpecificControllerConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ControllersConfigFluent.this.setToControllers(this.index, this.builder.build());
        }

        public N endController() {
            return this.and();
        }
    }
}

