/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.console.v1.ConsoleQuickStartTask;
import io.fabric8.openshift.api.model.console.v1.ConsoleQuickStartTaskReview;
import io.fabric8.openshift.api.model.console.v1.ConsoleQuickStartTaskReviewBuilder;
import io.fabric8.openshift.api.model.console.v1.ConsoleQuickStartTaskReviewFluent;
import io.fabric8.openshift.api.model.console.v1.ConsoleQuickStartTaskSummary;
import io.fabric8.openshift.api.model.console.v1.ConsoleQuickStartTaskSummaryBuilder;
import io.fabric8.openshift.api.model.console.v1.ConsoleQuickStartTaskSummaryFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ConsoleQuickStartTaskFluent<A extends ConsoleQuickStartTaskFluent<A>>
extends BaseFluent<A> {
    private String description;
    private ConsoleQuickStartTaskReviewBuilder review;
    private ConsoleQuickStartTaskSummaryBuilder summary;
    private String title;
    private Map<String, Object> additionalProperties;

    public ConsoleQuickStartTaskFluent() {
    }

    public ConsoleQuickStartTaskFluent(ConsoleQuickStartTask instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ConsoleQuickStartTask instance) {
        ConsoleQuickStartTask consoleQuickStartTask = instance = instance != null ? instance : new ConsoleQuickStartTask();
        if (instance != null) {
            this.withDescription(instance.getDescription());
            this.withReview(instance.getReview());
            this.withSummary(instance.getSummary());
            this.withTitle(instance.getTitle());
            this.withDescription(instance.getDescription());
            this.withReview(instance.getReview());
            this.withSummary(instance.getSummary());
            this.withTitle(instance.getTitle());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getDescription() {
        return this.description;
    }

    public A withDescription(String description) {
        this.description = description;
        return (A)this;
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public ConsoleQuickStartTaskReview buildReview() {
        return this.review != null ? this.review.build() : null;
    }

    public A withReview(ConsoleQuickStartTaskReview review) {
        this._visitables.get("review").remove(this.review);
        if (review != null) {
            this.review = new ConsoleQuickStartTaskReviewBuilder(review);
            this._visitables.get("review").add(this.review);
        } else {
            this.review = null;
            this._visitables.get("review").remove(this.review);
        }
        return (A)this;
    }

    public boolean hasReview() {
        return this.review != null;
    }

    public A withNewReview(String failedTaskHelp, String instructions) {
        return this.withReview(new ConsoleQuickStartTaskReview(failedTaskHelp, instructions));
    }

    public ReviewNested<A> withNewReview() {
        return new ReviewNested(null);
    }

    public ReviewNested<A> withNewReviewLike(ConsoleQuickStartTaskReview item) {
        return new ReviewNested(item);
    }

    public ReviewNested<A> editReview() {
        return this.withNewReviewLike(Optional.ofNullable(this.buildReview()).orElse(null));
    }

    public ReviewNested<A> editOrNewReview() {
        return this.withNewReviewLike(Optional.ofNullable(this.buildReview()).orElse(new ConsoleQuickStartTaskReviewBuilder().build()));
    }

    public ReviewNested<A> editOrNewReviewLike(ConsoleQuickStartTaskReview item) {
        return this.withNewReviewLike(Optional.ofNullable(this.buildReview()).orElse(item));
    }

    public ConsoleQuickStartTaskSummary buildSummary() {
        return this.summary != null ? this.summary.build() : null;
    }

    public A withSummary(ConsoleQuickStartTaskSummary summary) {
        this._visitables.get("summary").remove(this.summary);
        if (summary != null) {
            this.summary = new ConsoleQuickStartTaskSummaryBuilder(summary);
            this._visitables.get("summary").add(this.summary);
        } else {
            this.summary = null;
            this._visitables.get("summary").remove(this.summary);
        }
        return (A)this;
    }

    public boolean hasSummary() {
        return this.summary != null;
    }

    public A withNewSummary(String failed, String success) {
        return this.withSummary(new ConsoleQuickStartTaskSummary(failed, success));
    }

    public SummaryNested<A> withNewSummary() {
        return new SummaryNested(null);
    }

    public SummaryNested<A> withNewSummaryLike(ConsoleQuickStartTaskSummary item) {
        return new SummaryNested(item);
    }

    public SummaryNested<A> editSummary() {
        return this.withNewSummaryLike(Optional.ofNullable(this.buildSummary()).orElse(null));
    }

    public SummaryNested<A> editOrNewSummary() {
        return this.withNewSummaryLike(Optional.ofNullable(this.buildSummary()).orElse(new ConsoleQuickStartTaskSummaryBuilder().build()));
    }

    public SummaryNested<A> editOrNewSummaryLike(ConsoleQuickStartTaskSummary item) {
        return this.withNewSummaryLike(Optional.ofNullable(this.buildSummary()).orElse(item));
    }

    public String getTitle() {
        return this.title;
    }

    public A withTitle(String title) {
        this.title = title;
        return (A)this;
    }

    public boolean hasTitle() {
        return this.title != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConsoleQuickStartTaskFluent that = (ConsoleQuickStartTaskFluent)o;
        if (!Objects.equals(this.description, that.description)) {
            return false;
        }
        if (!Objects.equals(this.review, that.review)) {
            return false;
        }
        if (!Objects.equals(this.summary, that.summary)) {
            return false;
        }
        if (!Objects.equals(this.title, that.title)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.description, this.review, this.summary, this.title, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.description != null) {
            sb.append("description:");
            sb.append(this.description + ",");
        }
        if (this.review != null) {
            sb.append("review:");
            sb.append(this.review + ",");
        }
        if (this.summary != null) {
            sb.append("summary:");
            sb.append(this.summary + ",");
        }
        if (this.title != null) {
            sb.append("title:");
            sb.append(this.title + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SummaryNested<N>
    extends ConsoleQuickStartTaskSummaryFluent<SummaryNested<N>>
    implements Nested<N> {
        ConsoleQuickStartTaskSummaryBuilder builder;

        SummaryNested(ConsoleQuickStartTaskSummary item) {
            this.builder = new ConsoleQuickStartTaskSummaryBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ConsoleQuickStartTaskFluent.this.withSummary(this.builder.build());
        }

        public N endSummary() {
            return this.and();
        }
    }

    public class ReviewNested<N>
    extends ConsoleQuickStartTaskReviewFluent<ReviewNested<N>>
    implements Nested<N> {
        ConsoleQuickStartTaskReviewBuilder builder;

        ReviewNested(ConsoleQuickStartTaskReview item) {
            this.builder = new ConsoleQuickStartTaskReviewBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ConsoleQuickStartTaskFluent.this.withReview(this.builder.build());
        }

        public N endReview() {
            return this.and();
        }
    }
}

