/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.HubSourceStatus;
import io.fabric8.openshift.api.model.config.v1.HubSourceStatusBuilder;
import io.fabric8.openshift.api.model.config.v1.HubSourceStatusFluent;
import io.fabric8.openshift.api.model.config.v1.OperatorHubStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class OperatorHubStatusFluent<A extends OperatorHubStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<HubSourceStatusBuilder> sources = new ArrayList();
    private Map<String, Object> additionalProperties;

    public OperatorHubStatusFluent() {
    }

    public OperatorHubStatusFluent(OperatorHubStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(OperatorHubStatus instance) {
        OperatorHubStatus operatorHubStatus = instance = instance != null ? instance : new OperatorHubStatus();
        if (instance != null) {
            this.withSources(instance.getSources());
            this.withSources(instance.getSources());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToSources(int index, HubSourceStatus item) {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        HubSourceStatusBuilder builder = new HubSourceStatusBuilder(item);
        if (index < 0 || index >= this.sources.size()) {
            this._visitables.get("sources").add(builder);
            this.sources.add(builder);
        } else {
            this._visitables.get("sources").add(index, builder);
            this.sources.add(index, builder);
        }
        return (A)this;
    }

    public A setToSources(int index, HubSourceStatus item) {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        HubSourceStatusBuilder builder = new HubSourceStatusBuilder(item);
        if (index < 0 || index >= this.sources.size()) {
            this._visitables.get("sources").add(builder);
            this.sources.add(builder);
        } else {
            this._visitables.get("sources").set(index, builder);
            this.sources.set(index, builder);
        }
        return (A)this;
    }

    public A addToSources(HubSourceStatus ... items) {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        for (HubSourceStatus item : items) {
            HubSourceStatusBuilder builder = new HubSourceStatusBuilder(item);
            this._visitables.get("sources").add(builder);
            this.sources.add(builder);
        }
        return (A)this;
    }

    public A addAllToSources(Collection<HubSourceStatus> items) {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        for (HubSourceStatus item : items) {
            HubSourceStatusBuilder builder = new HubSourceStatusBuilder(item);
            this._visitables.get("sources").add(builder);
            this.sources.add(builder);
        }
        return (A)this;
    }

    public A removeFromSources(HubSourceStatus ... items) {
        if (this.sources == null) {
            return (A)this;
        }
        for (HubSourceStatus item : items) {
            HubSourceStatusBuilder builder = new HubSourceStatusBuilder(item);
            this._visitables.get("sources").remove(builder);
            this.sources.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromSources(Collection<HubSourceStatus> items) {
        if (this.sources == null) {
            return (A)this;
        }
        for (HubSourceStatus item : items) {
            HubSourceStatusBuilder builder = new HubSourceStatusBuilder(item);
            this._visitables.get("sources").remove(builder);
            this.sources.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromSources(Predicate<HubSourceStatusBuilder> predicate) {
        if (this.sources == null) {
            return (A)this;
        }
        Iterator<HubSourceStatusBuilder> each = this.sources.iterator();
        Object visitables = this._visitables.get("sources");
        while (each.hasNext()) {
            HubSourceStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<HubSourceStatus> buildSources() {
        return this.sources != null ? OperatorHubStatusFluent.build(this.sources) : null;
    }

    public HubSourceStatus buildSource(int index) {
        return this.sources.get(index).build();
    }

    public HubSourceStatus buildFirstSource() {
        return this.sources.get(0).build();
    }

    public HubSourceStatus buildLastSource() {
        return this.sources.get(this.sources.size() - 1).build();
    }

    public HubSourceStatus buildMatchingSource(Predicate<HubSourceStatusBuilder> predicate) {
        for (HubSourceStatusBuilder item : this.sources) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSource(Predicate<HubSourceStatusBuilder> predicate) {
        for (HubSourceStatusBuilder item : this.sources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSources(List<HubSourceStatus> sources) {
        if (this.sources != null) {
            this._visitables.get("sources").clear();
        }
        if (sources != null) {
            this.sources = new ArrayList();
            for (HubSourceStatus item : sources) {
                this.addToSources(item);
            }
        } else {
            this.sources = null;
        }
        return (A)this;
    }

    public A withSources(HubSourceStatus ... sources) {
        if (this.sources != null) {
            this.sources.clear();
            this._visitables.remove("sources");
        }
        if (sources != null) {
            for (HubSourceStatus item : sources) {
                this.addToSources(item);
            }
        }
        return (A)this;
    }

    public boolean hasSources() {
        return this.sources != null && !this.sources.isEmpty();
    }

    public A addNewSource(Boolean disabled, String message, String name, String status) {
        return this.addToSources(new HubSourceStatus(disabled, message, name, status));
    }

    public SourcesNested<A> addNewSource() {
        return new SourcesNested(-1, null);
    }

    public SourcesNested<A> addNewSourceLike(HubSourceStatus item) {
        return new SourcesNested(-1, item);
    }

    public SourcesNested<A> setNewSourceLike(int index, HubSourceStatus item) {
        return new SourcesNested(index, item);
    }

    public SourcesNested<A> editSource(int index) {
        if (this.sources.size() <= index) {
            throw new RuntimeException("Can't edit sources. Index exceeds size.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    public SourcesNested<A> editFirstSource() {
        if (this.sources.size() == 0) {
            throw new RuntimeException("Can't edit first sources. The list is empty.");
        }
        return this.setNewSourceLike(0, this.buildSource(0));
    }

    public SourcesNested<A> editLastSource() {
        int index = this.sources.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last sources. The list is empty.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    public SourcesNested<A> editMatchingSource(Predicate<HubSourceStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.sources.size(); ++i) {
            if (!predicate.test(this.sources.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching sources. No match found.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OperatorHubStatusFluent that = (OperatorHubStatusFluent)o;
        if (!Objects.equals(this.sources, that.sources)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.sources, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.sources != null && !this.sources.isEmpty()) {
            sb.append("sources:");
            sb.append(this.sources + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SourcesNested<N>
    extends HubSourceStatusFluent<SourcesNested<N>>
    implements Nested<N> {
        HubSourceStatusBuilder builder;
        int index;

        SourcesNested(int index, HubSourceStatus item) {
            this.index = index;
            this.builder = new HubSourceStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)OperatorHubStatusFluent.this.setToSources(this.index, this.builder.build());
        }

        public N endSource() {
            return this.and();
        }
    }
}

