/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.SecretLocalReference;
import io.fabric8.openshift.api.model.SecretLocalReferenceBuilder;
import io.fabric8.openshift.api.model.SecretLocalReferenceFluent;
import io.fabric8.openshift.api.model.WebHookTrigger;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class WebHookTriggerFluent<A extends WebHookTriggerFluent<A>>
extends BaseFluent<A> {
    private Boolean allowEnv;
    private String secret;
    private SecretLocalReferenceBuilder secretReference;
    private Map<String, Object> additionalProperties;

    public WebHookTriggerFluent() {
    }

    public WebHookTriggerFluent(WebHookTrigger instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(WebHookTrigger instance) {
        WebHookTrigger webHookTrigger = instance = instance != null ? instance : new WebHookTrigger();
        if (instance != null) {
            this.withAllowEnv(instance.getAllowEnv());
            this.withSecret(instance.getSecret());
            this.withSecretReference(instance.getSecretReference());
            this.withAllowEnv(instance.getAllowEnv());
            this.withSecret(instance.getSecret());
            this.withSecretReference(instance.getSecretReference());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Boolean getAllowEnv() {
        return this.allowEnv;
    }

    public A withAllowEnv(Boolean allowEnv) {
        this.allowEnv = allowEnv;
        return (A)this;
    }

    public boolean hasAllowEnv() {
        return this.allowEnv != null;
    }

    public String getSecret() {
        return this.secret;
    }

    public A withSecret(String secret) {
        this.secret = secret;
        return (A)this;
    }

    public boolean hasSecret() {
        return this.secret != null;
    }

    public SecretLocalReference buildSecretReference() {
        return this.secretReference != null ? this.secretReference.build() : null;
    }

    public A withSecretReference(SecretLocalReference secretReference) {
        this._visitables.get("secretReference").remove(this.secretReference);
        if (secretReference != null) {
            this.secretReference = new SecretLocalReferenceBuilder(secretReference);
            this._visitables.get("secretReference").add(this.secretReference);
        } else {
            this.secretReference = null;
            this._visitables.get("secretReference").remove(this.secretReference);
        }
        return (A)this;
    }

    public boolean hasSecretReference() {
        return this.secretReference != null;
    }

    public A withNewSecretReference(String name) {
        return this.withSecretReference(new SecretLocalReference(name));
    }

    public SecretReferenceNested<A> withNewSecretReference() {
        return new SecretReferenceNested(null);
    }

    public SecretReferenceNested<A> withNewSecretReferenceLike(SecretLocalReference item) {
        return new SecretReferenceNested(item);
    }

    public SecretReferenceNested<A> editSecretReference() {
        return this.withNewSecretReferenceLike(Optional.ofNullable(this.buildSecretReference()).orElse(null));
    }

    public SecretReferenceNested<A> editOrNewSecretReference() {
        return this.withNewSecretReferenceLike(Optional.ofNullable(this.buildSecretReference()).orElse(new SecretLocalReferenceBuilder().build()));
    }

    public SecretReferenceNested<A> editOrNewSecretReferenceLike(SecretLocalReference item) {
        return this.withNewSecretReferenceLike(Optional.ofNullable(this.buildSecretReference()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WebHookTriggerFluent that = (WebHookTriggerFluent)o;
        if (!Objects.equals(this.allowEnv, that.allowEnv)) {
            return false;
        }
        if (!Objects.equals(this.secret, that.secret)) {
            return false;
        }
        if (!Objects.equals(this.secretReference, that.secretReference)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.allowEnv, this.secret, this.secretReference, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allowEnv != null) {
            sb.append("allowEnv:");
            sb.append(this.allowEnv + ",");
        }
        if (this.secret != null) {
            sb.append("secret:");
            sb.append(this.secret + ",");
        }
        if (this.secretReference != null) {
            sb.append("secretReference:");
            sb.append(this.secretReference + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAllowEnv() {
        return this.withAllowEnv(true);
    }

    public class SecretReferenceNested<N>
    extends SecretLocalReferenceFluent<SecretReferenceNested<N>>
    implements Nested<N> {
        SecretLocalReferenceBuilder builder;

        SecretReferenceNested(SecretLocalReference item) {
            this.builder = new SecretLocalReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)WebHookTriggerFluent.this.withSecretReference(this.builder.build());
        }

        public N endSecretReference() {
            return this.and();
        }
    }
}

