/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.openshift.api.model.BinaryBuildSource;
import io.fabric8.openshift.api.model.BinaryBuildSourceBuilder;
import io.fabric8.openshift.api.model.BinaryBuildSourceFluent;
import io.fabric8.openshift.api.model.BuildRequest;
import io.fabric8.openshift.api.model.BuildTriggerCause;
import io.fabric8.openshift.api.model.BuildTriggerCauseBuilder;
import io.fabric8.openshift.api.model.BuildTriggerCauseFluent;
import io.fabric8.openshift.api.model.DockerStrategyOptions;
import io.fabric8.openshift.api.model.DockerStrategyOptionsBuilder;
import io.fabric8.openshift.api.model.DockerStrategyOptionsFluent;
import io.fabric8.openshift.api.model.SourceRevision;
import io.fabric8.openshift.api.model.SourceRevisionBuilder;
import io.fabric8.openshift.api.model.SourceRevisionFluent;
import io.fabric8.openshift.api.model.SourceStrategyOptions;
import io.fabric8.openshift.api.model.SourceStrategyOptionsBuilder;
import io.fabric8.openshift.api.model.SourceStrategyOptionsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class BuildRequestFluent<A extends BuildRequestFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private BinaryBuildSourceBuilder binary;
    private DockerStrategyOptionsBuilder dockerStrategyOptions;
    private List<EnvVar> env = new ArrayList<EnvVar>();
    private ObjectReferenceBuilder from;
    private String kind;
    private Long lastVersion;
    private ObjectMetaBuilder metadata;
    private SourceRevisionBuilder revision;
    private SourceStrategyOptionsBuilder sourceStrategyOptions;
    private ArrayList<BuildTriggerCauseBuilder> triggeredBy = new ArrayList();
    private ObjectReferenceBuilder triggeredByImage;
    private Map<String, Object> additionalProperties;

    public BuildRequestFluent() {
    }

    public BuildRequestFluent(BuildRequest instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(BuildRequest instance) {
        BuildRequest buildRequest = instance = instance != null ? instance : new BuildRequest();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withBinary(instance.getBinary());
            this.withDockerStrategyOptions(instance.getDockerStrategyOptions());
            this.withEnv(instance.getEnv());
            this.withFrom(instance.getFrom());
            this.withKind(instance.getKind());
            this.withLastVersion(instance.getLastVersion());
            this.withMetadata(instance.getMetadata());
            this.withRevision(instance.getRevision());
            this.withSourceStrategyOptions(instance.getSourceStrategyOptions());
            this.withTriggeredBy(instance.getTriggeredBy());
            this.withTriggeredByImage(instance.getTriggeredByImage());
            this.withApiVersion(instance.getApiVersion());
            this.withBinary(instance.getBinary());
            this.withDockerStrategyOptions(instance.getDockerStrategyOptions());
            this.withEnv(instance.getEnv());
            this.withFrom(instance.getFrom());
            this.withKind(instance.getKind());
            this.withLastVersion(instance.getLastVersion());
            this.withMetadata(instance.getMetadata());
            this.withRevision(instance.getRevision());
            this.withSourceStrategyOptions(instance.getSourceStrategyOptions());
            this.withTriggeredBy(instance.getTriggeredBy());
            this.withTriggeredByImage(instance.getTriggeredByImage());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public BinaryBuildSource buildBinary() {
        return this.binary != null ? this.binary.build() : null;
    }

    public A withBinary(BinaryBuildSource binary) {
        this._visitables.get("binary").remove(this.binary);
        if (binary != null) {
            this.binary = new BinaryBuildSourceBuilder(binary);
            this._visitables.get("binary").add(this.binary);
        } else {
            this.binary = null;
            this._visitables.get("binary").remove(this.binary);
        }
        return (A)this;
    }

    public boolean hasBinary() {
        return this.binary != null;
    }

    public A withNewBinary(String asFile) {
        return this.withBinary(new BinaryBuildSource(asFile));
    }

    public BinaryNested<A> withNewBinary() {
        return new BinaryNested(null);
    }

    public BinaryNested<A> withNewBinaryLike(BinaryBuildSource item) {
        return new BinaryNested(item);
    }

    public BinaryNested<A> editBinary() {
        return this.withNewBinaryLike(Optional.ofNullable(this.buildBinary()).orElse(null));
    }

    public BinaryNested<A> editOrNewBinary() {
        return this.withNewBinaryLike(Optional.ofNullable(this.buildBinary()).orElse(new BinaryBuildSourceBuilder().build()));
    }

    public BinaryNested<A> editOrNewBinaryLike(BinaryBuildSource item) {
        return this.withNewBinaryLike(Optional.ofNullable(this.buildBinary()).orElse(item));
    }

    public DockerStrategyOptions buildDockerStrategyOptions() {
        return this.dockerStrategyOptions != null ? this.dockerStrategyOptions.build() : null;
    }

    public A withDockerStrategyOptions(DockerStrategyOptions dockerStrategyOptions) {
        this._visitables.get("dockerStrategyOptions").remove(this.dockerStrategyOptions);
        if (dockerStrategyOptions != null) {
            this.dockerStrategyOptions = new DockerStrategyOptionsBuilder(dockerStrategyOptions);
            this._visitables.get("dockerStrategyOptions").add(this.dockerStrategyOptions);
        } else {
            this.dockerStrategyOptions = null;
            this._visitables.get("dockerStrategyOptions").remove(this.dockerStrategyOptions);
        }
        return (A)this;
    }

    public boolean hasDockerStrategyOptions() {
        return this.dockerStrategyOptions != null;
    }

    public DockerStrategyOptionsNested<A> withNewDockerStrategyOptions() {
        return new DockerStrategyOptionsNested(null);
    }

    public DockerStrategyOptionsNested<A> withNewDockerStrategyOptionsLike(DockerStrategyOptions item) {
        return new DockerStrategyOptionsNested(item);
    }

    public DockerStrategyOptionsNested<A> editDockerStrategyOptions() {
        return this.withNewDockerStrategyOptionsLike(Optional.ofNullable(this.buildDockerStrategyOptions()).orElse(null));
    }

    public DockerStrategyOptionsNested<A> editOrNewDockerStrategyOptions() {
        return this.withNewDockerStrategyOptionsLike(Optional.ofNullable(this.buildDockerStrategyOptions()).orElse(new DockerStrategyOptionsBuilder().build()));
    }

    public DockerStrategyOptionsNested<A> editOrNewDockerStrategyOptionsLike(DockerStrategyOptions item) {
        return this.withNewDockerStrategyOptionsLike(Optional.ofNullable(this.buildDockerStrategyOptions()).orElse(item));
    }

    public A addToEnv(int index, EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVar>();
        }
        this.env.add(index, item);
        return (A)this;
    }

    public A setToEnv(int index, EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVar>();
        }
        this.env.set(index, item);
        return (A)this;
    }

    public A addToEnv(EnvVar ... items) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVar>();
        }
        for (EnvVar item : items) {
            this.env.add(item);
        }
        return (A)this;
    }

    public A addAllToEnv(Collection<EnvVar> items) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVar>();
        }
        for (EnvVar item : items) {
            this.env.add(item);
        }
        return (A)this;
    }

    public A removeFromEnv(EnvVar ... items) {
        if (this.env == null) {
            return (A)this;
        }
        for (EnvVar item : items) {
            this.env.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromEnv(Collection<EnvVar> items) {
        if (this.env == null) {
            return (A)this;
        }
        for (EnvVar item : items) {
            this.env.remove(item);
        }
        return (A)this;
    }

    public List<EnvVar> getEnv() {
        return this.env;
    }

    public EnvVar getEnv(int index) {
        return this.env.get(index);
    }

    public EnvVar getFirstEnv() {
        return this.env.get(0);
    }

    public EnvVar getLastEnv() {
        return this.env.get(this.env.size() - 1);
    }

    public EnvVar getMatchingEnv(Predicate<EnvVar> predicate) {
        for (EnvVar item : this.env) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingEnv(Predicate<EnvVar> predicate) {
        for (EnvVar item : this.env) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEnv(List<EnvVar> env) {
        if (env != null) {
            this.env = new ArrayList<EnvVar>();
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        } else {
            this.env = null;
        }
        return (A)this;
    }

    public A withEnv(EnvVar ... env) {
        if (this.env != null) {
            this.env.clear();
            this._visitables.remove("env");
        }
        if (env != null) {
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (A)this;
    }

    public boolean hasEnv() {
        return this.env != null && !this.env.isEmpty();
    }

    public ObjectReference buildFrom() {
        return this.from != null ? this.from.build() : null;
    }

    public A withFrom(ObjectReference from) {
        this._visitables.get("from").remove(this.from);
        if (from != null) {
            this.from = new ObjectReferenceBuilder(from);
            this._visitables.get("from").add(this.from);
        } else {
            this.from = null;
            this._visitables.get("from").remove(this.from);
        }
        return (A)this;
    }

    public boolean hasFrom() {
        return this.from != null;
    }

    public FromNested<A> withNewFrom() {
        return new FromNested(null);
    }

    public FromNested<A> withNewFromLike(ObjectReference item) {
        return new FromNested(item);
    }

    public FromNested<A> editFrom() {
        return this.withNewFromLike(Optional.ofNullable(this.buildFrom()).orElse(null));
    }

    public FromNested<A> editOrNewFrom() {
        return this.withNewFromLike(Optional.ofNullable(this.buildFrom()).orElse(new ObjectReferenceBuilder().build()));
    }

    public FromNested<A> editOrNewFromLike(ObjectReference item) {
        return this.withNewFromLike(Optional.ofNullable(this.buildFrom()).orElse(item));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public Long getLastVersion() {
        return this.lastVersion;
    }

    public A withLastVersion(Long lastVersion) {
        this.lastVersion = lastVersion;
        return (A)this;
    }

    public boolean hasLastVersion() {
        return this.lastVersion != null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public SourceRevision buildRevision() {
        return this.revision != null ? this.revision.build() : null;
    }

    public A withRevision(SourceRevision revision) {
        this._visitables.get("revision").remove(this.revision);
        if (revision != null) {
            this.revision = new SourceRevisionBuilder(revision);
            this._visitables.get("revision").add(this.revision);
        } else {
            this.revision = null;
            this._visitables.get("revision").remove(this.revision);
        }
        return (A)this;
    }

    public boolean hasRevision() {
        return this.revision != null;
    }

    public RevisionNested<A> withNewRevision() {
        return new RevisionNested(null);
    }

    public RevisionNested<A> withNewRevisionLike(SourceRevision item) {
        return new RevisionNested(item);
    }

    public RevisionNested<A> editRevision() {
        return this.withNewRevisionLike(Optional.ofNullable(this.buildRevision()).orElse(null));
    }

    public RevisionNested<A> editOrNewRevision() {
        return this.withNewRevisionLike(Optional.ofNullable(this.buildRevision()).orElse(new SourceRevisionBuilder().build()));
    }

    public RevisionNested<A> editOrNewRevisionLike(SourceRevision item) {
        return this.withNewRevisionLike(Optional.ofNullable(this.buildRevision()).orElse(item));
    }

    public SourceStrategyOptions buildSourceStrategyOptions() {
        return this.sourceStrategyOptions != null ? this.sourceStrategyOptions.build() : null;
    }

    public A withSourceStrategyOptions(SourceStrategyOptions sourceStrategyOptions) {
        this._visitables.get("sourceStrategyOptions").remove(this.sourceStrategyOptions);
        if (sourceStrategyOptions != null) {
            this.sourceStrategyOptions = new SourceStrategyOptionsBuilder(sourceStrategyOptions);
            this._visitables.get("sourceStrategyOptions").add(this.sourceStrategyOptions);
        } else {
            this.sourceStrategyOptions = null;
            this._visitables.get("sourceStrategyOptions").remove(this.sourceStrategyOptions);
        }
        return (A)this;
    }

    public boolean hasSourceStrategyOptions() {
        return this.sourceStrategyOptions != null;
    }

    public A withNewSourceStrategyOptions(Boolean incremental) {
        return this.withSourceStrategyOptions(new SourceStrategyOptions(incremental));
    }

    public SourceStrategyOptionsNested<A> withNewSourceStrategyOptions() {
        return new SourceStrategyOptionsNested(null);
    }

    public SourceStrategyOptionsNested<A> withNewSourceStrategyOptionsLike(SourceStrategyOptions item) {
        return new SourceStrategyOptionsNested(item);
    }

    public SourceStrategyOptionsNested<A> editSourceStrategyOptions() {
        return this.withNewSourceStrategyOptionsLike(Optional.ofNullable(this.buildSourceStrategyOptions()).orElse(null));
    }

    public SourceStrategyOptionsNested<A> editOrNewSourceStrategyOptions() {
        return this.withNewSourceStrategyOptionsLike(Optional.ofNullable(this.buildSourceStrategyOptions()).orElse(new SourceStrategyOptionsBuilder().build()));
    }

    public SourceStrategyOptionsNested<A> editOrNewSourceStrategyOptionsLike(SourceStrategyOptions item) {
        return this.withNewSourceStrategyOptionsLike(Optional.ofNullable(this.buildSourceStrategyOptions()).orElse(item));
    }

    public A addToTriggeredBy(int index, BuildTriggerCause item) {
        if (this.triggeredBy == null) {
            this.triggeredBy = new ArrayList();
        }
        BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);
        if (index < 0 || index >= this.triggeredBy.size()) {
            this._visitables.get("triggeredBy").add(builder);
            this.triggeredBy.add(builder);
        } else {
            this._visitables.get("triggeredBy").add(index, builder);
            this.triggeredBy.add(index, builder);
        }
        return (A)this;
    }

    public A setToTriggeredBy(int index, BuildTriggerCause item) {
        if (this.triggeredBy == null) {
            this.triggeredBy = new ArrayList();
        }
        BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);
        if (index < 0 || index >= this.triggeredBy.size()) {
            this._visitables.get("triggeredBy").add(builder);
            this.triggeredBy.add(builder);
        } else {
            this._visitables.get("triggeredBy").set(index, builder);
            this.triggeredBy.set(index, builder);
        }
        return (A)this;
    }

    public A addToTriggeredBy(BuildTriggerCause ... items) {
        if (this.triggeredBy == null) {
            this.triggeredBy = new ArrayList();
        }
        for (BuildTriggerCause item : items) {
            BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);
            this._visitables.get("triggeredBy").add(builder);
            this.triggeredBy.add(builder);
        }
        return (A)this;
    }

    public A addAllToTriggeredBy(Collection<BuildTriggerCause> items) {
        if (this.triggeredBy == null) {
            this.triggeredBy = new ArrayList();
        }
        for (BuildTriggerCause item : items) {
            BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);
            this._visitables.get("triggeredBy").add(builder);
            this.triggeredBy.add(builder);
        }
        return (A)this;
    }

    public A removeFromTriggeredBy(BuildTriggerCause ... items) {
        if (this.triggeredBy == null) {
            return (A)this;
        }
        for (BuildTriggerCause item : items) {
            BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);
            this._visitables.get("triggeredBy").remove(builder);
            this.triggeredBy.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromTriggeredBy(Collection<BuildTriggerCause> items) {
        if (this.triggeredBy == null) {
            return (A)this;
        }
        for (BuildTriggerCause item : items) {
            BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);
            this._visitables.get("triggeredBy").remove(builder);
            this.triggeredBy.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromTriggeredBy(Predicate<BuildTriggerCauseBuilder> predicate) {
        if (this.triggeredBy == null) {
            return (A)this;
        }
        Iterator<BuildTriggerCauseBuilder> each = this.triggeredBy.iterator();
        Object visitables = this._visitables.get("triggeredBy");
        while (each.hasNext()) {
            BuildTriggerCauseBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<BuildTriggerCause> buildTriggeredBy() {
        return this.triggeredBy != null ? BuildRequestFluent.build(this.triggeredBy) : null;
    }

    public BuildTriggerCause buildTriggeredBy(int index) {
        return this.triggeredBy.get(index).build();
    }

    public BuildTriggerCause buildFirstTriggeredBy() {
        return this.triggeredBy.get(0).build();
    }

    public BuildTriggerCause buildLastTriggeredBy() {
        return this.triggeredBy.get(this.triggeredBy.size() - 1).build();
    }

    public BuildTriggerCause buildMatchingTriggeredBy(Predicate<BuildTriggerCauseBuilder> predicate) {
        for (BuildTriggerCauseBuilder item : this.triggeredBy) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingTriggeredBy(Predicate<BuildTriggerCauseBuilder> predicate) {
        for (BuildTriggerCauseBuilder item : this.triggeredBy) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTriggeredBy(List<BuildTriggerCause> triggeredBy) {
        if (this.triggeredBy != null) {
            this._visitables.get("triggeredBy").clear();
        }
        if (triggeredBy != null) {
            this.triggeredBy = new ArrayList();
            for (BuildTriggerCause item : triggeredBy) {
                this.addToTriggeredBy(item);
            }
        } else {
            this.triggeredBy = null;
        }
        return (A)this;
    }

    public A withTriggeredBy(BuildTriggerCause ... triggeredBy) {
        if (this.triggeredBy != null) {
            this.triggeredBy.clear();
            this._visitables.remove("triggeredBy");
        }
        if (triggeredBy != null) {
            for (BuildTriggerCause item : triggeredBy) {
                this.addToTriggeredBy(item);
            }
        }
        return (A)this;
    }

    public boolean hasTriggeredBy() {
        return this.triggeredBy != null && !this.triggeredBy.isEmpty();
    }

    public TriggeredByNested<A> addNewTriggeredBy() {
        return new TriggeredByNested(-1, null);
    }

    public TriggeredByNested<A> addNewTriggeredByLike(BuildTriggerCause item) {
        return new TriggeredByNested(-1, item);
    }

    public TriggeredByNested<A> setNewTriggeredByLike(int index, BuildTriggerCause item) {
        return new TriggeredByNested(index, item);
    }

    public TriggeredByNested<A> editTriggeredBy(int index) {
        if (this.triggeredBy.size() <= index) {
            throw new RuntimeException("Can't edit triggeredBy. Index exceeds size.");
        }
        return this.setNewTriggeredByLike(index, this.buildTriggeredBy(index));
    }

    public TriggeredByNested<A> editFirstTriggeredBy() {
        if (this.triggeredBy.size() == 0) {
            throw new RuntimeException("Can't edit first triggeredBy. The list is empty.");
        }
        return this.setNewTriggeredByLike(0, this.buildTriggeredBy(0));
    }

    public TriggeredByNested<A> editLastTriggeredBy() {
        int index = this.triggeredBy.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last triggeredBy. The list is empty.");
        }
        return this.setNewTriggeredByLike(index, this.buildTriggeredBy(index));
    }

    public TriggeredByNested<A> editMatchingTriggeredBy(Predicate<BuildTriggerCauseBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.triggeredBy.size(); ++i) {
            if (!predicate.test(this.triggeredBy.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching triggeredBy. No match found.");
        }
        return this.setNewTriggeredByLike(index, this.buildTriggeredBy(index));
    }

    public ObjectReference buildTriggeredByImage() {
        return this.triggeredByImage != null ? this.triggeredByImage.build() : null;
    }

    public A withTriggeredByImage(ObjectReference triggeredByImage) {
        this._visitables.get("triggeredByImage").remove(this.triggeredByImage);
        if (triggeredByImage != null) {
            this.triggeredByImage = new ObjectReferenceBuilder(triggeredByImage);
            this._visitables.get("triggeredByImage").add(this.triggeredByImage);
        } else {
            this.triggeredByImage = null;
            this._visitables.get("triggeredByImage").remove(this.triggeredByImage);
        }
        return (A)this;
    }

    public boolean hasTriggeredByImage() {
        return this.triggeredByImage != null;
    }

    public TriggeredByImageNested<A> withNewTriggeredByImage() {
        return new TriggeredByImageNested(null);
    }

    public TriggeredByImageNested<A> withNewTriggeredByImageLike(ObjectReference item) {
        return new TriggeredByImageNested(item);
    }

    public TriggeredByImageNested<A> editTriggeredByImage() {
        return this.withNewTriggeredByImageLike(Optional.ofNullable(this.buildTriggeredByImage()).orElse(null));
    }

    public TriggeredByImageNested<A> editOrNewTriggeredByImage() {
        return this.withNewTriggeredByImageLike(Optional.ofNullable(this.buildTriggeredByImage()).orElse(new ObjectReferenceBuilder().build()));
    }

    public TriggeredByImageNested<A> editOrNewTriggeredByImageLike(ObjectReference item) {
        return this.withNewTriggeredByImageLike(Optional.ofNullable(this.buildTriggeredByImage()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildRequestFluent that = (BuildRequestFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.binary, that.binary)) {
            return false;
        }
        if (!Objects.equals(this.dockerStrategyOptions, that.dockerStrategyOptions)) {
            return false;
        }
        if (!Objects.equals(this.env, that.env)) {
            return false;
        }
        if (!Objects.equals(this.from, that.from)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.lastVersion, that.lastVersion)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.revision, that.revision)) {
            return false;
        }
        if (!Objects.equals(this.sourceStrategyOptions, that.sourceStrategyOptions)) {
            return false;
        }
        if (!Objects.equals(this.triggeredBy, that.triggeredBy)) {
            return false;
        }
        if (!Objects.equals(this.triggeredByImage, that.triggeredByImage)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.binary, this.dockerStrategyOptions, this.env, this.from, this.kind, this.lastVersion, this.metadata, this.revision, this.sourceStrategyOptions, this.triggeredBy, this.triggeredByImage, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.binary != null) {
            sb.append("binary:");
            sb.append(this.binary + ",");
        }
        if (this.dockerStrategyOptions != null) {
            sb.append("dockerStrategyOptions:");
            sb.append(this.dockerStrategyOptions + ",");
        }
        if (this.env != null && !this.env.isEmpty()) {
            sb.append("env:");
            sb.append(this.env + ",");
        }
        if (this.from != null) {
            sb.append("from:");
            sb.append(this.from + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.lastVersion != null) {
            sb.append("lastVersion:");
            sb.append(this.lastVersion + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.revision != null) {
            sb.append("revision:");
            sb.append(this.revision + ",");
        }
        if (this.sourceStrategyOptions != null) {
            sb.append("sourceStrategyOptions:");
            sb.append(this.sourceStrategyOptions + ",");
        }
        if (this.triggeredBy != null && !this.triggeredBy.isEmpty()) {
            sb.append("triggeredBy:");
            sb.append(this.triggeredBy + ",");
        }
        if (this.triggeredByImage != null) {
            sb.append("triggeredByImage:");
            sb.append(this.triggeredByImage + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TriggeredByImageNested<N>
    extends ObjectReferenceFluent<TriggeredByImageNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        TriggeredByImageNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildRequestFluent.this.withTriggeredByImage(this.builder.build());
        }

        public N endTriggeredByImage() {
            return this.and();
        }
    }

    public class TriggeredByNested<N>
    extends BuildTriggerCauseFluent<TriggeredByNested<N>>
    implements Nested<N> {
        BuildTriggerCauseBuilder builder;
        int index;

        TriggeredByNested(int index, BuildTriggerCause item) {
            this.index = index;
            this.builder = new BuildTriggerCauseBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildRequestFluent.this.setToTriggeredBy(this.index, this.builder.build());
        }

        public N endTriggeredBy() {
            return this.and();
        }
    }

    public class SourceStrategyOptionsNested<N>
    extends SourceStrategyOptionsFluent<SourceStrategyOptionsNested<N>>
    implements Nested<N> {
        SourceStrategyOptionsBuilder builder;

        SourceStrategyOptionsNested(SourceStrategyOptions item) {
            this.builder = new SourceStrategyOptionsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildRequestFluent.this.withSourceStrategyOptions(this.builder.build());
        }

        public N endSourceStrategyOptions() {
            return this.and();
        }
    }

    public class RevisionNested<N>
    extends SourceRevisionFluent<RevisionNested<N>>
    implements Nested<N> {
        SourceRevisionBuilder builder;

        RevisionNested(SourceRevision item) {
            this.builder = new SourceRevisionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildRequestFluent.this.withRevision(this.builder.build());
        }

        public N endRevision() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildRequestFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class FromNested<N>
    extends ObjectReferenceFluent<FromNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        FromNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildRequestFluent.this.withFrom(this.builder.build());
        }

        public N endFrom() {
            return this.and();
        }
    }

    public class DockerStrategyOptionsNested<N>
    extends DockerStrategyOptionsFluent<DockerStrategyOptionsNested<N>>
    implements Nested<N> {
        DockerStrategyOptionsBuilder builder;

        DockerStrategyOptionsNested(DockerStrategyOptions item) {
            this.builder = new DockerStrategyOptionsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildRequestFluent.this.withDockerStrategyOptions(this.builder.build());
        }

        public N endDockerStrategyOptions() {
            return this.and();
        }
    }

    public class BinaryNested<N>
    extends BinaryBuildSourceFluent<BinaryNested<N>>
    implements Nested<N> {
        BinaryBuildSourceBuilder builder;

        BinaryNested(BinaryBuildSource item) {
            this.builder = new BinaryBuildSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildRequestFluent.this.withBinary(this.builder.build());
        }

        public N endBinary() {
            return this.and();
        }
    }
}

