/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.CustomBuildStrategy;
import io.fabric8.openshift.api.model.CustomBuildStrategyFluent;
import io.fabric8.openshift.api.model.SecretSpec;
import io.fabric8.openshift.api.model.SecretSpecBuilder;
import io.fabric8.openshift.api.model.SecretSpecFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class CustomBuildStrategyFluentImpl<A extends CustomBuildStrategyFluent<A>>
extends BaseFluent<A>
implements CustomBuildStrategyFluent<A> {
    private String buildAPIVersion;
    private List<EnvVar> env = new ArrayList<EnvVar>();
    private Boolean exposeDockerSocket;
    private Boolean forcePull;
    private ObjectReferenceBuilder from;
    private LocalObjectReferenceBuilder pullSecret;
    private List<SecretSpecBuilder> secrets = new ArrayList<SecretSpecBuilder>();

    public CustomBuildStrategyFluentImpl() {
    }

    public CustomBuildStrategyFluentImpl(CustomBuildStrategy instance) {
        this.withBuildAPIVersion(instance.getBuildAPIVersion());
        this.withEnv(instance.getEnv());
        this.withExposeDockerSocket(instance.getExposeDockerSocket());
        this.withForcePull(instance.getForcePull());
        this.withFrom(instance.getFrom());
        this.withPullSecret(instance.getPullSecret());
        this.withSecrets(instance.getSecrets());
    }

    @Override
    public String getBuildAPIVersion() {
        return this.buildAPIVersion;
    }

    @Override
    public A withBuildAPIVersion(String buildAPIVersion) {
        this.buildAPIVersion = buildAPIVersion;
        return (A)this;
    }

    @Override
    public Boolean hasBuildAPIVersion() {
        return this.buildAPIVersion != null;
    }

    @Override
    @Deprecated
    public A withNewBuildAPIVersion(String arg0) {
        return this.withBuildAPIVersion(new String(arg0));
    }

    @Override
    public A addToEnv(Integer index, EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVar>();
        }
        this.env.add(index, item);
        return (A)this;
    }

    @Override
    public A setToEnv(Integer index, EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVar>();
        }
        this.env.set(index, item);
        return (A)this;
    }

    @Override
    public A addToEnv(EnvVar ... items) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVar>();
        }
        for (EnvVar item : items) {
            this.env.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToEnv(Collection<EnvVar> items) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVar>();
        }
        for (EnvVar item : items) {
            this.env.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromEnv(EnvVar ... items) {
        for (EnvVar item : items) {
            if (this.env == null) continue;
            this.env.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEnv(Collection<EnvVar> items) {
        for (EnvVar item : items) {
            if (this.env == null) continue;
            this.env.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<EnvVar> getEnv() {
        return this.env;
    }

    @Override
    public EnvVar getEnv(Integer index) {
        return this.env.get(index);
    }

    @Override
    public EnvVar getFirstEnv() {
        return this.env.get(0);
    }

    @Override
    public EnvVar getLastEnv() {
        return this.env.get(this.env.size() - 1);
    }

    @Override
    public EnvVar getMatchingEnv(Predicate<EnvVar> predicate) {
        for (EnvVar item : this.env) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEnv(Predicate<EnvVar> predicate) {
        for (EnvVar item : this.env) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEnv(List<EnvVar> env) {
        if (env != null) {
            this.env = new ArrayList<EnvVar>();
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        } else {
            this.env = null;
        }
        return (A)this;
    }

    @Override
    public A withEnv(EnvVar ... env) {
        if (this.env != null) {
            this.env.clear();
        }
        if (env != null) {
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEnv() {
        return this.env != null && !this.env.isEmpty();
    }

    @Override
    public Boolean getExposeDockerSocket() {
        return this.exposeDockerSocket;
    }

    @Override
    public A withExposeDockerSocket(Boolean exposeDockerSocket) {
        this.exposeDockerSocket = exposeDockerSocket;
        return (A)this;
    }

    @Override
    public Boolean hasExposeDockerSocket() {
        return this.exposeDockerSocket != null;
    }

    @Override
    public Boolean getForcePull() {
        return this.forcePull;
    }

    @Override
    public A withForcePull(Boolean forcePull) {
        this.forcePull = forcePull;
        return (A)this;
    }

    @Override
    public Boolean hasForcePull() {
        return this.forcePull != null;
    }

    @Override
    @Deprecated
    public ObjectReference getFrom() {
        return this.from != null ? this.from.build() : null;
    }

    @Override
    public ObjectReference buildFrom() {
        return this.from != null ? this.from.build() : null;
    }

    @Override
    public A withFrom(ObjectReference from) {
        this._visitables.get("from").remove(this.from);
        if (from != null) {
            this.from = new ObjectReferenceBuilder(from);
            this._visitables.get("from").add(this.from);
        }
        return (A)this;
    }

    @Override
    public Boolean hasFrom() {
        return this.from != null;
    }

    @Override
    public CustomBuildStrategyFluent.FromNested<A> withNewFrom() {
        return new FromNestedImpl();
    }

    @Override
    public CustomBuildStrategyFluent.FromNested<A> withNewFromLike(ObjectReference item) {
        return new FromNestedImpl(item);
    }

    @Override
    public CustomBuildStrategyFluent.FromNested<A> editFrom() {
        return this.withNewFromLike(this.getFrom());
    }

    @Override
    public CustomBuildStrategyFluent.FromNested<A> editOrNewFrom() {
        return this.withNewFromLike(this.getFrom() != null ? this.getFrom() : new ObjectReferenceBuilder().build());
    }

    @Override
    public CustomBuildStrategyFluent.FromNested<A> editOrNewFromLike(ObjectReference item) {
        return this.withNewFromLike(this.getFrom() != null ? this.getFrom() : item);
    }

    @Override
    @Deprecated
    public LocalObjectReference getPullSecret() {
        return this.pullSecret != null ? this.pullSecret.build() : null;
    }

    @Override
    public LocalObjectReference buildPullSecret() {
        return this.pullSecret != null ? this.pullSecret.build() : null;
    }

    @Override
    public A withPullSecret(LocalObjectReference pullSecret) {
        this._visitables.get("pullSecret").remove(this.pullSecret);
        if (pullSecret != null) {
            this.pullSecret = new LocalObjectReferenceBuilder(pullSecret);
            this._visitables.get("pullSecret").add(this.pullSecret);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPullSecret() {
        return this.pullSecret != null;
    }

    @Override
    public A withNewPullSecret(String name) {
        return this.withPullSecret(new LocalObjectReference(name));
    }

    @Override
    public CustomBuildStrategyFluent.PullSecretNested<A> withNewPullSecret() {
        return new PullSecretNestedImpl();
    }

    @Override
    public CustomBuildStrategyFluent.PullSecretNested<A> withNewPullSecretLike(LocalObjectReference item) {
        return new PullSecretNestedImpl(item);
    }

    @Override
    public CustomBuildStrategyFluent.PullSecretNested<A> editPullSecret() {
        return this.withNewPullSecretLike(this.getPullSecret());
    }

    @Override
    public CustomBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecret() {
        return this.withNewPullSecretLike(this.getPullSecret() != null ? this.getPullSecret() : new LocalObjectReferenceBuilder().build());
    }

    @Override
    public CustomBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecretLike(LocalObjectReference item) {
        return this.withNewPullSecretLike(this.getPullSecret() != null ? this.getPullSecret() : item);
    }

    @Override
    public A addToSecrets(Integer index, SecretSpec item) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<SecretSpecBuilder>();
        }
        SecretSpecBuilder builder = new SecretSpecBuilder(item);
        this._visitables.get("secrets").add(index >= 0 ? index.intValue() : this._visitables.get("secrets").size(), builder);
        this.secrets.add(index >= 0 ? index.intValue() : this.secrets.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSecrets(Integer index, SecretSpec item) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<SecretSpecBuilder>();
        }
        SecretSpecBuilder builder = new SecretSpecBuilder(item);
        if (index < 0 || index >= this._visitables.get("secrets").size()) {
            this._visitables.get("secrets").add(builder);
        } else {
            this._visitables.get("secrets").set(index, builder);
        }
        if (index < 0 || index >= this.secrets.size()) {
            this.secrets.add(builder);
        } else {
            this.secrets.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSecrets(SecretSpec ... items) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<SecretSpecBuilder>();
        }
        for (SecretSpec item : items) {
            SecretSpecBuilder builder = new SecretSpecBuilder(item);
            this._visitables.get("secrets").add(builder);
            this.secrets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSecrets(Collection<SecretSpec> items) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<SecretSpecBuilder>();
        }
        for (SecretSpec item : items) {
            SecretSpecBuilder builder = new SecretSpecBuilder(item);
            this._visitables.get("secrets").add(builder);
            this.secrets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSecrets(SecretSpec ... items) {
        for (SecretSpec item : items) {
            SecretSpecBuilder builder = new SecretSpecBuilder(item);
            this._visitables.get("secrets").remove(builder);
            if (this.secrets == null) continue;
            this.secrets.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSecrets(Collection<SecretSpec> items) {
        for (SecretSpec item : items) {
            SecretSpecBuilder builder = new SecretSpecBuilder(item);
            this._visitables.get("secrets").remove(builder);
            if (this.secrets == null) continue;
            this.secrets.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSecrets(Predicate<SecretSpecBuilder> predicate) {
        if (this.secrets == null) {
            return (A)this;
        }
        Iterator<SecretSpecBuilder> each = this.secrets.iterator();
        Object visitables = this._visitables.get("secrets");
        while (each.hasNext()) {
            SecretSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<SecretSpec> getSecrets() {
        return CustomBuildStrategyFluentImpl.build(this.secrets);
    }

    @Override
    public List<SecretSpec> buildSecrets() {
        return CustomBuildStrategyFluentImpl.build(this.secrets);
    }

    @Override
    public SecretSpec buildSecret(Integer index) {
        return this.secrets.get(index).build();
    }

    @Override
    public SecretSpec buildFirstSecret() {
        return this.secrets.get(0).build();
    }

    @Override
    public SecretSpec buildLastSecret() {
        return this.secrets.get(this.secrets.size() - 1).build();
    }

    @Override
    public SecretSpec buildMatchingSecret(Predicate<SecretSpecBuilder> predicate) {
        for (SecretSpecBuilder item : this.secrets) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSecret(Predicate<SecretSpecBuilder> predicate) {
        for (SecretSpecBuilder item : this.secrets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSecrets(List<SecretSpec> secrets) {
        if (this.secrets != null) {
            this._visitables.get("secrets").removeAll(this.secrets);
        }
        if (secrets != null) {
            this.secrets = new ArrayList<SecretSpecBuilder>();
            for (SecretSpec item : secrets) {
                this.addToSecrets(item);
            }
        } else {
            this.secrets = null;
        }
        return (A)this;
    }

    @Override
    public A withSecrets(SecretSpec ... secrets) {
        if (this.secrets != null) {
            this.secrets.clear();
        }
        if (secrets != null) {
            for (SecretSpec item : secrets) {
                this.addToSecrets(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecrets() {
        return this.secrets != null && !this.secrets.isEmpty();
    }

    @Override
    public CustomBuildStrategyFluent.SecretsNested<A> addNewSecret() {
        return new SecretsNestedImpl();
    }

    @Override
    public CustomBuildStrategyFluent.SecretsNested<A> addNewSecretLike(SecretSpec item) {
        return new SecretsNestedImpl(-1, item);
    }

    @Override
    public CustomBuildStrategyFluent.SecretsNested<A> setNewSecretLike(Integer index, SecretSpec item) {
        return new SecretsNestedImpl(index, item);
    }

    @Override
    public CustomBuildStrategyFluent.SecretsNested<A> editSecret(Integer index) {
        if (this.secrets.size() <= index) {
            throw new RuntimeException("Can't edit secrets. Index exceeds size.");
        }
        return this.setNewSecretLike(index, this.buildSecret(index));
    }

    @Override
    public CustomBuildStrategyFluent.SecretsNested<A> editFirstSecret() {
        if (this.secrets.size() == 0) {
            throw new RuntimeException("Can't edit first secrets. The list is empty.");
        }
        return this.setNewSecretLike(0, this.buildSecret(0));
    }

    @Override
    public CustomBuildStrategyFluent.SecretsNested<A> editLastSecret() {
        int index = this.secrets.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last secrets. The list is empty.");
        }
        return this.setNewSecretLike(index, this.buildSecret(index));
    }

    @Override
    public CustomBuildStrategyFluent.SecretsNested<A> editMatchingSecret(Predicate<SecretSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.secrets.size(); ++i) {
            if (!predicate.test(this.secrets.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching secrets. No match found.");
        }
        return this.setNewSecretLike(index, this.buildSecret(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomBuildStrategyFluentImpl that = (CustomBuildStrategyFluentImpl)o;
        if (this.buildAPIVersion != null ? !this.buildAPIVersion.equals(that.buildAPIVersion) : that.buildAPIVersion != null) {
            return false;
        }
        if (this.env != null ? !this.env.equals(that.env) : that.env != null) {
            return false;
        }
        if (this.exposeDockerSocket != null ? !this.exposeDockerSocket.equals(that.exposeDockerSocket) : that.exposeDockerSocket != null) {
            return false;
        }
        if (this.forcePull != null ? !this.forcePull.equals(that.forcePull) : that.forcePull != null) {
            return false;
        }
        if (this.from != null ? !this.from.equals(that.from) : that.from != null) {
            return false;
        }
        if (this.pullSecret != null ? !this.pullSecret.equals(that.pullSecret) : that.pullSecret != null) {
            return false;
        }
        return !(this.secrets != null ? !this.secrets.equals(that.secrets) : that.secrets != null);
    }

    public int hashCode() {
        return Objects.hash(this.buildAPIVersion, this.env, this.exposeDockerSocket, this.forcePull, this.from, this.pullSecret, this.secrets, super.hashCode());
    }

    public class SecretsNestedImpl<N>
    extends SecretSpecFluentImpl<CustomBuildStrategyFluent.SecretsNested<N>>
    implements CustomBuildStrategyFluent.SecretsNested<N>,
    Nested<N> {
        SecretSpecBuilder builder;
        Integer index;

        SecretsNestedImpl(Integer index, SecretSpec item) {
            this.index = index;
            this.builder = new SecretSpecBuilder(this, item);
        }

        SecretsNestedImpl() {
            this.index = -1;
            this.builder = new SecretSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)CustomBuildStrategyFluentImpl.this.setToSecrets(this.index, this.builder.build());
        }

        @Override
        public N endSecret() {
            return this.and();
        }
    }

    public class PullSecretNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<CustomBuildStrategyFluent.PullSecretNested<N>>
    implements CustomBuildStrategyFluent.PullSecretNested<N>,
    Nested<N> {
        LocalObjectReferenceBuilder builder;

        PullSecretNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        PullSecretNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)CustomBuildStrategyFluentImpl.this.withPullSecret(this.builder.build());
        }

        @Override
        public N endPullSecret() {
            return this.and();
        }
    }

    public class FromNestedImpl<N>
    extends ObjectReferenceFluentImpl<CustomBuildStrategyFluent.FromNested<N>>
    implements CustomBuildStrategyFluent.FromNested<N>,
    Nested<N> {
        ObjectReferenceBuilder builder;

        FromNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        FromNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)CustomBuildStrategyFluentImpl.this.withFrom(this.builder.build());
        }

        @Override
        public N endFrom() {
            return this.and();
        }
    }
}

