/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.server.mock;

import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.server.mock.KubernetesAttributesExtractor;
import io.fabric8.kubernetes.client.utils.Serialization;
import java.util.Map;

public class CustomResourceDefinitionProcessor {
    private static final String V1BETA1_PATH = "/apis/apiextensions.k8s.io/v1beta1/customresourcedefinitions";
    private static final String V1_PATH = "/apis/apiextensions.k8s.io/v1/customresourcedefinitions";
    private KubernetesAttributesExtractor extractor;

    public CustomResourceDefinitionProcessor(KubernetesAttributesExtractor extractor) {
        this.extractor = extractor;
    }

    public void process(String path, String crdString, boolean delete) {
        CustomResourceDefinitionContext context = null;
        if (path.startsWith(V1BETA1_PATH)) {
            CustomResourceDefinition crd = Serialization.unmarshal(crdString, CustomResourceDefinition.class);
            context = CustomResourceDefinitionContext.fromCrd(crd);
        } else if (path.startsWith(V1_PATH)) {
            io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition crd = Serialization.unmarshal(crdString, io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition.class);
            context = CustomResourceDefinitionContext.fromCrd(crd);
        } else {
            return;
        }
        if (delete) {
            this.extractor.removeCrdContext(context);
        } else {
            this.extractor.addCrdContext(context);
        }
    }

    public boolean isStatusSubresource(Map<String, String> pathValues) {
        CustomResourceDefinitionContext context = this.extractor.getCrdContext(pathValues.get("api"), pathValues.get("version"), pathValues.get("plural"));
        if (context == null) {
            return false;
        }
        return context.isStatusSubresource();
    }
}

