/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.model.APIGroup;
import io.fabric8.kubernetes.api.model.APIGroupList;
import io.fabric8.kubernetes.api.model.APIResourceList;
import io.fabric8.kubernetes.api.model.RootPaths;
import io.fabric8.kubernetes.client.Adapters;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.ExtensionAdapter;
import io.fabric8.kubernetes.client.HttpClientAware;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.VersionInfo;
import io.fabric8.kubernetes.client.dsl.base.OperationSupport;
import io.fabric8.kubernetes.client.utils.HttpClientUtils;
import io.fabric8.kubernetes.client.utils.Utils;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ExecutorService;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;

public class BaseClient
implements Client,
HttpClientAware {
    public static final String APIS = "/apis";
    protected OkHttpClient httpClient;
    private URL masterUrl;
    private String apiVersion;
    private String namespace;
    private Config configuration;

    public BaseClient() {
        this(new ConfigBuilder().build());
    }

    public BaseClient(String masterUrl) {
        this(((ConfigBuilder)new ConfigBuilder().withMasterUrl(masterUrl)).build());
    }

    public BaseClient(Config config) {
        this(HttpClientUtils.createHttpClient(config), config);
    }

    public BaseClient(OkHttpClient httpClient, Config config) {
        try {
            this.configuration = config;
            this.httpClient = this.adaptOkHttpClient(httpClient);
            this.namespace = config.getNamespace();
            this.apiVersion = config.getApiVersion();
            if (config.getMasterUrl() == null) {
                throw new KubernetesClientException("Unknown Kubernetes master URL - please set with the builder, or set with either system property \"kubernetes.master\" or environment variable \"" + Utils.convertSystemPropertyNameToEnvVar("kubernetes.master") + "\"");
            }
            this.masterUrl = new URL(config.getMasterUrl());
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public void close() {
        ExecutorService executorService;
        ConnectionPool connectionPool = this.httpClient.connectionPool();
        Dispatcher dispatcher = this.httpClient.dispatcher();
        ExecutorService executorService2 = executorService = this.httpClient.dispatcher() != null ? this.httpClient.dispatcher().executorService() : null;
        if (dispatcher != null) {
            dispatcher.cancelAll();
        }
        if (connectionPool != null) {
            connectionPool.evictAll();
        }
        if (executorService != null) {
            executorService.shutdownNow();
        }
    }

    @Override
    public URL getMasterUrl() {
        return this.masterUrl;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public Config getConfiguration() {
        return this.configuration;
    }

    @Override
    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public <C> Boolean isAdaptable(Class<C> type) {
        ExtensionAdapter<C> adapter = Adapters.get(type);
        if (adapter != null) {
            return adapter.isAdaptable(this);
        }
        return false;
    }

    @Override
    public <C> C adapt(Class<C> type) {
        ExtensionAdapter<C> adapter = Adapters.get(type);
        if (adapter != null) {
            return adapter.adapt(this);
        }
        throw new IllegalStateException("No adapter available for type:" + type);
    }

    @Override
    public RootPaths rootPaths() {
        return new OperationSupport(this.httpClient, this.configuration).restCall(RootPaths.class, new String[0]);
    }

    @Override
    public boolean supportsApiPath(String apiPath) {
        List<String> paths;
        RootPaths rootPaths = this.rootPaths();
        if (rootPaths != null && (paths = rootPaths.getPaths()) != null) {
            for (String path : paths) {
                if (!path.equals(apiPath)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public APIGroupList getApiGroups() {
        return new OperationSupport(this.httpClient, this.configuration).restCall(APIGroupList.class, APIS);
    }

    @Override
    public APIGroup getApiGroup(String name) {
        return new OperationSupport(this.httpClient, this.configuration).restCall(APIGroup.class, APIS, name);
    }

    @Override
    public APIResourceList getApiResources(String groupVersion) {
        return new OperationSupport(this.httpClient, this.configuration).restCall(APIResourceList.class, APIS, groupVersion);
    }

    protected VersionInfo getVersionInfo(String path) {
        return new OperationSupport(this.httpClient, this.getConfiguration()).restCall(VersionInfo.class, path);
    }

    protected OkHttpClient adaptOkHttpClient(OkHttpClient okHttpClient) {
        return okHttpClient;
    }
}

