/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operatorhub.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.openshift.api.model.operatorhub.v1.OperatorConditionStatus;
import io.fabric8.openshift.api.model.operatorhub.v1.OperatorConditionStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class OperatorConditionStatusFluentImpl<A extends OperatorConditionStatusFluent<A>>
extends BaseFluent<A>
implements OperatorConditionStatusFluent<A> {
    private List<Condition> conditions = new ArrayList<Condition>();

    public OperatorConditionStatusFluentImpl() {
    }

    public OperatorConditionStatusFluentImpl(OperatorConditionStatus instance) {
        this.withConditions(instance.getConditions());
    }

    @Override
    public A addToConditions(Integer index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)this;
    }

    @Override
    public A setToConditions(Integer index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)this;
    }

    @Override
    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(Condition ... items) {
        for (Condition item : items) {
            if (this.conditions == null) continue;
            this.conditions.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<Condition> items) {
        for (Condition item : items) {
            if (this.conditions == null) continue;
            this.conditions.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Condition> getConditions() {
        return this.conditions;
    }

    @Override
    public Condition getCondition(Integer index) {
        return this.conditions.get(index);
    }

    @Override
    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    @Override
    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    @Override
    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperatorConditionStatusFluentImpl that = (OperatorConditionStatusFluentImpl)o;
        return !(this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null);
    }

    public int hashCode() {
        return Objects.hash(this.conditions, super.hashCode());
    }
}

