/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operatorhub.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.operatorhub.v1.Operator;
import io.fabric8.openshift.api.model.operatorhub.v1.OperatorFluent;
import io.fabric8.openshift.api.model.operatorhub.v1.OperatorSpec;
import io.fabric8.openshift.api.model.operatorhub.v1.OperatorSpecBuilder;
import io.fabric8.openshift.api.model.operatorhub.v1.OperatorSpecFluentImpl;
import io.fabric8.openshift.api.model.operatorhub.v1.OperatorStatus;
import io.fabric8.openshift.api.model.operatorhub.v1.OperatorStatusBuilder;
import io.fabric8.openshift.api.model.operatorhub.v1.OperatorStatusFluentImpl;
import java.util.Objects;

public class OperatorFluentImpl<A extends OperatorFluent<A>>
extends BaseFluent<A>
implements OperatorFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private OperatorSpecBuilder spec;
    private OperatorStatusBuilder status;

    public OperatorFluentImpl() {
    }

    public OperatorFluentImpl(Operator instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public OperatorFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public OperatorFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public OperatorFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public OperatorFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public OperatorFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public OperatorSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public OperatorSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(OperatorSpec spec) {
        this._visitables.get("spec").remove(this.spec);
        if (spec != null) {
            this.spec = new OperatorSpecBuilder(spec);
            this._visitables.get("spec").add(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public OperatorFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public OperatorFluent.SpecNested<A> withNewSpecLike(OperatorSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public OperatorFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public OperatorFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new OperatorSpecBuilder().build());
    }

    @Override
    public OperatorFluent.SpecNested<A> editOrNewSpecLike(OperatorSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public OperatorStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public OperatorStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(OperatorStatus status) {
        this._visitables.get("status").remove(this.status);
        if (status != null) {
            this.status = new OperatorStatusBuilder(status);
            this._visitables.get("status").add(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public OperatorFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public OperatorFluent.StatusNested<A> withNewStatusLike(OperatorStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public OperatorFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public OperatorFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new OperatorStatusBuilder().build());
    }

    @Override
    public OperatorFluent.StatusNested<A> editOrNewStatusLike(OperatorStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperatorFluentImpl that = (OperatorFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.status, super.hashCode());
    }

    public class StatusNestedImpl<N>
    extends OperatorStatusFluentImpl<OperatorFluent.StatusNested<N>>
    implements OperatorFluent.StatusNested<N>,
    Nested<N> {
        OperatorStatusBuilder builder;

        StatusNestedImpl(OperatorStatus item) {
            this.builder = new OperatorStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new OperatorStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)OperatorFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends OperatorSpecFluentImpl<OperatorFluent.SpecNested<N>>
    implements OperatorFluent.SpecNested<N>,
    Nested<N> {
        OperatorSpecBuilder builder;

        SpecNestedImpl(OperatorSpec item) {
            this.builder = new OperatorSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new OperatorSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)OperatorFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<OperatorFluent.MetadataNested<N>>
    implements OperatorFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)OperatorFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

