/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.ClusterNetwork;
import io.fabric8.openshift.api.model.ClusterNetworkFluent;
import io.fabric8.openshift.api.model.ClusterNetworkFluentImpl;
import java.util.Objects;

public class ClusterNetworkBuilder
extends ClusterNetworkFluentImpl<ClusterNetworkBuilder>
implements VisitableBuilder<ClusterNetwork, ClusterNetworkBuilder> {
    ClusterNetworkFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterNetworkBuilder() {
        this(false);
    }

    public ClusterNetworkBuilder(Boolean validationEnabled) {
        this(new ClusterNetwork(), validationEnabled);
    }

    public ClusterNetworkBuilder(ClusterNetworkFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ClusterNetworkBuilder(ClusterNetworkFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ClusterNetwork(), validationEnabled);
    }

    public ClusterNetworkBuilder(ClusterNetworkFluent<?> fluent, ClusterNetwork instance) {
        this(fluent, instance, false);
    }

    public ClusterNetworkBuilder(ClusterNetworkFluent<?> fluent, ClusterNetwork instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withClusterNetworks(instance.getClusterNetworks());
        fluent.withHostsubnetlength(instance.getHostsubnetlength());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withMtu(instance.getMtu());
        fluent.withNetwork(instance.getNetwork());
        fluent.withPluginName(instance.getPluginName());
        fluent.withServiceNetwork(instance.getServiceNetwork());
        fluent.withVxlanPort(instance.getVxlanPort());
        this.validationEnabled = validationEnabled;
    }

    public ClusterNetworkBuilder(ClusterNetwork instance) {
        this(instance, (Boolean)false);
    }

    public ClusterNetworkBuilder(ClusterNetwork instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withClusterNetworks(instance.getClusterNetworks());
        this.withHostsubnetlength(instance.getHostsubnetlength());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withMtu(instance.getMtu());
        this.withNetwork(instance.getNetwork());
        this.withPluginName(instance.getPluginName());
        this.withServiceNetwork(instance.getServiceNetwork());
        this.withVxlanPort(instance.getVxlanPort());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ClusterNetwork build() {
        ClusterNetwork buildable = new ClusterNetwork(this.fluent.getApiVersion(), this.fluent.getClusterNetworks(), this.fluent.getHostsubnetlength(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getMtu(), this.fluent.getNetwork(), this.fluent.getPluginName(), this.fluent.getServiceNetwork(), this.fluent.getVxlanPort());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterNetworkBuilder that = (ClusterNetworkBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

