/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.monitoring.v1.NamespaceSelector;
import io.fabric8.openshift.api.model.monitoring.v1.NamespaceSelectorFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class NamespaceSelectorFluentImpl<A extends NamespaceSelectorFluent<A>>
extends BaseFluent<A>
implements NamespaceSelectorFluent<A> {
    private Boolean any;
    private List<String> matchNames = new ArrayList<String>();

    public NamespaceSelectorFluentImpl() {
    }

    public NamespaceSelectorFluentImpl(NamespaceSelector instance) {
        this.withAny(instance.getAny());
        this.withMatchNames(instance.getMatchNames());
    }

    @Override
    public Boolean getAny() {
        return this.any;
    }

    @Override
    public A withAny(Boolean any) {
        this.any = any;
        return (A)this;
    }

    @Override
    public Boolean hasAny() {
        return this.any != null;
    }

    @Override
    public A addToMatchNames(int index, String item) {
        if (this.matchNames == null) {
            this.matchNames = new ArrayList<String>();
        }
        this.matchNames.add(index, item);
        return (A)this;
    }

    @Override
    public A setToMatchNames(int index, String item) {
        if (this.matchNames == null) {
            this.matchNames = new ArrayList<String>();
        }
        this.matchNames.set(index, item);
        return (A)this;
    }

    @Override
    public A addToMatchNames(String ... items) {
        if (this.matchNames == null) {
            this.matchNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.matchNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToMatchNames(Collection<String> items) {
        if (this.matchNames == null) {
            this.matchNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.matchNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromMatchNames(String ... items) {
        for (String item : items) {
            if (this.matchNames == null) continue;
            this.matchNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMatchNames(Collection<String> items) {
        for (String item : items) {
            if (this.matchNames == null) continue;
            this.matchNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getMatchNames() {
        return this.matchNames;
    }

    @Override
    public String getMatchName(int index) {
        return this.matchNames.get(index);
    }

    @Override
    public String getFirstMatchName() {
        return this.matchNames.get(0);
    }

    @Override
    public String getLastMatchName() {
        return this.matchNames.get(this.matchNames.size() - 1);
    }

    @Override
    public String getMatchingMatchName(Predicate<String> predicate) {
        for (String item : this.matchNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingMatchName(Predicate<String> predicate) {
        for (String item : this.matchNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withMatchNames(List<String> matchNames) {
        if (this.matchNames != null) {
            this._visitables.get("matchNames").removeAll(this.matchNames);
        }
        if (matchNames != null) {
            this.matchNames = new ArrayList<String>();
            for (String item : matchNames) {
                this.addToMatchNames(item);
            }
        } else {
            this.matchNames = null;
        }
        return (A)this;
    }

    @Override
    public A withMatchNames(String ... matchNames) {
        if (this.matchNames != null) {
            this.matchNames.clear();
        }
        if (matchNames != null) {
            for (String item : matchNames) {
                this.addToMatchNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasMatchNames() {
        return this.matchNames != null && !this.matchNames.isEmpty();
    }

    @Override
    public A addNewMatchName(String arg0) {
        return this.addToMatchNames(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamespaceSelectorFluentImpl that = (NamespaceSelectorFluentImpl)o;
        if (this.any != null ? !this.any.equals(that.any) : that.any != null) {
            return false;
        }
        return !(this.matchNames != null ? !this.matchNames.equals(that.matchNames) : that.matchNames != null);
    }

    public int hashCode() {
        return Objects.hash(this.any, this.matchNames, super.hashCode());
    }
}

