/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.HasMetadataVisitiableBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.utils.KubernetesResourceUtil;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateOrReplaceHelper<T extends HasMetadata> {
    private static final Logger LOG = LoggerFactory.getLogger(CreateOrReplaceHelper.class);
    public static final int CREATE_OR_REPLACE_RETRIES = 3;
    private final UnaryOperator<T> createTask;
    private final UnaryOperator<T> replaceTask;
    private final UnaryOperator<T> waitTask;
    private final UnaryOperator<T> reloadTask;

    public CreateOrReplaceHelper(UnaryOperator<T> createTask, UnaryOperator<T> replaceTask, UnaryOperator<T> waitTask, UnaryOperator<T> reloadTask) {
        this.createTask = createTask;
        this.replaceTask = replaceTask;
        this.waitTask = waitTask;
        this.reloadTask = reloadTask;
    }

    public T createOrReplace(T item) {
        String resourceVersion = KubernetesResourceUtil.getResourceVersion(item);
        CompletableFuture<T> future = new CompletableFuture<T>();
        int nTries = 0;
        while (!future.isDone() && nTries < 3) {
            try {
                KubernetesResourceUtil.setResourceVersion(item, null);
                return (T)((HasMetadata)this.createTask.apply(item));
            }
            catch (KubernetesClientException exception) {
                if (this.shouldRetry(exception.getCode())) {
                    HasMetadata itemFromServer = (HasMetadata)this.reloadTask.apply(item);
                    if (itemFromServer == null) {
                        this.waitTask.apply(item);
                        ++nTries;
                        continue;
                    }
                } else if (exception.getCode() != 409) {
                    throw exception;
                }
                future.complete(this.replace(item, resourceVersion));
            }
        }
        return (T)((HasMetadata)future.join());
    }

    public static HasMetadata createOrReplaceItem(OkHttpClient client, Config config, HasMetadata meta, ResourceHandler<HasMetadata, HasMetadataVisitiableBuilder> h, String namespaceToUse, boolean dryRun) {
        CreateOrReplaceHelper<HasMetadata> createOrReplaceHelper = new CreateOrReplaceHelper<HasMetadata>(m -> h.create(client, config, namespaceToUse, (HasMetadata)m, dryRun), m -> h.replace(client, config, namespaceToUse, (HasMetadata)m, dryRun), m -> {
            try {
                return h.waitUntilCondition(client, config, namespaceToUse, (HasMetadata)m, Objects::nonNull, 1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                LOG.warn("Interrupted waiting for item to be created or replaced. Gracefully assuming the resource hasn't been created and doesn't exist. ({})", (Object)interruptedException.getMessage());
                return null;
            }
        }, m -> h.reload(client, config, namespaceToUse, (HasMetadata)m));
        return createOrReplaceHelper.createOrReplace(meta);
    }

    private T replace(T item, String resourceVersion) {
        KubernetesResourceUtil.setResourceVersion(item, resourceVersion);
        return (T)((HasMetadata)this.replaceTask.apply(item));
    }

    private boolean shouldRetry(int responseCode) {
        return responseCode > 499;
    }
}

