/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.Taint;
import io.fabric8.openshift.api.model.hive.v1.MachinePoolAutoscaling;
import io.fabric8.openshift.api.model.hive.v1.MachinePoolAutoscalingBuilder;
import io.fabric8.openshift.api.model.hive.v1.MachinePoolAutoscalingFluentImpl;
import io.fabric8.openshift.api.model.hive.v1.MachinePoolPlatform;
import io.fabric8.openshift.api.model.hive.v1.MachinePoolPlatformBuilder;
import io.fabric8.openshift.api.model.hive.v1.MachinePoolPlatformFluentImpl;
import io.fabric8.openshift.api.model.hive.v1.MachinePoolSpec;
import io.fabric8.openshift.api.model.hive.v1.MachinePoolSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class MachinePoolSpecFluentImpl<A extends MachinePoolSpecFluent<A>>
extends BaseFluent<A>
implements MachinePoolSpecFluent<A> {
    private MachinePoolAutoscalingBuilder autoscaling;
    private LocalObjectReferenceBuilder clusterDeploymentRef;
    private Map<String, String> labels;
    private String name;
    private MachinePoolPlatformBuilder platform;
    private Long replicas;
    private List<Taint> taints = new ArrayList<Taint>();
    private Map<String, Object> additionalProperties;

    public MachinePoolSpecFluentImpl() {
    }

    public MachinePoolSpecFluentImpl(MachinePoolSpec instance) {
        this.withAutoscaling(instance.getAutoscaling());
        this.withClusterDeploymentRef(instance.getClusterDeploymentRef());
        this.withLabels(instance.getLabels());
        this.withName(instance.getName());
        this.withPlatform(instance.getPlatform());
        this.withReplicas(instance.getReplicas());
        this.withTaints(instance.getTaints());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    @Deprecated
    public MachinePoolAutoscaling getAutoscaling() {
        return this.autoscaling != null ? this.autoscaling.build() : null;
    }

    @Override
    public MachinePoolAutoscaling buildAutoscaling() {
        return this.autoscaling != null ? this.autoscaling.build() : null;
    }

    @Override
    public A withAutoscaling(MachinePoolAutoscaling autoscaling) {
        this._visitables.get("autoscaling").remove(this.autoscaling);
        if (autoscaling != null) {
            this.autoscaling = new MachinePoolAutoscalingBuilder(autoscaling);
            this._visitables.get("autoscaling").add(this.autoscaling);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAutoscaling() {
        return this.autoscaling != null;
    }

    @Override
    public A withNewAutoscaling(Integer maxReplicas, Integer minReplicas) {
        return this.withAutoscaling(new MachinePoolAutoscaling(maxReplicas, minReplicas));
    }

    @Override
    public MachinePoolSpecFluent.AutoscalingNested<A> withNewAutoscaling() {
        return new AutoscalingNestedImpl();
    }

    @Override
    public MachinePoolSpecFluent.AutoscalingNested<A> withNewAutoscalingLike(MachinePoolAutoscaling item) {
        return new AutoscalingNestedImpl(item);
    }

    @Override
    public MachinePoolSpecFluent.AutoscalingNested<A> editAutoscaling() {
        return this.withNewAutoscalingLike(this.getAutoscaling());
    }

    @Override
    public MachinePoolSpecFluent.AutoscalingNested<A> editOrNewAutoscaling() {
        return this.withNewAutoscalingLike(this.getAutoscaling() != null ? this.getAutoscaling() : new MachinePoolAutoscalingBuilder().build());
    }

    @Override
    public MachinePoolSpecFluent.AutoscalingNested<A> editOrNewAutoscalingLike(MachinePoolAutoscaling item) {
        return this.withNewAutoscalingLike(this.getAutoscaling() != null ? this.getAutoscaling() : item);
    }

    @Override
    @Deprecated
    public LocalObjectReference getClusterDeploymentRef() {
        return this.clusterDeploymentRef != null ? this.clusterDeploymentRef.build() : null;
    }

    @Override
    public LocalObjectReference buildClusterDeploymentRef() {
        return this.clusterDeploymentRef != null ? this.clusterDeploymentRef.build() : null;
    }

    @Override
    public A withClusterDeploymentRef(LocalObjectReference clusterDeploymentRef) {
        this._visitables.get("clusterDeploymentRef").remove(this.clusterDeploymentRef);
        if (clusterDeploymentRef != null) {
            this.clusterDeploymentRef = new LocalObjectReferenceBuilder(clusterDeploymentRef);
            this._visitables.get("clusterDeploymentRef").add(this.clusterDeploymentRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasClusterDeploymentRef() {
        return this.clusterDeploymentRef != null;
    }

    @Override
    public A withNewClusterDeploymentRef(String name) {
        return this.withClusterDeploymentRef(new LocalObjectReference(name));
    }

    @Override
    public MachinePoolSpecFluent.ClusterDeploymentRefNested<A> withNewClusterDeploymentRef() {
        return new ClusterDeploymentRefNestedImpl();
    }

    @Override
    public MachinePoolSpecFluent.ClusterDeploymentRefNested<A> withNewClusterDeploymentRefLike(LocalObjectReference item) {
        return new ClusterDeploymentRefNestedImpl(item);
    }

    @Override
    public MachinePoolSpecFluent.ClusterDeploymentRefNested<A> editClusterDeploymentRef() {
        return this.withNewClusterDeploymentRefLike(this.getClusterDeploymentRef());
    }

    @Override
    public MachinePoolSpecFluent.ClusterDeploymentRefNested<A> editOrNewClusterDeploymentRef() {
        return this.withNewClusterDeploymentRefLike(this.getClusterDeploymentRef() != null ? this.getClusterDeploymentRef() : new LocalObjectReferenceBuilder().build());
    }

    @Override
    public MachinePoolSpecFluent.ClusterDeploymentRefNested<A> editOrNewClusterDeploymentRefLike(LocalObjectReference item) {
        return this.withNewClusterDeploymentRefLike(this.getClusterDeploymentRef() != null ? this.getClusterDeploymentRef() : item);
    }

    @Override
    public A addToLabels(String key, String value) {
        if (this.labels == null && key != null && value != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.labels.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToLabels(Map<String, String> map) {
        if (this.labels == null && map != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.labels.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromLabels(String key) {
        if (this.labels == null) {
            return (A)this;
        }
        if (key != null && this.labels != null) {
            this.labels.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromLabels(Map<String, String> map) {
        if (this.labels == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.labels == null) continue;
                this.labels.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Override
    public <K, V> A withLabels(Map<String, String> labels) {
        this.labels = labels == null ? null : new LinkedHashMap<String, String>(labels);
        return (A)this;
    }

    @Override
    public Boolean hasLabels() {
        return this.labels != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public A withNewName(String arg0) {
        return this.withName(new String(arg0));
    }

    @Override
    @Deprecated
    public MachinePoolPlatform getPlatform() {
        return this.platform != null ? this.platform.build() : null;
    }

    @Override
    public MachinePoolPlatform buildPlatform() {
        return this.platform != null ? this.platform.build() : null;
    }

    @Override
    public A withPlatform(MachinePoolPlatform platform) {
        this._visitables.get("platform").remove(this.platform);
        if (platform != null) {
            this.platform = new MachinePoolPlatformBuilder(platform);
            this._visitables.get("platform").add(this.platform);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPlatform() {
        return this.platform != null;
    }

    @Override
    public MachinePoolSpecFluent.PlatformNested<A> withNewPlatform() {
        return new PlatformNestedImpl();
    }

    @Override
    public MachinePoolSpecFluent.PlatformNested<A> withNewPlatformLike(MachinePoolPlatform item) {
        return new PlatformNestedImpl(item);
    }

    @Override
    public MachinePoolSpecFluent.PlatformNested<A> editPlatform() {
        return this.withNewPlatformLike(this.getPlatform());
    }

    @Override
    public MachinePoolSpecFluent.PlatformNested<A> editOrNewPlatform() {
        return this.withNewPlatformLike(this.getPlatform() != null ? this.getPlatform() : new MachinePoolPlatformBuilder().build());
    }

    @Override
    public MachinePoolSpecFluent.PlatformNested<A> editOrNewPlatformLike(MachinePoolPlatform item) {
        return this.withNewPlatformLike(this.getPlatform() != null ? this.getPlatform() : item);
    }

    @Override
    public Long getReplicas() {
        return this.replicas;
    }

    @Override
    public A withReplicas(Long replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    @Override
    public Boolean hasReplicas() {
        return this.replicas != null;
    }

    @Override
    public A addToTaints(Integer index, Taint item) {
        if (this.taints == null) {
            this.taints = new ArrayList<Taint>();
        }
        this.taints.add(index, item);
        return (A)this;
    }

    @Override
    public A setToTaints(Integer index, Taint item) {
        if (this.taints == null) {
            this.taints = new ArrayList<Taint>();
        }
        this.taints.set(index, item);
        return (A)this;
    }

    @Override
    public A addToTaints(Taint ... items) {
        if (this.taints == null) {
            this.taints = new ArrayList<Taint>();
        }
        for (Taint item : items) {
            this.taints.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToTaints(Collection<Taint> items) {
        if (this.taints == null) {
            this.taints = new ArrayList<Taint>();
        }
        for (Taint item : items) {
            this.taints.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTaints(Taint ... items) {
        for (Taint item : items) {
            if (this.taints == null) continue;
            this.taints.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTaints(Collection<Taint> items) {
        for (Taint item : items) {
            if (this.taints == null) continue;
            this.taints.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Taint> getTaints() {
        return this.taints;
    }

    @Override
    public Taint getTaint(Integer index) {
        return this.taints.get(index);
    }

    @Override
    public Taint getFirstTaint() {
        return this.taints.get(0);
    }

    @Override
    public Taint getLastTaint() {
        return this.taints.get(this.taints.size() - 1);
    }

    @Override
    public Taint getMatchingTaint(Predicate<Taint> predicate) {
        for (Taint item : this.taints) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTaint(Predicate<Taint> predicate) {
        for (Taint item : this.taints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTaints(List<Taint> taints) {
        if (taints != null) {
            this.taints = new ArrayList<Taint>();
            for (Taint item : taints) {
                this.addToTaints(item);
            }
        } else {
            this.taints = null;
        }
        return (A)this;
    }

    @Override
    public A withTaints(Taint ... taints) {
        if (this.taints != null) {
            this.taints.clear();
        }
        if (taints != null) {
            for (Taint item : taints) {
                this.addToTaints(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTaints() {
        return this.taints != null && !this.taints.isEmpty();
    }

    @Override
    public A addNewTaint(String effect, String key, String timeAdded, String value) {
        return this.addToTaints(new Taint(effect, key, timeAdded, value));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MachinePoolSpecFluentImpl that = (MachinePoolSpecFluentImpl)o;
        if (this.autoscaling != null ? !this.autoscaling.equals(that.autoscaling) : that.autoscaling != null) {
            return false;
        }
        if (this.clusterDeploymentRef != null ? !this.clusterDeploymentRef.equals(that.clusterDeploymentRef) : that.clusterDeploymentRef != null) {
            return false;
        }
        if (this.labels != null ? !this.labels.equals(that.labels) : that.labels != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.platform != null ? !this.platform.equals(that.platform) : that.platform != null) {
            return false;
        }
        if (this.replicas != null ? !this.replicas.equals(that.replicas) : that.replicas != null) {
            return false;
        }
        if (this.taints != null ? !this.taints.equals(that.taints) : that.taints != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.autoscaling, this.clusterDeploymentRef, this.labels, this.name, this.platform, this.replicas, this.taints, this.additionalProperties, super.hashCode());
    }

    public class PlatformNestedImpl<N>
    extends MachinePoolPlatformFluentImpl<MachinePoolSpecFluent.PlatformNested<N>>
    implements MachinePoolSpecFluent.PlatformNested<N>,
    Nested<N> {
        MachinePoolPlatformBuilder builder;

        PlatformNestedImpl(MachinePoolPlatform item) {
            this.builder = new MachinePoolPlatformBuilder(this, item);
        }

        PlatformNestedImpl() {
            this.builder = new MachinePoolPlatformBuilder(this);
        }

        @Override
        public N and() {
            return (N)MachinePoolSpecFluentImpl.this.withPlatform(this.builder.build());
        }

        @Override
        public N endPlatform() {
            return this.and();
        }
    }

    public class ClusterDeploymentRefNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<MachinePoolSpecFluent.ClusterDeploymentRefNested<N>>
    implements MachinePoolSpecFluent.ClusterDeploymentRefNested<N>,
    Nested<N> {
        LocalObjectReferenceBuilder builder;

        ClusterDeploymentRefNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        ClusterDeploymentRefNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)MachinePoolSpecFluentImpl.this.withClusterDeploymentRef(this.builder.build());
        }

        @Override
        public N endClusterDeploymentRef() {
            return this.and();
        }
    }

    public class AutoscalingNestedImpl<N>
    extends MachinePoolAutoscalingFluentImpl<MachinePoolSpecFluent.AutoscalingNested<N>>
    implements MachinePoolSpecFluent.AutoscalingNested<N>,
    Nested<N> {
        MachinePoolAutoscalingBuilder builder;

        AutoscalingNestedImpl(MachinePoolAutoscaling item) {
            this.builder = new MachinePoolAutoscalingBuilder(this, item);
        }

        AutoscalingNestedImpl() {
            this.builder = new MachinePoolAutoscalingBuilder(this);
        }

        @Override
        public N and() {
            return (N)MachinePoolSpecFluentImpl.this.withAutoscaling(this.builder.build());
        }

        @Override
        public N endAutoscaling() {
            return this.and();
        }
    }
}

