/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.AllowedFlexVolume;
import io.fabric8.openshift.api.model.AllowedFlexVolumeBuilder;
import io.fabric8.openshift.api.model.AllowedFlexVolumeFluentImpl;
import io.fabric8.openshift.api.model.FSGroupStrategyOptions;
import io.fabric8.openshift.api.model.FSGroupStrategyOptionsBuilder;
import io.fabric8.openshift.api.model.FSGroupStrategyOptionsFluentImpl;
import io.fabric8.openshift.api.model.RunAsUserStrategyOptions;
import io.fabric8.openshift.api.model.RunAsUserStrategyOptionsBuilder;
import io.fabric8.openshift.api.model.RunAsUserStrategyOptionsFluentImpl;
import io.fabric8.openshift.api.model.SELinuxContextStrategyOptions;
import io.fabric8.openshift.api.model.SELinuxContextStrategyOptionsBuilder;
import io.fabric8.openshift.api.model.SELinuxContextStrategyOptionsFluentImpl;
import io.fabric8.openshift.api.model.SecurityContextConstraints;
import io.fabric8.openshift.api.model.SecurityContextConstraintsFluent;
import io.fabric8.openshift.api.model.SupplementalGroupsStrategyOptions;
import io.fabric8.openshift.api.model.SupplementalGroupsStrategyOptionsBuilder;
import io.fabric8.openshift.api.model.SupplementalGroupsStrategyOptionsFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class SecurityContextConstraintsFluentImpl<A extends SecurityContextConstraintsFluent<A>>
extends BaseFluent<A>
implements SecurityContextConstraintsFluent<A> {
    private Boolean allowHostDirVolumePlugin;
    private Boolean allowHostIPC;
    private Boolean allowHostNetwork;
    private Boolean allowHostPID;
    private Boolean allowHostPorts;
    private Boolean allowPrivilegeEscalation;
    private Boolean allowPrivilegedContainer;
    private List<String> allowedCapabilities = new ArrayList<String>();
    private List<AllowedFlexVolumeBuilder> allowedFlexVolumes = new ArrayList<AllowedFlexVolumeBuilder>();
    private List<String> allowedUnsafeSysctls = new ArrayList<String>();
    private String apiVersion;
    private List<String> defaultAddCapabilities = new ArrayList<String>();
    private Boolean defaultAllowPrivilegeEscalation;
    private List<String> forbiddenSysctls = new ArrayList<String>();
    private FSGroupStrategyOptionsBuilder fsGroup;
    private List<String> groups = new ArrayList<String>();
    private String kind;
    private ObjectMetaBuilder metadata;
    private Integer priority;
    private Boolean readOnlyRootFilesystem;
    private List<String> requiredDropCapabilities = new ArrayList<String>();
    private RunAsUserStrategyOptionsBuilder runAsUser;
    private SELinuxContextStrategyOptionsBuilder seLinuxContext;
    private List<String> seccompProfiles = new ArrayList<String>();
    private SupplementalGroupsStrategyOptionsBuilder supplementalGroups;
    private List<String> users = new ArrayList<String>();
    private List<String> volumes = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public SecurityContextConstraintsFluentImpl() {
    }

    public SecurityContextConstraintsFluentImpl(SecurityContextConstraints instance) {
        this.withAllowHostDirVolumePlugin(instance.getAllowHostDirVolumePlugin());
        this.withAllowHostIPC(instance.getAllowHostIPC());
        this.withAllowHostNetwork(instance.getAllowHostNetwork());
        this.withAllowHostPID(instance.getAllowHostPID());
        this.withAllowHostPorts(instance.getAllowHostPorts());
        this.withAllowPrivilegeEscalation(instance.getAllowPrivilegeEscalation());
        this.withAllowPrivilegedContainer(instance.getAllowPrivilegedContainer());
        this.withAllowedCapabilities(instance.getAllowedCapabilities());
        this.withAllowedFlexVolumes(instance.getAllowedFlexVolumes());
        this.withAllowedUnsafeSysctls(instance.getAllowedUnsafeSysctls());
        this.withApiVersion(instance.getApiVersion());
        this.withDefaultAddCapabilities(instance.getDefaultAddCapabilities());
        this.withDefaultAllowPrivilegeEscalation(instance.getDefaultAllowPrivilegeEscalation());
        this.withForbiddenSysctls(instance.getForbiddenSysctls());
        this.withFsGroup(instance.getFsGroup());
        this.withGroups(instance.getGroups());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withPriority(instance.getPriority());
        this.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem());
        this.withRequiredDropCapabilities(instance.getRequiredDropCapabilities());
        this.withRunAsUser(instance.getRunAsUser());
        this.withSeLinuxContext(instance.getSeLinuxContext());
        this.withSeccompProfiles(instance.getSeccompProfiles());
        this.withSupplementalGroups(instance.getSupplementalGroups());
        this.withUsers(instance.getUsers());
        this.withVolumes(instance.getVolumes());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public Boolean getAllowHostDirVolumePlugin() {
        return this.allowHostDirVolumePlugin;
    }

    @Override
    public A withAllowHostDirVolumePlugin(Boolean allowHostDirVolumePlugin) {
        this.allowHostDirVolumePlugin = allowHostDirVolumePlugin;
        return (A)this;
    }

    @Override
    public Boolean hasAllowHostDirVolumePlugin() {
        return this.allowHostDirVolumePlugin != null;
    }

    @Override
    public Boolean getAllowHostIPC() {
        return this.allowHostIPC;
    }

    @Override
    public A withAllowHostIPC(Boolean allowHostIPC) {
        this.allowHostIPC = allowHostIPC;
        return (A)this;
    }

    @Override
    public Boolean hasAllowHostIPC() {
        return this.allowHostIPC != null;
    }

    @Override
    public Boolean getAllowHostNetwork() {
        return this.allowHostNetwork;
    }

    @Override
    public A withAllowHostNetwork(Boolean allowHostNetwork) {
        this.allowHostNetwork = allowHostNetwork;
        return (A)this;
    }

    @Override
    public Boolean hasAllowHostNetwork() {
        return this.allowHostNetwork != null;
    }

    @Override
    public Boolean getAllowHostPID() {
        return this.allowHostPID;
    }

    @Override
    public A withAllowHostPID(Boolean allowHostPID) {
        this.allowHostPID = allowHostPID;
        return (A)this;
    }

    @Override
    public Boolean hasAllowHostPID() {
        return this.allowHostPID != null;
    }

    @Override
    public Boolean getAllowHostPorts() {
        return this.allowHostPorts;
    }

    @Override
    public A withAllowHostPorts(Boolean allowHostPorts) {
        this.allowHostPorts = allowHostPorts;
        return (A)this;
    }

    @Override
    public Boolean hasAllowHostPorts() {
        return this.allowHostPorts != null;
    }

    @Override
    public Boolean getAllowPrivilegeEscalation() {
        return this.allowPrivilegeEscalation;
    }

    @Override
    public A withAllowPrivilegeEscalation(Boolean allowPrivilegeEscalation) {
        this.allowPrivilegeEscalation = allowPrivilegeEscalation;
        return (A)this;
    }

    @Override
    public Boolean hasAllowPrivilegeEscalation() {
        return this.allowPrivilegeEscalation != null;
    }

    @Override
    public Boolean getAllowPrivilegedContainer() {
        return this.allowPrivilegedContainer;
    }

    @Override
    public A withAllowPrivilegedContainer(Boolean allowPrivilegedContainer) {
        this.allowPrivilegedContainer = allowPrivilegedContainer;
        return (A)this;
    }

    @Override
    public Boolean hasAllowPrivilegedContainer() {
        return this.allowPrivilegedContainer != null;
    }

    @Override
    public A addToAllowedCapabilities(Integer index, String item) {
        if (this.allowedCapabilities == null) {
            this.allowedCapabilities = new ArrayList<String>();
        }
        this.allowedCapabilities.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAllowedCapabilities(Integer index, String item) {
        if (this.allowedCapabilities == null) {
            this.allowedCapabilities = new ArrayList<String>();
        }
        this.allowedCapabilities.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAllowedCapabilities(String ... items) {
        if (this.allowedCapabilities == null) {
            this.allowedCapabilities = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedCapabilities.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAllowedCapabilities(Collection<String> items) {
        if (this.allowedCapabilities == null) {
            this.allowedCapabilities = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedCapabilities.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAllowedCapabilities(String ... items) {
        for (String item : items) {
            if (this.allowedCapabilities == null) continue;
            this.allowedCapabilities.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAllowedCapabilities(Collection<String> items) {
        for (String item : items) {
            if (this.allowedCapabilities == null) continue;
            this.allowedCapabilities.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAllowedCapabilities() {
        return this.allowedCapabilities;
    }

    @Override
    public String getAllowedCapability(Integer index) {
        return this.allowedCapabilities.get(index);
    }

    @Override
    public String getFirstAllowedCapability() {
        return this.allowedCapabilities.get(0);
    }

    @Override
    public String getLastAllowedCapability() {
        return this.allowedCapabilities.get(this.allowedCapabilities.size() - 1);
    }

    @Override
    public String getMatchingAllowedCapability(Predicate<String> predicate) {
        for (String item : this.allowedCapabilities) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAllowedCapability(Predicate<String> predicate) {
        for (String item : this.allowedCapabilities) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAllowedCapabilities(List<String> allowedCapabilities) {
        if (allowedCapabilities != null) {
            this.allowedCapabilities = new ArrayList<String>();
            for (String item : allowedCapabilities) {
                this.addToAllowedCapabilities(item);
            }
        } else {
            this.allowedCapabilities = null;
        }
        return (A)this;
    }

    @Override
    public A withAllowedCapabilities(String ... allowedCapabilities) {
        if (this.allowedCapabilities != null) {
            this.allowedCapabilities.clear();
        }
        if (allowedCapabilities != null) {
            for (String item : allowedCapabilities) {
                this.addToAllowedCapabilities(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAllowedCapabilities() {
        return this.allowedCapabilities != null && !this.allowedCapabilities.isEmpty();
    }

    @Override
    public A addNewAllowedCapability(String arg0) {
        return this.addToAllowedCapabilities(new String(arg0));
    }

    @Override
    public A addToAllowedFlexVolumes(Integer index, AllowedFlexVolume item) {
        if (this.allowedFlexVolumes == null) {
            this.allowedFlexVolumes = new ArrayList<AllowedFlexVolumeBuilder>();
        }
        AllowedFlexVolumeBuilder builder = new AllowedFlexVolumeBuilder(item);
        this._visitables.get("allowedFlexVolumes").add(index >= 0 ? index.intValue() : this._visitables.get("allowedFlexVolumes").size(), builder);
        this.allowedFlexVolumes.add(index >= 0 ? index.intValue() : this.allowedFlexVolumes.size(), builder);
        return (A)this;
    }

    @Override
    public A setToAllowedFlexVolumes(Integer index, AllowedFlexVolume item) {
        if (this.allowedFlexVolumes == null) {
            this.allowedFlexVolumes = new ArrayList<AllowedFlexVolumeBuilder>();
        }
        AllowedFlexVolumeBuilder builder = new AllowedFlexVolumeBuilder(item);
        if (index < 0 || index >= this._visitables.get("allowedFlexVolumes").size()) {
            this._visitables.get("allowedFlexVolumes").add(builder);
        } else {
            this._visitables.get("allowedFlexVolumes").set(index, builder);
        }
        if (index < 0 || index >= this.allowedFlexVolumes.size()) {
            this.allowedFlexVolumes.add(builder);
        } else {
            this.allowedFlexVolumes.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToAllowedFlexVolumes(AllowedFlexVolume ... items) {
        if (this.allowedFlexVolumes == null) {
            this.allowedFlexVolumes = new ArrayList<AllowedFlexVolumeBuilder>();
        }
        for (AllowedFlexVolume item : items) {
            AllowedFlexVolumeBuilder builder = new AllowedFlexVolumeBuilder(item);
            this._visitables.get("allowedFlexVolumes").add(builder);
            this.allowedFlexVolumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToAllowedFlexVolumes(Collection<AllowedFlexVolume> items) {
        if (this.allowedFlexVolumes == null) {
            this.allowedFlexVolumes = new ArrayList<AllowedFlexVolumeBuilder>();
        }
        for (AllowedFlexVolume item : items) {
            AllowedFlexVolumeBuilder builder = new AllowedFlexVolumeBuilder(item);
            this._visitables.get("allowedFlexVolumes").add(builder);
            this.allowedFlexVolumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromAllowedFlexVolumes(AllowedFlexVolume ... items) {
        for (AllowedFlexVolume item : items) {
            AllowedFlexVolumeBuilder builder = new AllowedFlexVolumeBuilder(item);
            this._visitables.get("allowedFlexVolumes").remove(builder);
            if (this.allowedFlexVolumes == null) continue;
            this.allowedFlexVolumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAllowedFlexVolumes(Collection<AllowedFlexVolume> items) {
        for (AllowedFlexVolume item : items) {
            AllowedFlexVolumeBuilder builder = new AllowedFlexVolumeBuilder(item);
            this._visitables.get("allowedFlexVolumes").remove(builder);
            if (this.allowedFlexVolumes == null) continue;
            this.allowedFlexVolumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromAllowedFlexVolumes(Predicate<AllowedFlexVolumeBuilder> predicate) {
        if (this.allowedFlexVolumes == null) {
            return (A)this;
        }
        Iterator<AllowedFlexVolumeBuilder> each = this.allowedFlexVolumes.iterator();
        Object visitables = this._visitables.get("allowedFlexVolumes");
        while (each.hasNext()) {
            AllowedFlexVolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<AllowedFlexVolume> getAllowedFlexVolumes() {
        return SecurityContextConstraintsFluentImpl.build(this.allowedFlexVolumes);
    }

    @Override
    public List<AllowedFlexVolume> buildAllowedFlexVolumes() {
        return SecurityContextConstraintsFluentImpl.build(this.allowedFlexVolumes);
    }

    @Override
    public AllowedFlexVolume buildAllowedFlexVolume(Integer index) {
        return this.allowedFlexVolumes.get(index).build();
    }

    @Override
    public AllowedFlexVolume buildFirstAllowedFlexVolume() {
        return this.allowedFlexVolumes.get(0).build();
    }

    @Override
    public AllowedFlexVolume buildLastAllowedFlexVolume() {
        return this.allowedFlexVolumes.get(this.allowedFlexVolumes.size() - 1).build();
    }

    @Override
    public AllowedFlexVolume buildMatchingAllowedFlexVolume(Predicate<AllowedFlexVolumeBuilder> predicate) {
        for (AllowedFlexVolumeBuilder item : this.allowedFlexVolumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAllowedFlexVolume(Predicate<AllowedFlexVolumeBuilder> predicate) {
        for (AllowedFlexVolumeBuilder item : this.allowedFlexVolumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAllowedFlexVolumes(List<AllowedFlexVolume> allowedFlexVolumes) {
        if (this.allowedFlexVolumes != null) {
            this._visitables.get("allowedFlexVolumes").removeAll(this.allowedFlexVolumes);
        }
        if (allowedFlexVolumes != null) {
            this.allowedFlexVolumes = new ArrayList<AllowedFlexVolumeBuilder>();
            for (AllowedFlexVolume item : allowedFlexVolumes) {
                this.addToAllowedFlexVolumes(item);
            }
        } else {
            this.allowedFlexVolumes = null;
        }
        return (A)this;
    }

    @Override
    public A withAllowedFlexVolumes(AllowedFlexVolume ... allowedFlexVolumes) {
        if (this.allowedFlexVolumes != null) {
            this.allowedFlexVolumes.clear();
        }
        if (allowedFlexVolumes != null) {
            for (AllowedFlexVolume item : allowedFlexVolumes) {
                this.addToAllowedFlexVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAllowedFlexVolumes() {
        return this.allowedFlexVolumes != null && !this.allowedFlexVolumes.isEmpty();
    }

    @Override
    public A addNewAllowedFlexVolume(String driver) {
        return this.addToAllowedFlexVolumes(new AllowedFlexVolume(driver));
    }

    @Override
    public SecurityContextConstraintsFluent.AllowedFlexVolumesNested<A> addNewAllowedFlexVolume() {
        return new AllowedFlexVolumesNestedImpl();
    }

    @Override
    public SecurityContextConstraintsFluent.AllowedFlexVolumesNested<A> addNewAllowedFlexVolumeLike(AllowedFlexVolume item) {
        return new AllowedFlexVolumesNestedImpl(-1, item);
    }

    @Override
    public SecurityContextConstraintsFluent.AllowedFlexVolumesNested<A> setNewAllowedFlexVolumeLike(Integer index, AllowedFlexVolume item) {
        return new AllowedFlexVolumesNestedImpl(index, item);
    }

    @Override
    public SecurityContextConstraintsFluent.AllowedFlexVolumesNested<A> editAllowedFlexVolume(Integer index) {
        if (this.allowedFlexVolumes.size() <= index) {
            throw new RuntimeException("Can't edit allowedFlexVolumes. Index exceeds size.");
        }
        return this.setNewAllowedFlexVolumeLike(index, this.buildAllowedFlexVolume(index));
    }

    @Override
    public SecurityContextConstraintsFluent.AllowedFlexVolumesNested<A> editFirstAllowedFlexVolume() {
        if (this.allowedFlexVolumes.size() == 0) {
            throw new RuntimeException("Can't edit first allowedFlexVolumes. The list is empty.");
        }
        return this.setNewAllowedFlexVolumeLike(0, this.buildAllowedFlexVolume(0));
    }

    @Override
    public SecurityContextConstraintsFluent.AllowedFlexVolumesNested<A> editLastAllowedFlexVolume() {
        int index = this.allowedFlexVolumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last allowedFlexVolumes. The list is empty.");
        }
        return this.setNewAllowedFlexVolumeLike(index, this.buildAllowedFlexVolume(index));
    }

    @Override
    public SecurityContextConstraintsFluent.AllowedFlexVolumesNested<A> editMatchingAllowedFlexVolume(Predicate<AllowedFlexVolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.allowedFlexVolumes.size(); ++i) {
            if (!predicate.test(this.allowedFlexVolumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching allowedFlexVolumes. No match found.");
        }
        return this.setNewAllowedFlexVolumeLike(index, this.buildAllowedFlexVolume(index));
    }

    @Override
    public A addToAllowedUnsafeSysctls(Integer index, String item) {
        if (this.allowedUnsafeSysctls == null) {
            this.allowedUnsafeSysctls = new ArrayList<String>();
        }
        this.allowedUnsafeSysctls.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAllowedUnsafeSysctls(Integer index, String item) {
        if (this.allowedUnsafeSysctls == null) {
            this.allowedUnsafeSysctls = new ArrayList<String>();
        }
        this.allowedUnsafeSysctls.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAllowedUnsafeSysctls(String ... items) {
        if (this.allowedUnsafeSysctls == null) {
            this.allowedUnsafeSysctls = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedUnsafeSysctls.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAllowedUnsafeSysctls(Collection<String> items) {
        if (this.allowedUnsafeSysctls == null) {
            this.allowedUnsafeSysctls = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedUnsafeSysctls.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAllowedUnsafeSysctls(String ... items) {
        for (String item : items) {
            if (this.allowedUnsafeSysctls == null) continue;
            this.allowedUnsafeSysctls.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAllowedUnsafeSysctls(Collection<String> items) {
        for (String item : items) {
            if (this.allowedUnsafeSysctls == null) continue;
            this.allowedUnsafeSysctls.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAllowedUnsafeSysctls() {
        return this.allowedUnsafeSysctls;
    }

    @Override
    public String getAllowedUnsafeSysctl(Integer index) {
        return this.allowedUnsafeSysctls.get(index);
    }

    @Override
    public String getFirstAllowedUnsafeSysctl() {
        return this.allowedUnsafeSysctls.get(0);
    }

    @Override
    public String getLastAllowedUnsafeSysctl() {
        return this.allowedUnsafeSysctls.get(this.allowedUnsafeSysctls.size() - 1);
    }

    @Override
    public String getMatchingAllowedUnsafeSysctl(Predicate<String> predicate) {
        for (String item : this.allowedUnsafeSysctls) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAllowedUnsafeSysctl(Predicate<String> predicate) {
        for (String item : this.allowedUnsafeSysctls) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAllowedUnsafeSysctls(List<String> allowedUnsafeSysctls) {
        if (allowedUnsafeSysctls != null) {
            this.allowedUnsafeSysctls = new ArrayList<String>();
            for (String item : allowedUnsafeSysctls) {
                this.addToAllowedUnsafeSysctls(item);
            }
        } else {
            this.allowedUnsafeSysctls = null;
        }
        return (A)this;
    }

    @Override
    public A withAllowedUnsafeSysctls(String ... allowedUnsafeSysctls) {
        if (this.allowedUnsafeSysctls != null) {
            this.allowedUnsafeSysctls.clear();
        }
        if (allowedUnsafeSysctls != null) {
            for (String item : allowedUnsafeSysctls) {
                this.addToAllowedUnsafeSysctls(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAllowedUnsafeSysctls() {
        return this.allowedUnsafeSysctls != null && !this.allowedUnsafeSysctls.isEmpty();
    }

    @Override
    public A addNewAllowedUnsafeSysctl(String arg0) {
        return this.addToAllowedUnsafeSysctls(new String(arg0));
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    public A addToDefaultAddCapabilities(Integer index, String item) {
        if (this.defaultAddCapabilities == null) {
            this.defaultAddCapabilities = new ArrayList<String>();
        }
        this.defaultAddCapabilities.add(index, item);
        return (A)this;
    }

    @Override
    public A setToDefaultAddCapabilities(Integer index, String item) {
        if (this.defaultAddCapabilities == null) {
            this.defaultAddCapabilities = new ArrayList<String>();
        }
        this.defaultAddCapabilities.set(index, item);
        return (A)this;
    }

    @Override
    public A addToDefaultAddCapabilities(String ... items) {
        if (this.defaultAddCapabilities == null) {
            this.defaultAddCapabilities = new ArrayList<String>();
        }
        for (String item : items) {
            this.defaultAddCapabilities.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToDefaultAddCapabilities(Collection<String> items) {
        if (this.defaultAddCapabilities == null) {
            this.defaultAddCapabilities = new ArrayList<String>();
        }
        for (String item : items) {
            this.defaultAddCapabilities.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromDefaultAddCapabilities(String ... items) {
        for (String item : items) {
            if (this.defaultAddCapabilities == null) continue;
            this.defaultAddCapabilities.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDefaultAddCapabilities(Collection<String> items) {
        for (String item : items) {
            if (this.defaultAddCapabilities == null) continue;
            this.defaultAddCapabilities.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getDefaultAddCapabilities() {
        return this.defaultAddCapabilities;
    }

    @Override
    public String getDefaultAddCapability(Integer index) {
        return this.defaultAddCapabilities.get(index);
    }

    @Override
    public String getFirstDefaultAddCapability() {
        return this.defaultAddCapabilities.get(0);
    }

    @Override
    public String getLastDefaultAddCapability() {
        return this.defaultAddCapabilities.get(this.defaultAddCapabilities.size() - 1);
    }

    @Override
    public String getMatchingDefaultAddCapability(Predicate<String> predicate) {
        for (String item : this.defaultAddCapabilities) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingDefaultAddCapability(Predicate<String> predicate) {
        for (String item : this.defaultAddCapabilities) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withDefaultAddCapabilities(List<String> defaultAddCapabilities) {
        if (defaultAddCapabilities != null) {
            this.defaultAddCapabilities = new ArrayList<String>();
            for (String item : defaultAddCapabilities) {
                this.addToDefaultAddCapabilities(item);
            }
        } else {
            this.defaultAddCapabilities = null;
        }
        return (A)this;
    }

    @Override
    public A withDefaultAddCapabilities(String ... defaultAddCapabilities) {
        if (this.defaultAddCapabilities != null) {
            this.defaultAddCapabilities.clear();
        }
        if (defaultAddCapabilities != null) {
            for (String item : defaultAddCapabilities) {
                this.addToDefaultAddCapabilities(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasDefaultAddCapabilities() {
        return this.defaultAddCapabilities != null && !this.defaultAddCapabilities.isEmpty();
    }

    @Override
    public A addNewDefaultAddCapability(String arg0) {
        return this.addToDefaultAddCapabilities(new String(arg0));
    }

    @Override
    public Boolean getDefaultAllowPrivilegeEscalation() {
        return this.defaultAllowPrivilegeEscalation;
    }

    @Override
    public A withDefaultAllowPrivilegeEscalation(Boolean defaultAllowPrivilegeEscalation) {
        this.defaultAllowPrivilegeEscalation = defaultAllowPrivilegeEscalation;
        return (A)this;
    }

    @Override
    public Boolean hasDefaultAllowPrivilegeEscalation() {
        return this.defaultAllowPrivilegeEscalation != null;
    }

    @Override
    public A addToForbiddenSysctls(Integer index, String item) {
        if (this.forbiddenSysctls == null) {
            this.forbiddenSysctls = new ArrayList<String>();
        }
        this.forbiddenSysctls.add(index, item);
        return (A)this;
    }

    @Override
    public A setToForbiddenSysctls(Integer index, String item) {
        if (this.forbiddenSysctls == null) {
            this.forbiddenSysctls = new ArrayList<String>();
        }
        this.forbiddenSysctls.set(index, item);
        return (A)this;
    }

    @Override
    public A addToForbiddenSysctls(String ... items) {
        if (this.forbiddenSysctls == null) {
            this.forbiddenSysctls = new ArrayList<String>();
        }
        for (String item : items) {
            this.forbiddenSysctls.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToForbiddenSysctls(Collection<String> items) {
        if (this.forbiddenSysctls == null) {
            this.forbiddenSysctls = new ArrayList<String>();
        }
        for (String item : items) {
            this.forbiddenSysctls.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromForbiddenSysctls(String ... items) {
        for (String item : items) {
            if (this.forbiddenSysctls == null) continue;
            this.forbiddenSysctls.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromForbiddenSysctls(Collection<String> items) {
        for (String item : items) {
            if (this.forbiddenSysctls == null) continue;
            this.forbiddenSysctls.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getForbiddenSysctls() {
        return this.forbiddenSysctls;
    }

    @Override
    public String getForbiddenSysctl(Integer index) {
        return this.forbiddenSysctls.get(index);
    }

    @Override
    public String getFirstForbiddenSysctl() {
        return this.forbiddenSysctls.get(0);
    }

    @Override
    public String getLastForbiddenSysctl() {
        return this.forbiddenSysctls.get(this.forbiddenSysctls.size() - 1);
    }

    @Override
    public String getMatchingForbiddenSysctl(Predicate<String> predicate) {
        for (String item : this.forbiddenSysctls) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingForbiddenSysctl(Predicate<String> predicate) {
        for (String item : this.forbiddenSysctls) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withForbiddenSysctls(List<String> forbiddenSysctls) {
        if (forbiddenSysctls != null) {
            this.forbiddenSysctls = new ArrayList<String>();
            for (String item : forbiddenSysctls) {
                this.addToForbiddenSysctls(item);
            }
        } else {
            this.forbiddenSysctls = null;
        }
        return (A)this;
    }

    @Override
    public A withForbiddenSysctls(String ... forbiddenSysctls) {
        if (this.forbiddenSysctls != null) {
            this.forbiddenSysctls.clear();
        }
        if (forbiddenSysctls != null) {
            for (String item : forbiddenSysctls) {
                this.addToForbiddenSysctls(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasForbiddenSysctls() {
        return this.forbiddenSysctls != null && !this.forbiddenSysctls.isEmpty();
    }

    @Override
    public A addNewForbiddenSysctl(String arg0) {
        return this.addToForbiddenSysctls(new String(arg0));
    }

    @Override
    @Deprecated
    public FSGroupStrategyOptions getFsGroup() {
        return this.fsGroup != null ? this.fsGroup.build() : null;
    }

    @Override
    public FSGroupStrategyOptions buildFsGroup() {
        return this.fsGroup != null ? this.fsGroup.build() : null;
    }

    @Override
    public A withFsGroup(FSGroupStrategyOptions fsGroup) {
        this._visitables.get("fsGroup").remove(this.fsGroup);
        if (fsGroup != null) {
            this.fsGroup = new FSGroupStrategyOptionsBuilder(fsGroup);
            this._visitables.get("fsGroup").add(this.fsGroup);
        }
        return (A)this;
    }

    @Override
    public Boolean hasFsGroup() {
        return this.fsGroup != null;
    }

    @Override
    public SecurityContextConstraintsFluent.FsGroupNested<A> withNewFsGroup() {
        return new FsGroupNestedImpl();
    }

    @Override
    public SecurityContextConstraintsFluent.FsGroupNested<A> withNewFsGroupLike(FSGroupStrategyOptions item) {
        return new FsGroupNestedImpl(item);
    }

    @Override
    public SecurityContextConstraintsFluent.FsGroupNested<A> editFsGroup() {
        return this.withNewFsGroupLike(this.getFsGroup());
    }

    @Override
    public SecurityContextConstraintsFluent.FsGroupNested<A> editOrNewFsGroup() {
        return this.withNewFsGroupLike(this.getFsGroup() != null ? this.getFsGroup() : new FSGroupStrategyOptionsBuilder().build());
    }

    @Override
    public SecurityContextConstraintsFluent.FsGroupNested<A> editOrNewFsGroupLike(FSGroupStrategyOptions item) {
        return this.withNewFsGroupLike(this.getFsGroup() != null ? this.getFsGroup() : item);
    }

    @Override
    public A addToGroups(Integer index, String item) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.add(index, item);
        return (A)this;
    }

    @Override
    public A setToGroups(Integer index, String item) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.set(index, item);
        return (A)this;
    }

    @Override
    public A addToGroups(String ... items) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        for (String item : items) {
            this.groups.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToGroups(Collection<String> items) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        for (String item : items) {
            this.groups.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromGroups(String ... items) {
        for (String item : items) {
            if (this.groups == null) continue;
            this.groups.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromGroups(Collection<String> items) {
        for (String item : items) {
            if (this.groups == null) continue;
            this.groups.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getGroups() {
        return this.groups;
    }

    @Override
    public String getGroup(Integer index) {
        return this.groups.get(index);
    }

    @Override
    public String getFirstGroup() {
        return this.groups.get(0);
    }

    @Override
    public String getLastGroup() {
        return this.groups.get(this.groups.size() - 1);
    }

    @Override
    public String getMatchingGroup(Predicate<String> predicate) {
        for (String item : this.groups) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingGroup(Predicate<String> predicate) {
        for (String item : this.groups) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withGroups(List<String> groups) {
        if (groups != null) {
            this.groups = new ArrayList<String>();
            for (String item : groups) {
                this.addToGroups(item);
            }
        } else {
            this.groups = null;
        }
        return (A)this;
    }

    @Override
    public A withGroups(String ... groups) {
        if (this.groups != null) {
            this.groups.clear();
        }
        if (groups != null) {
            for (String item : groups) {
                this.addToGroups(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasGroups() {
        return this.groups != null && !this.groups.isEmpty();
    }

    @Override
    public A addNewGroup(String arg0) {
        return this.addToGroups(new String(arg0));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public SecurityContextConstraintsFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public SecurityContextConstraintsFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public SecurityContextConstraintsFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public SecurityContextConstraintsFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public SecurityContextConstraintsFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public Integer getPriority() {
        return this.priority;
    }

    @Override
    public A withPriority(Integer priority) {
        this.priority = priority;
        return (A)this;
    }

    @Override
    public Boolean hasPriority() {
        return this.priority != null;
    }

    @Override
    public Boolean getReadOnlyRootFilesystem() {
        return this.readOnlyRootFilesystem;
    }

    @Override
    public A withReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem) {
        this.readOnlyRootFilesystem = readOnlyRootFilesystem;
        return (A)this;
    }

    @Override
    public Boolean hasReadOnlyRootFilesystem() {
        return this.readOnlyRootFilesystem != null;
    }

    @Override
    public A addToRequiredDropCapabilities(Integer index, String item) {
        if (this.requiredDropCapabilities == null) {
            this.requiredDropCapabilities = new ArrayList<String>();
        }
        this.requiredDropCapabilities.add(index, item);
        return (A)this;
    }

    @Override
    public A setToRequiredDropCapabilities(Integer index, String item) {
        if (this.requiredDropCapabilities == null) {
            this.requiredDropCapabilities = new ArrayList<String>();
        }
        this.requiredDropCapabilities.set(index, item);
        return (A)this;
    }

    @Override
    public A addToRequiredDropCapabilities(String ... items) {
        if (this.requiredDropCapabilities == null) {
            this.requiredDropCapabilities = new ArrayList<String>();
        }
        for (String item : items) {
            this.requiredDropCapabilities.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToRequiredDropCapabilities(Collection<String> items) {
        if (this.requiredDropCapabilities == null) {
            this.requiredDropCapabilities = new ArrayList<String>();
        }
        for (String item : items) {
            this.requiredDropCapabilities.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromRequiredDropCapabilities(String ... items) {
        for (String item : items) {
            if (this.requiredDropCapabilities == null) continue;
            this.requiredDropCapabilities.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRequiredDropCapabilities(Collection<String> items) {
        for (String item : items) {
            if (this.requiredDropCapabilities == null) continue;
            this.requiredDropCapabilities.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getRequiredDropCapabilities() {
        return this.requiredDropCapabilities;
    }

    @Override
    public String getRequiredDropCapability(Integer index) {
        return this.requiredDropCapabilities.get(index);
    }

    @Override
    public String getFirstRequiredDropCapability() {
        return this.requiredDropCapabilities.get(0);
    }

    @Override
    public String getLastRequiredDropCapability() {
        return this.requiredDropCapabilities.get(this.requiredDropCapabilities.size() - 1);
    }

    @Override
    public String getMatchingRequiredDropCapability(Predicate<String> predicate) {
        for (String item : this.requiredDropCapabilities) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingRequiredDropCapability(Predicate<String> predicate) {
        for (String item : this.requiredDropCapabilities) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withRequiredDropCapabilities(List<String> requiredDropCapabilities) {
        if (requiredDropCapabilities != null) {
            this.requiredDropCapabilities = new ArrayList<String>();
            for (String item : requiredDropCapabilities) {
                this.addToRequiredDropCapabilities(item);
            }
        } else {
            this.requiredDropCapabilities = null;
        }
        return (A)this;
    }

    @Override
    public A withRequiredDropCapabilities(String ... requiredDropCapabilities) {
        if (this.requiredDropCapabilities != null) {
            this.requiredDropCapabilities.clear();
        }
        if (requiredDropCapabilities != null) {
            for (String item : requiredDropCapabilities) {
                this.addToRequiredDropCapabilities(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRequiredDropCapabilities() {
        return this.requiredDropCapabilities != null && !this.requiredDropCapabilities.isEmpty();
    }

    @Override
    public A addNewRequiredDropCapability(String arg0) {
        return this.addToRequiredDropCapabilities(new String(arg0));
    }

    @Override
    @Deprecated
    public RunAsUserStrategyOptions getRunAsUser() {
        return this.runAsUser != null ? this.runAsUser.build() : null;
    }

    @Override
    public RunAsUserStrategyOptions buildRunAsUser() {
        return this.runAsUser != null ? this.runAsUser.build() : null;
    }

    @Override
    public A withRunAsUser(RunAsUserStrategyOptions runAsUser) {
        this._visitables.get("runAsUser").remove(this.runAsUser);
        if (runAsUser != null) {
            this.runAsUser = new RunAsUserStrategyOptionsBuilder(runAsUser);
            this._visitables.get("runAsUser").add(this.runAsUser);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRunAsUser() {
        return this.runAsUser != null;
    }

    @Override
    public A withNewRunAsUser(String type, Long uid, Long uidRangeMax, Long uidRangeMin) {
        return this.withRunAsUser(new RunAsUserStrategyOptions(type, uid, uidRangeMax, uidRangeMin));
    }

    @Override
    public SecurityContextConstraintsFluent.RunAsUserNested<A> withNewRunAsUser() {
        return new RunAsUserNestedImpl();
    }

    @Override
    public SecurityContextConstraintsFluent.RunAsUserNested<A> withNewRunAsUserLike(RunAsUserStrategyOptions item) {
        return new RunAsUserNestedImpl(item);
    }

    @Override
    public SecurityContextConstraintsFluent.RunAsUserNested<A> editRunAsUser() {
        return this.withNewRunAsUserLike(this.getRunAsUser());
    }

    @Override
    public SecurityContextConstraintsFluent.RunAsUserNested<A> editOrNewRunAsUser() {
        return this.withNewRunAsUserLike(this.getRunAsUser() != null ? this.getRunAsUser() : new RunAsUserStrategyOptionsBuilder().build());
    }

    @Override
    public SecurityContextConstraintsFluent.RunAsUserNested<A> editOrNewRunAsUserLike(RunAsUserStrategyOptions item) {
        return this.withNewRunAsUserLike(this.getRunAsUser() != null ? this.getRunAsUser() : item);
    }

    @Override
    @Deprecated
    public SELinuxContextStrategyOptions getSeLinuxContext() {
        return this.seLinuxContext != null ? this.seLinuxContext.build() : null;
    }

    @Override
    public SELinuxContextStrategyOptions buildSeLinuxContext() {
        return this.seLinuxContext != null ? this.seLinuxContext.build() : null;
    }

    @Override
    public A withSeLinuxContext(SELinuxContextStrategyOptions seLinuxContext) {
        this._visitables.get("seLinuxContext").remove(this.seLinuxContext);
        if (seLinuxContext != null) {
            this.seLinuxContext = new SELinuxContextStrategyOptionsBuilder(seLinuxContext);
            this._visitables.get("seLinuxContext").add(this.seLinuxContext);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSeLinuxContext() {
        return this.seLinuxContext != null;
    }

    @Override
    public SecurityContextConstraintsFluent.SeLinuxContextNested<A> withNewSeLinuxContext() {
        return new SeLinuxContextNestedImpl();
    }

    @Override
    public SecurityContextConstraintsFluent.SeLinuxContextNested<A> withNewSeLinuxContextLike(SELinuxContextStrategyOptions item) {
        return new SeLinuxContextNestedImpl(item);
    }

    @Override
    public SecurityContextConstraintsFluent.SeLinuxContextNested<A> editSeLinuxContext() {
        return this.withNewSeLinuxContextLike(this.getSeLinuxContext());
    }

    @Override
    public SecurityContextConstraintsFluent.SeLinuxContextNested<A> editOrNewSeLinuxContext() {
        return this.withNewSeLinuxContextLike(this.getSeLinuxContext() != null ? this.getSeLinuxContext() : new SELinuxContextStrategyOptionsBuilder().build());
    }

    @Override
    public SecurityContextConstraintsFluent.SeLinuxContextNested<A> editOrNewSeLinuxContextLike(SELinuxContextStrategyOptions item) {
        return this.withNewSeLinuxContextLike(this.getSeLinuxContext() != null ? this.getSeLinuxContext() : item);
    }

    @Override
    public A addToSeccompProfiles(Integer index, String item) {
        if (this.seccompProfiles == null) {
            this.seccompProfiles = new ArrayList<String>();
        }
        this.seccompProfiles.add(index, item);
        return (A)this;
    }

    @Override
    public A setToSeccompProfiles(Integer index, String item) {
        if (this.seccompProfiles == null) {
            this.seccompProfiles = new ArrayList<String>();
        }
        this.seccompProfiles.set(index, item);
        return (A)this;
    }

    @Override
    public A addToSeccompProfiles(String ... items) {
        if (this.seccompProfiles == null) {
            this.seccompProfiles = new ArrayList<String>();
        }
        for (String item : items) {
            this.seccompProfiles.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToSeccompProfiles(Collection<String> items) {
        if (this.seccompProfiles == null) {
            this.seccompProfiles = new ArrayList<String>();
        }
        for (String item : items) {
            this.seccompProfiles.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromSeccompProfiles(String ... items) {
        for (String item : items) {
            if (this.seccompProfiles == null) continue;
            this.seccompProfiles.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSeccompProfiles(Collection<String> items) {
        for (String item : items) {
            if (this.seccompProfiles == null) continue;
            this.seccompProfiles.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getSeccompProfiles() {
        return this.seccompProfiles;
    }

    @Override
    public String getSeccompProfile(Integer index) {
        return this.seccompProfiles.get(index);
    }

    @Override
    public String getFirstSeccompProfile() {
        return this.seccompProfiles.get(0);
    }

    @Override
    public String getLastSeccompProfile() {
        return this.seccompProfiles.get(this.seccompProfiles.size() - 1);
    }

    @Override
    public String getMatchingSeccompProfile(Predicate<String> predicate) {
        for (String item : this.seccompProfiles) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSeccompProfile(Predicate<String> predicate) {
        for (String item : this.seccompProfiles) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSeccompProfiles(List<String> seccompProfiles) {
        if (seccompProfiles != null) {
            this.seccompProfiles = new ArrayList<String>();
            for (String item : seccompProfiles) {
                this.addToSeccompProfiles(item);
            }
        } else {
            this.seccompProfiles = null;
        }
        return (A)this;
    }

    @Override
    public A withSeccompProfiles(String ... seccompProfiles) {
        if (this.seccompProfiles != null) {
            this.seccompProfiles.clear();
        }
        if (seccompProfiles != null) {
            for (String item : seccompProfiles) {
                this.addToSeccompProfiles(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSeccompProfiles() {
        return this.seccompProfiles != null && !this.seccompProfiles.isEmpty();
    }

    @Override
    public A addNewSeccompProfile(String arg0) {
        return this.addToSeccompProfiles(new String(arg0));
    }

    @Override
    @Deprecated
    public SupplementalGroupsStrategyOptions getSupplementalGroups() {
        return this.supplementalGroups != null ? this.supplementalGroups.build() : null;
    }

    @Override
    public SupplementalGroupsStrategyOptions buildSupplementalGroups() {
        return this.supplementalGroups != null ? this.supplementalGroups.build() : null;
    }

    @Override
    public A withSupplementalGroups(SupplementalGroupsStrategyOptions supplementalGroups) {
        this._visitables.get("supplementalGroups").remove(this.supplementalGroups);
        if (supplementalGroups != null) {
            this.supplementalGroups = new SupplementalGroupsStrategyOptionsBuilder(supplementalGroups);
            this._visitables.get("supplementalGroups").add(this.supplementalGroups);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSupplementalGroups() {
        return this.supplementalGroups != null;
    }

    @Override
    public SecurityContextConstraintsFluent.SupplementalGroupsNested<A> withNewSupplementalGroups() {
        return new SupplementalGroupsNestedImpl();
    }

    @Override
    public SecurityContextConstraintsFluent.SupplementalGroupsNested<A> withNewSupplementalGroupsLike(SupplementalGroupsStrategyOptions item) {
        return new SupplementalGroupsNestedImpl(item);
    }

    @Override
    public SecurityContextConstraintsFluent.SupplementalGroupsNested<A> editSupplementalGroups() {
        return this.withNewSupplementalGroupsLike(this.getSupplementalGroups());
    }

    @Override
    public SecurityContextConstraintsFluent.SupplementalGroupsNested<A> editOrNewSupplementalGroups() {
        return this.withNewSupplementalGroupsLike(this.getSupplementalGroups() != null ? this.getSupplementalGroups() : new SupplementalGroupsStrategyOptionsBuilder().build());
    }

    @Override
    public SecurityContextConstraintsFluent.SupplementalGroupsNested<A> editOrNewSupplementalGroupsLike(SupplementalGroupsStrategyOptions item) {
        return this.withNewSupplementalGroupsLike(this.getSupplementalGroups() != null ? this.getSupplementalGroups() : item);
    }

    @Override
    public A addToUsers(Integer index, String item) {
        if (this.users == null) {
            this.users = new ArrayList<String>();
        }
        this.users.add(index, item);
        return (A)this;
    }

    @Override
    public A setToUsers(Integer index, String item) {
        if (this.users == null) {
            this.users = new ArrayList<String>();
        }
        this.users.set(index, item);
        return (A)this;
    }

    @Override
    public A addToUsers(String ... items) {
        if (this.users == null) {
            this.users = new ArrayList<String>();
        }
        for (String item : items) {
            this.users.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToUsers(Collection<String> items) {
        if (this.users == null) {
            this.users = new ArrayList<String>();
        }
        for (String item : items) {
            this.users.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromUsers(String ... items) {
        for (String item : items) {
            if (this.users == null) continue;
            this.users.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromUsers(Collection<String> items) {
        for (String item : items) {
            if (this.users == null) continue;
            this.users.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getUsers() {
        return this.users;
    }

    @Override
    public String getUser(Integer index) {
        return this.users.get(index);
    }

    @Override
    public String getFirstUser() {
        return this.users.get(0);
    }

    @Override
    public String getLastUser() {
        return this.users.get(this.users.size() - 1);
    }

    @Override
    public String getMatchingUser(Predicate<String> predicate) {
        for (String item : this.users) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingUser(Predicate<String> predicate) {
        for (String item : this.users) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withUsers(List<String> users) {
        if (users != null) {
            this.users = new ArrayList<String>();
            for (String item : users) {
                this.addToUsers(item);
            }
        } else {
            this.users = null;
        }
        return (A)this;
    }

    @Override
    public A withUsers(String ... users) {
        if (this.users != null) {
            this.users.clear();
        }
        if (users != null) {
            for (String item : users) {
                this.addToUsers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasUsers() {
        return this.users != null && !this.users.isEmpty();
    }

    @Override
    public A addNewUser(String arg0) {
        return this.addToUsers(new String(arg0));
    }

    @Override
    public A addToVolumes(Integer index, String item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<String>();
        }
        this.volumes.add(index, item);
        return (A)this;
    }

    @Override
    public A setToVolumes(Integer index, String item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<String>();
        }
        this.volumes.set(index, item);
        return (A)this;
    }

    @Override
    public A addToVolumes(String ... items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<String>();
        }
        for (String item : items) {
            this.volumes.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumes(Collection<String> items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<String>();
        }
        for (String item : items) {
            this.volumes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumes(String ... items) {
        for (String item : items) {
            if (this.volumes == null) continue;
            this.volumes.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumes(Collection<String> items) {
        for (String item : items) {
            if (this.volumes == null) continue;
            this.volumes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getVolumes() {
        return this.volumes;
    }

    @Override
    public String getVolume(Integer index) {
        return this.volumes.get(index);
    }

    @Override
    public String getFirstVolume() {
        return this.volumes.get(0);
    }

    @Override
    public String getLastVolume() {
        return this.volumes.get(this.volumes.size() - 1);
    }

    @Override
    public String getMatchingVolume(Predicate<String> predicate) {
        for (String item : this.volumes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVolume(Predicate<String> predicate) {
        for (String item : this.volumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVolumes(List<String> volumes) {
        if (volumes != null) {
            this.volumes = new ArrayList<String>();
            for (String item : volumes) {
                this.addToVolumes(item);
            }
        } else {
            this.volumes = null;
        }
        return (A)this;
    }

    @Override
    public A withVolumes(String ... volumes) {
        if (this.volumes != null) {
            this.volumes.clear();
        }
        if (volumes != null) {
            for (String item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumes() {
        return this.volumes != null && !this.volumes.isEmpty();
    }

    @Override
    public A addNewVolume(String arg0) {
        return this.addToVolumes(new String(arg0));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityContextConstraintsFluentImpl that = (SecurityContextConstraintsFluentImpl)o;
        if (this.allowHostDirVolumePlugin != null ? !this.allowHostDirVolumePlugin.equals(that.allowHostDirVolumePlugin) : that.allowHostDirVolumePlugin != null) {
            return false;
        }
        if (this.allowHostIPC != null ? !this.allowHostIPC.equals(that.allowHostIPC) : that.allowHostIPC != null) {
            return false;
        }
        if (this.allowHostNetwork != null ? !this.allowHostNetwork.equals(that.allowHostNetwork) : that.allowHostNetwork != null) {
            return false;
        }
        if (this.allowHostPID != null ? !this.allowHostPID.equals(that.allowHostPID) : that.allowHostPID != null) {
            return false;
        }
        if (this.allowHostPorts != null ? !this.allowHostPorts.equals(that.allowHostPorts) : that.allowHostPorts != null) {
            return false;
        }
        if (this.allowPrivilegeEscalation != null ? !this.allowPrivilegeEscalation.equals(that.allowPrivilegeEscalation) : that.allowPrivilegeEscalation != null) {
            return false;
        }
        if (this.allowPrivilegedContainer != null ? !this.allowPrivilegedContainer.equals(that.allowPrivilegedContainer) : that.allowPrivilegedContainer != null) {
            return false;
        }
        if (this.allowedCapabilities != null ? !this.allowedCapabilities.equals(that.allowedCapabilities) : that.allowedCapabilities != null) {
            return false;
        }
        if (this.allowedFlexVolumes != null ? !this.allowedFlexVolumes.equals(that.allowedFlexVolumes) : that.allowedFlexVolumes != null) {
            return false;
        }
        if (this.allowedUnsafeSysctls != null ? !this.allowedUnsafeSysctls.equals(that.allowedUnsafeSysctls) : that.allowedUnsafeSysctls != null) {
            return false;
        }
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.defaultAddCapabilities != null ? !this.defaultAddCapabilities.equals(that.defaultAddCapabilities) : that.defaultAddCapabilities != null) {
            return false;
        }
        if (this.defaultAllowPrivilegeEscalation != null ? !this.defaultAllowPrivilegeEscalation.equals(that.defaultAllowPrivilegeEscalation) : that.defaultAllowPrivilegeEscalation != null) {
            return false;
        }
        if (this.forbiddenSysctls != null ? !this.forbiddenSysctls.equals(that.forbiddenSysctls) : that.forbiddenSysctls != null) {
            return false;
        }
        if (this.fsGroup != null ? !this.fsGroup.equals(that.fsGroup) : that.fsGroup != null) {
            return false;
        }
        if (this.groups != null ? !this.groups.equals(that.groups) : that.groups != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.priority != null ? !this.priority.equals(that.priority) : that.priority != null) {
            return false;
        }
        if (this.readOnlyRootFilesystem != null ? !this.readOnlyRootFilesystem.equals(that.readOnlyRootFilesystem) : that.readOnlyRootFilesystem != null) {
            return false;
        }
        if (this.requiredDropCapabilities != null ? !this.requiredDropCapabilities.equals(that.requiredDropCapabilities) : that.requiredDropCapabilities != null) {
            return false;
        }
        if (this.runAsUser != null ? !this.runAsUser.equals(that.runAsUser) : that.runAsUser != null) {
            return false;
        }
        if (this.seLinuxContext != null ? !this.seLinuxContext.equals(that.seLinuxContext) : that.seLinuxContext != null) {
            return false;
        }
        if (this.seccompProfiles != null ? !this.seccompProfiles.equals(that.seccompProfiles) : that.seccompProfiles != null) {
            return false;
        }
        if (this.supplementalGroups != null ? !this.supplementalGroups.equals(that.supplementalGroups) : that.supplementalGroups != null) {
            return false;
        }
        if (this.users != null ? !this.users.equals(that.users) : that.users != null) {
            return false;
        }
        if (this.volumes != null ? !this.volumes.equals(that.volumes) : that.volumes != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.allowHostDirVolumePlugin, this.allowHostIPC, this.allowHostNetwork, this.allowHostPID, this.allowHostPorts, this.allowPrivilegeEscalation, this.allowPrivilegedContainer, this.allowedCapabilities, this.allowedFlexVolumes, this.allowedUnsafeSysctls, this.apiVersion, this.defaultAddCapabilities, this.defaultAllowPrivilegeEscalation, this.forbiddenSysctls, this.fsGroup, this.groups, this.kind, this.metadata, this.priority, this.readOnlyRootFilesystem, this.requiredDropCapabilities, this.runAsUser, this.seLinuxContext, this.seccompProfiles, this.supplementalGroups, this.users, this.volumes, this.additionalProperties, super.hashCode());
    }

    public class SupplementalGroupsNestedImpl<N>
    extends SupplementalGroupsStrategyOptionsFluentImpl<SecurityContextConstraintsFluent.SupplementalGroupsNested<N>>
    implements SecurityContextConstraintsFluent.SupplementalGroupsNested<N>,
    Nested<N> {
        SupplementalGroupsStrategyOptionsBuilder builder;

        SupplementalGroupsNestedImpl(SupplementalGroupsStrategyOptions item) {
            this.builder = new SupplementalGroupsStrategyOptionsBuilder(this, item);
        }

        SupplementalGroupsNestedImpl() {
            this.builder = new SupplementalGroupsStrategyOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)SecurityContextConstraintsFluentImpl.this.withSupplementalGroups(this.builder.build());
        }

        @Override
        public N endSupplementalGroups() {
            return this.and();
        }
    }

    public class SeLinuxContextNestedImpl<N>
    extends SELinuxContextStrategyOptionsFluentImpl<SecurityContextConstraintsFluent.SeLinuxContextNested<N>>
    implements SecurityContextConstraintsFluent.SeLinuxContextNested<N>,
    Nested<N> {
        SELinuxContextStrategyOptionsBuilder builder;

        SeLinuxContextNestedImpl(SELinuxContextStrategyOptions item) {
            this.builder = new SELinuxContextStrategyOptionsBuilder(this, item);
        }

        SeLinuxContextNestedImpl() {
            this.builder = new SELinuxContextStrategyOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)SecurityContextConstraintsFluentImpl.this.withSeLinuxContext(this.builder.build());
        }

        @Override
        public N endSeLinuxContext() {
            return this.and();
        }
    }

    public class RunAsUserNestedImpl<N>
    extends RunAsUserStrategyOptionsFluentImpl<SecurityContextConstraintsFluent.RunAsUserNested<N>>
    implements SecurityContextConstraintsFluent.RunAsUserNested<N>,
    Nested<N> {
        RunAsUserStrategyOptionsBuilder builder;

        RunAsUserNestedImpl(RunAsUserStrategyOptions item) {
            this.builder = new RunAsUserStrategyOptionsBuilder(this, item);
        }

        RunAsUserNestedImpl() {
            this.builder = new RunAsUserStrategyOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)SecurityContextConstraintsFluentImpl.this.withRunAsUser(this.builder.build());
        }

        @Override
        public N endRunAsUser() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<SecurityContextConstraintsFluent.MetadataNested<N>>
    implements SecurityContextConstraintsFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)SecurityContextConstraintsFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class FsGroupNestedImpl<N>
    extends FSGroupStrategyOptionsFluentImpl<SecurityContextConstraintsFluent.FsGroupNested<N>>
    implements SecurityContextConstraintsFluent.FsGroupNested<N>,
    Nested<N> {
        FSGroupStrategyOptionsBuilder builder;

        FsGroupNestedImpl(FSGroupStrategyOptions item) {
            this.builder = new FSGroupStrategyOptionsBuilder(this, item);
        }

        FsGroupNestedImpl() {
            this.builder = new FSGroupStrategyOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)SecurityContextConstraintsFluentImpl.this.withFsGroup(this.builder.build());
        }

        @Override
        public N endFsGroup() {
            return this.and();
        }
    }

    public class AllowedFlexVolumesNestedImpl<N>
    extends AllowedFlexVolumeFluentImpl<SecurityContextConstraintsFluent.AllowedFlexVolumesNested<N>>
    implements SecurityContextConstraintsFluent.AllowedFlexVolumesNested<N>,
    Nested<N> {
        AllowedFlexVolumeBuilder builder;
        Integer index;

        AllowedFlexVolumesNestedImpl(Integer index, AllowedFlexVolume item) {
            this.index = index;
            this.builder = new AllowedFlexVolumeBuilder(this, item);
        }

        AllowedFlexVolumesNestedImpl() {
            this.index = -1;
            this.builder = new AllowedFlexVolumeBuilder(this);
        }

        @Override
        public N and() {
            return (N)SecurityContextConstraintsFluentImpl.this.setToAllowedFlexVolumes(this.index, this.builder.build());
        }

        @Override
        public N endAllowedFlexVolume() {
            return this.and();
        }
    }
}

