/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.BuildVolumeSource;
import io.fabric8.openshift.api.model.BuildVolumeSourceFluent;
import io.fabric8.openshift.api.model.BuildVolumeSourceFluentImpl;
import java.util.Objects;

public class BuildVolumeSourceBuilder
extends BuildVolumeSourceFluentImpl<BuildVolumeSourceBuilder>
implements VisitableBuilder<BuildVolumeSource, BuildVolumeSourceBuilder> {
    BuildVolumeSourceFluent<?> fluent;
    Boolean validationEnabled;

    public BuildVolumeSourceBuilder() {
        this(false);
    }

    public BuildVolumeSourceBuilder(Boolean validationEnabled) {
        this(new BuildVolumeSource(), validationEnabled);
    }

    public BuildVolumeSourceBuilder(BuildVolumeSourceFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public BuildVolumeSourceBuilder(BuildVolumeSourceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new BuildVolumeSource(), validationEnabled);
    }

    public BuildVolumeSourceBuilder(BuildVolumeSourceFluent<?> fluent, BuildVolumeSource instance) {
        this(fluent, instance, false);
    }

    public BuildVolumeSourceBuilder(BuildVolumeSourceFluent<?> fluent, BuildVolumeSource instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withConfigMap(instance.getConfigMap());
        fluent.withSecret(instance.getSecret());
        fluent.withType(instance.getType());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public BuildVolumeSourceBuilder(BuildVolumeSource instance) {
        this(instance, (Boolean)false);
    }

    public BuildVolumeSourceBuilder(BuildVolumeSource instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withConfigMap(instance.getConfigMap());
        this.withSecret(instance.getSecret());
        this.withType(instance.getType());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public BuildVolumeSource build() {
        BuildVolumeSource buildable = new BuildVolumeSource(this.fluent.getConfigMap(), this.fluent.getSecret(), this.fluent.getType());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildVolumeSourceBuilder that = (BuildVolumeSourceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

