/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import io.fabric8.kubernetes.api.KubernetesResourceMappingProvider;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Version;
import io.fabric8.kubernetes.model.util.Helper;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class KubernetesDeserializer
extends JsonDeserializer<KubernetesResource> {
    private static final String TEMPLATE_CLASS_NAME = "io.fabric8.openshift.api.model.Template";
    private static final String KIND = "kind";
    private static final String API_VERSION = "apiVersion";
    private static final Mapping mapping = new Mapping();
    private static final ThreadLocal<Boolean> IN_TEMPLATE = ThreadLocal.withInitial(() -> false);

    public static boolean isInTemplate() {
        return IN_TEMPLATE.get();
    }

    public KubernetesResource deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.readValueAsTree();
        if (node.isObject()) {
            return KubernetesDeserializer.fromObjectNode(jp, node);
        }
        if (node.isArray()) {
            return this.fromArrayNode(jp, node);
        }
        return null;
    }

    private KubernetesResource fromArrayNode(JsonParser jp, JsonNode node) throws IOException {
        Iterator iterator = node.elements();
        ArrayList<HasMetadata> list = new ArrayList<HasMetadata>();
        while (iterator.hasNext()) {
            KubernetesResource resource;
            JsonNode jsonNode = (JsonNode)iterator.next();
            if (!jsonNode.isObject() || !((resource = KubernetesDeserializer.fromObjectNode(jp, jsonNode)) instanceof HasMetadata)) continue;
            list.add((HasMetadata)resource);
        }
        return ((KubernetesListBuilder)new KubernetesListBuilder().withItems(list)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KubernetesResource fromObjectNode(JsonParser jp, JsonNode node) throws IOException {
        TypeKey key = KubernetesDeserializer.getKey(node);
        Class<? extends KubernetesResource> resourceType = mapping.getForKey(key);
        if (resourceType == null) {
            return (KubernetesResource)jp.getCodec().treeToValue((TreeNode)node, GenericKubernetesResource.class);
        }
        if (KubernetesResource.class.isAssignableFrom(resourceType)) {
            boolean inTemplate = false;
            if (TEMPLATE_CLASS_NAME.equals(resourceType.getName())) {
                inTemplate = true;
                IN_TEMPLATE.set(true);
            }
            try {
                KubernetesResource kubernetesResource = (KubernetesResource)jp.getCodec().treeToValue((TreeNode)node, resourceType);
                return kubernetesResource;
            }
            finally {
                if (inTemplate) {
                    IN_TEMPLATE.remove();
                }
            }
        }
        throw new JsonMappingException((Closeable)jp, String.format("There's a class loading issue, %s is registered as a KubernetesResource, but is not an instance of KubernetesResource", resourceType.getName()));
    }

    private static TypeKey getKey(JsonNode node) {
        JsonNode apiVersion = node.get(API_VERSION);
        JsonNode kind = node.get(KIND);
        return mapping.createKey(apiVersion != null ? apiVersion.textValue() : null, kind != null ? kind.textValue() : null);
    }

    public static void registerCustomKind(String kind, Class<? extends KubernetesResource> clazz) {
        KubernetesDeserializer.registerCustomKind(null, kind, clazz);
    }

    public static void registerCustomKind(String apiVersion, String kind, Class<? extends KubernetesResource> clazz) {
        mapping.registerKind(apiVersion, kind, clazz);
    }

    public static void registerProvider(KubernetesResourceMappingProvider provider) {
        mapping.registerProvider(provider);
    }

    static class Mapping {
        private static final String KEY_SEPARATOR = "#";
        private static final String[] PACKAGES = new String[]{"io.fabric8.kubernetes.api.model.", "io.fabric8.kubernetes.api.model.admission.v1.", "io.fabric8.kubernetes.api.model.admission.v1beta1.", "io.fabric8.kubernetes.api.model.admissionregistration.v1.", "io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.", "io.fabric8.kubernetes.api.model.authentication.", "io.fabric8.kubernetes.api.model.authorization.v1.", "io.fabric8.kubernetes.api.model.authorization.v1beta1.", "io.fabric8.kubernetes.api.model.apiextensions.v1.", "io.fabric8.kubernetes.api.model.apiextensions.v1beta1.", "io.fabric8.kubernetes.api.model.apps.", "io.fabric8.kubernetes.api.model.autoscaling.v1.", "io.fabric8.kubernetes.api.model.autoscaling.", "io.fabric8.kubernetes.api.model.autoscaling.v2beta1.", "io.fabric8.kubernetes.api.model.autoscaling.v2beta2.", "io.fabric8.kubernetes.api.model.batch.v1.", "io.fabric8.kubernetes.api.model.batch.v1beta1.", "io.fabric8.kubernetes.api.model.certificates.v1.", "io.fabric8.kubernetes.api.model.certificates.v1beta1.", "io.fabric8.kubernetes.api.model.coordination.v1.", "io.fabric8.kubernetes.api.model.coordination.", "io.fabric8.kubernetes.api.model.discovery.v1.", "io.fabric8.kubernetes.api.model.events.v1.", "io.fabric8.kubernetes.api.model.events.v1beta1.", "io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.", "io.fabric8.kubernetes.api.model.discovery.v1beta1.", "io.fabric8.kubernetes.api.model.metrics.v1beta1.", "io.fabric8.kubernetes.api.model.networking.v1.", "io.fabric8.kubernetes.api.model.networking.v1beta1.", "io.fabric8.kubernetes.api.model.policy.v1.", "io.fabric8.kubernetes.api.model.policy.v1beta1.", "io.fabric8.kubernetes.api.model.rbac.", "io.fabric8.kubernetes.api.model.storage.", "io.fabric8.kubernetes.api.model.scheduling.v1.", "io.fabric8.kubernetes.api.model.scheduling.v1beta1.", "io.fabric8.kubernetes.api.model.storage.", "io.fabric8.kubernetes.api.model.storage.v1beta1.", "io.fabric8.kubernetes.api.model.node.v1alpha1.", "io.fabric8.kubernetes.api.model.node.v1beta1.", "io.fabric8.openshift.api.model.", "io.fabric8.openshift.api.model.clusterautoscaling.v1.", "io.fabric8.openshift.api.model.clusterautoscaling.v1beta1.", "io.fabric8.openshift.api.model.runtime.", "io.fabric8.openshift.api.model.console.v1.", "io.fabric8.openshift.api.model.console.v1alpha1.", "io.fabric8.openshift.api.model.hive.v1.", "io.fabric8.openshift.api.model.installer.v1.", "io.fabric8.openshift.api.model.monitoring.v1.", "io.fabric8.openshift.api.model.machine.v1beta1.", "io.fabric8.openshift.api.model.operator.", "io.fabric8.openshift.api.model.operator.v1.", "io.fabric8.openshift.api.model.operator.v1alpha1.", "io.fabric8.openshift.api.model.imageregistry.v1.", "io.fabric8.openshift.api.model.operatorhub.manifests.", "io.fabric8.openshift.api.model.operatorhub.v1.", "io.fabric8.openshift.api.model.operatorhub.v1alpha1.", "io.fabric8.openshift.api.model.operatorhub.lifecyclemanager.v1.", "io.fabric8.openshift.api.model.machineconfig.v1.", "io.fabric8.openshift.api.model.tuned.v1.", "io.fabric8.openshift.api.model.whereabouts.v1alpha1.", "io.fabric8.openshift.api.model.storageversionmigrator.v1alpha1.", "io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.", "io.fabric8.openshift.api.model.miscellaneous.cncf.cni.v1.", "io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.", "io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.", "io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.", "io.fabric8.kubernetes.api.model.extensions."};
        private Map<TypeKey, Class<? extends KubernetesResource>> mappings = new ConcurrentHashMap<TypeKey, Class<? extends KubernetesResource>>();
        private Map<String, List<TypeKey>> internalMappings = new ConcurrentHashMap<String, List<TypeKey>>();

        Mapping() {
            this.registerAllProviders();
        }

        public Class<? extends KubernetesResource> getForKey(TypeKey key) {
            if (key == null) {
                return null;
            }
            Class<? extends KubernetesResource> clazz = this.mappings.get(key);
            if (clazz != null) {
                return clazz;
            }
            List<TypeKey> defaults = this.internalMappings.get(key.kind);
            if (defaults == null) {
                defaults = this.loadInternalTypes(key.kind);
                clazz = this.mappings.get(key);
                if (clazz != null) {
                    return clazz;
                }
            }
            TypeKey bestMatch = null;
            for (TypeKey typeKey : defaults) {
                if (key.apiGroup != null) {
                    if (!key.apiGroup.equals(typeKey.apiGroup)) continue;
                    bestMatch = typeKey;
                    break;
                }
                if (key.version != null && key.version.equals(typeKey.apiGroup)) {
                    bestMatch = typeKey;
                    break;
                }
                if (bestMatch != null) continue;
                bestMatch = typeKey;
            }
            if (bestMatch != null) {
                return this.mappings.get(bestMatch);
            }
            return null;
        }

        public void registerKind(String apiVersion, String kind, Class<? extends KubernetesResource> clazz) {
            this.mappings.put(this.createKey(apiVersion, kind), clazz);
        }

        public void registerProvider(KubernetesResourceMappingProvider provider) {
            if (provider == null) {
                return;
            }
            provider.getMappings().entrySet().stream().filter(entry -> KubernetesResource.class.isAssignableFrom((Class)entry.getValue())).forEach(e -> this.mappings.put(this.createKey((String)e.getKey()), (Class<? extends KubernetesResource>)e.getValue()));
        }

        TypeKey createKey(String apiVersion, String kind) {
            if (kind == null) {
                return null;
            }
            if (apiVersion == null) {
                return new TypeKey(kind, null, null);
            }
            String[] versionParts = new String[]{null, apiVersion};
            if (apiVersion.contains("/")) {
                versionParts = apiVersion.split("/", 2);
            }
            return new TypeKey(kind, versionParts[0], versionParts[1]);
        }

        TypeKey createKey(String key) {
            if (key.contains(KEY_SEPARATOR)) {
                String[] parts = key.split(KEY_SEPARATOR, 2);
                return this.createKey(parts[0], parts[1]);
            }
            return this.createKey(null, key);
        }

        private void registerAllProviders() {
            this.getAllMappingProviders().forEach(this::registerProvider);
        }

        Stream<KubernetesResourceMappingProvider> getAllMappingProviders() {
            Iterable currentThreadClassLoader = () -> ServiceLoader.load(KubernetesResourceMappingProvider.class, Thread.currentThread().getContextClassLoader()).iterator();
            Iterable classClassLoader = () -> ServiceLoader.load(KubernetesResourceMappingProvider.class, KubernetesDeserializer.class.getClassLoader()).iterator();
            return Stream.concat(StreamSupport.stream(currentThreadClassLoader.spliterator(), false), StreamSupport.stream(classClassLoader.spliterator(), false)).filter(this.distinctByClassName(Object::getClass));
        }

        private List<TypeKey> loadInternalTypes(String kind) {
            ArrayList<TypeKey> ordering = new ArrayList<TypeKey>();
            for (int i = 0; i < PACKAGES.length; ++i) {
                Class<? extends KubernetesResource> result = this.loadClassIfExists(PACKAGES[i] + kind);
                if (result == null) continue;
                TypeKey defaultKeyFromClass = this.getKeyFromClass(result);
                this.mappings.put(defaultKeyFromClass, result);
                ordering.add(defaultKeyFromClass);
            }
            this.internalMappings.put(kind, ordering);
            return ordering;
        }

        private TypeKey getKeyFromClass(Class<? extends KubernetesResource> clazz) {
            String apiGroup = Helper.getAnnotationValue(clazz, Group.class);
            String apiVersion = Helper.getAnnotationValue(clazz, Version.class);
            if (apiGroup != null && !apiGroup.isEmpty() && apiVersion != null && !apiVersion.isEmpty()) {
                return new TypeKey(clazz.getSimpleName(), apiGroup, apiVersion);
            }
            if (apiVersion != null && !apiVersion.isEmpty()) {
                return this.createKey(apiVersion, clazz.getSimpleName());
            }
            return new TypeKey(clazz.getSimpleName(), null, null);
        }

        private Class<? extends KubernetesResource> loadClassIfExists(String className) {
            try {
                Class<?> clazz = KubernetesDeserializer.class.getClassLoader().loadClass(className);
                if (!KubernetesResource.class.isAssignableFrom(clazz)) {
                    return null;
                }
                return clazz;
            }
            catch (Exception t) {
                return null;
            }
        }

        private Predicate<KubernetesResourceMappingProvider> distinctByClassName(Function<KubernetesResourceMappingProvider, Class<? extends KubernetesResourceMappingProvider>> mapperProvider) {
            ConcurrentHashMap.KeySetView existing = ConcurrentHashMap.newKeySet();
            return provider -> existing.add(((Class)mapperProvider.apply((KubernetesResourceMappingProvider)provider)).getName());
        }
    }

    static class TypeKey {
        final String kind;
        final String apiGroup;
        final String version;

        TypeKey(String kind, String apiGroup, String version) {
            this.kind = kind;
            this.apiGroup = apiGroup;
            this.version = version;
        }

        public int hashCode() {
            return Objects.hash(this.kind, this.apiGroup, this.version);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TypeKey)) {
                return false;
            }
            TypeKey o = (TypeKey)obj;
            return Objects.equals(this.kind, o.kind) && Objects.equals(this.apiGroup, o.apiGroup) && Objects.equals(this.version, o.version);
        }
    }
}

