/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.dsl.internal.build;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.EventList;
import io.fabric8.kubernetes.client.Handlers;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.Triggerable;
import io.fabric8.kubernetes.client.dsl.Typeable;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.dsl.base.OperationSupport;
import io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.utils.KubernetesResourceUtil;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigBuilder;
import io.fabric8.openshift.api.model.BuildConfigList;
import io.fabric8.openshift.api.model.BuildRequest;
import io.fabric8.openshift.api.model.WebHookTrigger;
import io.fabric8.openshift.client.OpenshiftClientContext;
import io.fabric8.openshift.client.dsl.BuildConfigOperation;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import io.fabric8.openshift.client.dsl.InputStreamable;
import io.fabric8.openshift.client.dsl.TimeoutInputStreamable;
import io.fabric8.openshift.client.dsl.buildconfig.AsFileTimeoutInputStreamable;
import io.fabric8.openshift.client.dsl.buildconfig.AuthorEmailable;
import io.fabric8.openshift.client.dsl.buildconfig.AuthorMessageAsFileTimeoutInputStreamable;
import io.fabric8.openshift.client.dsl.buildconfig.CommitterAuthorMessageAsFileTimeoutInputStreamable;
import io.fabric8.openshift.client.dsl.buildconfig.CommitterEmailable;
import io.fabric8.openshift.client.dsl.buildconfig.MessageAsFileTimeoutInputStreamable;
import io.fabric8.openshift.client.dsl.internal.BuildConfigOperationContext;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildConfigOperationsImpl
extends OpenShiftOperation<BuildConfig, BuildConfigList, BuildConfigResource<BuildConfig, Void, Build>>
implements BuildConfigOperation {
    private static final Logger logger = LoggerFactory.getLogger(BuildConfigOperationsImpl.class);
    public static final String BUILD_CONFIG_LABEL = "openshift.io/build-config.name";
    public static final String BUILD_CONFIG_ANNOTATION = "openshift.io/build-config.name";
    private final BuildConfigOperationContext buildConfigOperationContext;
    private final String secret;
    private final String triggerType;
    private final String authorName;
    private final String authorEmail;
    private final String committerName;
    private final String committerEmail;
    private final String commit;
    private final String message;
    private final String asFile;
    private final long timeout;
    private final TimeUnit timeoutUnit;

    public BuildConfigOperationsImpl(OpenshiftClientContext clientContext) {
        this(new BuildConfigOperationContext(), HasMetadataOperationsImpl.defaultContext(clientContext));
    }

    public BuildConfigOperationsImpl(BuildConfigOperationContext context, OperationContext superContext) {
        super(superContext.withApiGroupName("build.openshift.io").withPlural("buildconfigs"), BuildConfig.class, BuildConfigList.class);
        this.buildConfigOperationContext = context;
        this.triggerType = context.getTriggerType();
        this.secret = context.getSecret();
        this.authorName = context.getAuthorName();
        this.authorEmail = context.getAuthorEmail();
        this.committerName = context.getCommitterName();
        this.committerEmail = context.getCommitterEmail();
        this.commit = context.getCommit();
        this.message = context.getMessage();
        this.asFile = context.getAsFile();
        this.timeout = context.getTimeout();
        this.timeoutUnit = context.getTimeoutUnit();
    }

    public BuildConfigOperationsImpl newInstance(OperationContext context) {
        return new BuildConfigOperationsImpl(this.buildConfigOperationContext, context);
    }

    public BuildConfigOperationContext getContext() {
        return this.buildConfigOperationContext;
    }

    @Override
    public Build instantiate(BuildRequest request) {
        try {
            this.updateApiVersion(request);
            URL instantiationUrl = new URL(URLUtils.join(this.getResourceUrl().toString(), "instantiate"));
            HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().post("application/json", OperationSupport.JSON_MAPPER.writer().writeValueAsString((Object)request)).url(instantiationUrl);
            return this.handleResponse(requestBuilder, Build.class);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public CommitterAuthorMessageAsFileTimeoutInputStreamable<Build> instantiateBinary() {
        return this;
    }

    @Override
    public Void trigger(WebHookTrigger trigger) {
        try {
            String triggerUrl = URLUtils.join(this.getResourceUrl().toString(), "webhooks", this.secret, this.triggerType);
            HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().post("application/json", OperationSupport.JSON_MAPPER.writer().writeValueAsBytes((Object)trigger)).uri(triggerUrl).header("X-Github-Event", "push");
            this.handleResponse(requestBuilder, null);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
        return null;
    }

    @Override
    public Triggerable<WebHookTrigger, Void> withType(String triggerType) {
        return new BuildConfigOperationsImpl(this.getContext().withTriggerType(triggerType), this.context);
    }

    @Override
    public Build fromInputStream(InputStream inputStream) {
        return this.submitToApiServer(inputStream, -1L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Build fromFile(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException("Can't instantiate binary build from the specified file. The file does not exists");
        }
        try (FileInputStream is = new FileInputStream(file);){
            logger.debug("Uploading archive file \"{}\" as binary input for the build ...", (Object)file.getAbsolutePath());
            Build build = this.submitToApiServer(is, file.length());
            return build;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    private String getQueryParameters() throws MalformedURLException {
        StringBuilder sb = new StringBuilder();
        sb.append(URLUtils.join(this.getResourceUrl().toString(), "instantiatebinary"));
        if (Utils.isNotNullOrEmpty(this.name)) {
            sb.append("?name=").append(this.name);
        }
        if (Utils.isNotNullOrEmpty(this.namespace)) {
            sb.append("&namespace=").append(this.namespace);
        }
        if (Utils.isNotNullOrEmpty(this.message)) {
            sb.append("&commit=").append(this.message);
        }
        if (!Utils.isNullOrEmpty(this.authorName)) {
            sb.append("&revision.authorName=").append(this.authorName);
        }
        if (!Utils.isNullOrEmpty(this.authorEmail)) {
            sb.append("&revision.authorEmail=").append(this.authorEmail);
        }
        if (!Utils.isNullOrEmpty(this.committerName)) {
            sb.append("&revision.committerName=").append(this.committerName);
        }
        if (!Utils.isNullOrEmpty(this.committerEmail)) {
            sb.append("&revision.committerEmail=").append(this.committerEmail);
        }
        if (!Utils.isNullOrEmpty(this.commit)) {
            sb.append("&revision.commit=").append(this.commit);
        }
        if (!Utils.isNullOrEmpty(this.asFile)) {
            sb.append("&asFile=").append(this.asFile);
        }
        return sb.toString();
    }

    @Override
    public TimeoutInputStreamable<Build> asFile(String fileName) {
        return new BuildConfigOperationsImpl(this.getContext().withAsFile(fileName), this.context);
    }

    @Override
    public MessageAsFileTimeoutInputStreamable<Build> withAuthorEmail(String email) {
        return new BuildConfigOperationsImpl(this.getContext().withAuthorEmail(email), this.context);
    }

    @Override
    public AuthorMessageAsFileTimeoutInputStreamable<Build> withCommitterEmail(String committerEmail) {
        return new BuildConfigOperationsImpl(this.getContext().withCommitterEmail(committerEmail), this.context);
    }

    @Override
    public AsFileTimeoutInputStreamable<Build> withMessage(String message) {
        return new BuildConfigOperationsImpl(this.getContext().withMessage(message), this.context);
    }

    @Override
    public AuthorEmailable<MessageAsFileTimeoutInputStreamable<Build>> withAuthorName(String authorName) {
        return new BuildConfigOperationsImpl(this.getContext().withAuthorName(authorName), this.context);
    }

    @Override
    public CommitterEmailable<AuthorMessageAsFileTimeoutInputStreamable<Build>> withCommitterName(String committerName) {
        return new BuildConfigOperationsImpl(this.getContext().withCommitterName(committerName), this.context);
    }

    @Override
    public InputStreamable<Build> withTimeout(long timeout, TimeUnit unit) {
        return new BuildConfigOperationsImpl(this.getContext().withTimeout(timeout).withTimeoutUnit(unit), this.context);
    }

    @Override
    public InputStreamable<Build> withTimeoutInMillis(long timeoutInMillis) {
        return this.withTimeout(timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public Typeable<Triggerable<WebHookTrigger, Void>> withSecret(String secret) {
        return new BuildConfigOperationsImpl(this.getContext().withSecret(secret), this.context);
    }

    @Override
    protected VisitableBuilder<BuildConfig, ?> createVisitableBuilder(BuildConfig item) {
        return new BuildConfigBuilder(item);
    }

    protected Build submitToApiServer(InputStream inputStream, long contentLength) {
        try {
            HttpClient newClient = this.httpClient.newBuilder().readTimeout(this.timeout, this.timeoutUnit).writeTimeout(this.timeout, this.timeoutUnit).build();
            HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().post("application/octet-stream", inputStream, contentLength).expectContinue().uri(this.getQueryParameters());
            return this.handleResponse(newClient, requestBuilder, Build.class);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(e);
        }
        catch (Throwable e) {
            logger.error("Failed to upload archive file for the build: {}", (Object)this.name);
            logger.error("Please check cluster events via `oc get events` to see what could have possibly gone wrong");
            throw new KubernetesClientException("Can't instantiate binary build, due to error reading/writing stream. Can be caused if the output stream was closed by the server.See if something's wrong in recent events in Cluster = " + this.getRecentEvents(), e);
        }
    }

    protected String getRecentEvents() {
        StringBuilder eventsAsStrBuilder = new StringBuilder();
        List<Event> recentEventList = ((EventList)Handlers.getOperation(Event.class, EventList.class, this.context).inNamespace(this.namespace).list()).getItems();
        KubernetesResourceUtil.sortEventListBasedOnTimestamp(recentEventList);
        for (int i = 0; i < 10 && i < recentEventList.size(); ++i) {
            Event event = recentEventList.get(i);
            eventsAsStrBuilder.append(event.getReason()).append(" ").append(event.getMetadata().getName()).append(" ").append(event.getMessage()).append("\n");
        }
        return eventsAsStrBuilder.toString();
    }
}

