/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.RoleBinding;
import io.fabric8.openshift.api.model.RoleBindingFluent;
import io.fabric8.openshift.api.model.RoleBindingFluentImpl;
import java.util.Objects;

public class RoleBindingBuilder
extends RoleBindingFluentImpl<RoleBindingBuilder>
implements VisitableBuilder<RoleBinding, RoleBindingBuilder> {
    RoleBindingFluent<?> fluent;
    Boolean validationEnabled;

    public RoleBindingBuilder() {
        this(false);
    }

    public RoleBindingBuilder(Boolean validationEnabled) {
        this(new RoleBinding(), validationEnabled);
    }

    public RoleBindingBuilder(RoleBindingFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public RoleBindingBuilder(RoleBindingFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new RoleBinding(), validationEnabled);
    }

    public RoleBindingBuilder(RoleBindingFluent<?> fluent, RoleBinding instance) {
        this(fluent, instance, false);
    }

    public RoleBindingBuilder(RoleBindingFluent<?> fluent, RoleBinding instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withGroupNames(instance.getGroupNames());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withRoleRef(instance.getRoleRef());
        fluent.withSubjects(instance.getSubjects());
        fluent.withUserNames(instance.getUserNames());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public RoleBindingBuilder(RoleBinding instance) {
        this(instance, (Boolean)false);
    }

    public RoleBindingBuilder(RoleBinding instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withGroupNames(instance.getGroupNames());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRoleRef(instance.getRoleRef());
        this.withSubjects(instance.getSubjects());
        this.withUserNames(instance.getUserNames());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public RoleBinding build() {
        RoleBinding buildable = new RoleBinding(this.fluent.getApiVersion(), this.fluent.getGroupNames(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getRoleRef(), this.fluent.getSubjects(), this.fluent.getUserNames());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RoleBindingBuilder that = (RoleBindingBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

