/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.server.mock;

import io.fabric8.kubernetes.api.model.RootPathsBuilder;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import io.fabric8.kubernetes.client.VersionInfo;
import io.fabric8.kubernetes.client.http.TlsVersion;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.DefaultMockServer;
import io.fabric8.mockwebserver.ServerRequest;
import io.fabric8.mockwebserver.ServerResponse;
import io.fabric8.mockwebserver.dsl.DelayPathable;
import io.fabric8.mockwebserver.dsl.ReturnOrWebsocketable;
import io.fabric8.mockwebserver.dsl.TimesOnceableOrHttpHeaderable;
import io.fabric8.mockwebserver.internal.MockDispatcher;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockWebServer;

public class KubernetesMockServer
extends DefaultMockServer {
    private static final Context context = new Context(Serialization.jsonMapper());
    private final Map<ServerRequest, Queue<ServerResponse>> responses;
    private final VersionInfo versionInfo;

    public KubernetesMockServer() {
        this(true);
    }

    public KubernetesMockServer(boolean useHttps) {
        this(new MockWebServer(), new HashMap<ServerRequest, Queue<ServerResponse>>(), useHttps);
    }

    public KubernetesMockServer(MockWebServer server, Map<ServerRequest, Queue<ServerResponse>> responses, boolean useHttps) {
        this(context, server, responses, useHttps);
    }

    public KubernetesMockServer(Context context, MockWebServer server, Map<ServerRequest, Queue<ServerResponse>> responses, boolean useHttps) {
        this(context, server, responses, (Dispatcher)new MockDispatcher(responses), useHttps);
    }

    public KubernetesMockServer(Context context, MockWebServer server, Map<ServerRequest, Queue<ServerResponse>> responses, Dispatcher dispatcher, boolean useHttps) {
        this(context, server, responses, dispatcher, useHttps, new VersionInfo.Builder().withMajor("0").withMinor("0").build());
    }

    public KubernetesMockServer(Context context, MockWebServer server, Map<ServerRequest, Queue<ServerResponse>> responses, Dispatcher dispatcher, boolean useHttps, VersionInfo versionInfo) {
        super(context, server, responses, dispatcher, useHttps);
        this.responses = responses;
        this.versionInfo = versionInfo;
    }

    public void onStart() {
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)((DelayPathable)this.expect().get()).withPath("/")).andReturn(200, (Object)((RootPathsBuilder)new RootPathsBuilder().addToPaths(this.getRootPaths())).build())).always();
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)((DelayPathable)this.expect().get()).withPath("/version")).andReturn(200, (Object)this.versionInfo)).always();
    }

    public void init() {
        this.start();
    }

    public void init(InetAddress address, int port) {
        this.start(address, port);
    }

    public void destroy() {
        this.shutdown();
    }

    public String[] getRootPaths() {
        return new String[]{"/api", "/apis/extensions"};
    }

    public NamespacedKubernetesClient createClient() {
        Config config = this.getMockConfiguration();
        return new DefaultKubernetesClient(config);
    }

    public void clearExpectations() {
        this.responses.clear();
    }

    protected Config getMockConfiguration() {
        return ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder(Config.empty()).withMasterUrl(this.url("/"))).withTrustCerts(true)).withTlsVersions(TlsVersion.TLS_1_2)).withNamespace("test")).withHttp2Disable(true)).build();
    }
}

